/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.driver.ApprovalResult;
import org.apache.tinkerpop.gremlin.driver.ChooseEndpointStrategy;
import org.apache.tinkerpop.gremlin.driver.Connection;
import org.apache.tinkerpop.gremlin.driver.Endpoint;
import org.apache.tinkerpop.gremlin.driver.EndpointClient;
import org.apache.tinkerpop.gremlin.driver.EndpointCollection;
import org.apache.tinkerpop.gremlin.driver.exception.NoHostAvailableException;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EndpointClientCollection
implements Iterable<EndpointClient> {
    private final List<EndpointClient> endpointClients;
    private final EndpointCollection rejectedEndpoints;
    private static final Logger logger = LoggerFactory.getLogger(EndpointClientCollection.class);

    EndpointClientCollection() {
        this(new EndpointCollection());
    }

    EndpointClientCollection(EndpointCollection rejectedEndpoints) {
        this(new ArrayList<EndpointClient>(), rejectedEndpoints);
    }

    EndpointClientCollection(List<EndpointClient> endpointClients) {
        this(endpointClients, new EndpointCollection());
    }

    EndpointClientCollection(List<EndpointClient> endpointClients, EndpointCollection rejectedEndpoints) {
        this.rejectedEndpoints = rejectedEndpoints;
        this.endpointClients = endpointClients;
    }

    public List<EndpointClient> getSurvivingEndpointClients(EndpointCollection acceptedEndpoints) {
        ArrayList<EndpointClient> results = new ArrayList<EndpointClient>();
        for (EndpointClient endpointClient : this.endpointClients) {
            Endpoint endpoint = endpointClient.endpoint();
            if (!acceptedEndpoints.containsEndpoint(endpoint)) continue;
            logger.info("Retaining client for {}", (Object)endpoint.getAddress());
            results.add(endpointClient);
        }
        return results;
    }

    public Connection chooseConnection(RequestMessage msg, ChooseEndpointStrategy strategy) throws TimeoutException {
        EndpointClient endpointClient = strategy.choose(this);
        if (!endpointClient.isAvailable()) {
            logger.debug("No connections available for {}", (Object)endpointClient.endpoint().getAddress());
            return null;
        }
        String address = endpointClient.endpoint().getAddress();
        try {
            Connection connection = endpointClient.client().chooseConnection(msg);
            if (connection.isClosing()) {
                logger.debug("Connection is closing: {}", (Object)address);
                return null;
            }
            if (connection.isDead()) {
                logger.debug("Connection is dead: {}", (Object)address);
                return null;
            }
            return connection;
        }
        catch (NullPointerException e) {
            logger.debug("NullPointerException: {}", (Object)address, (Object)e);
            return null;
        }
        catch (NoHostAvailableException e) {
            logger.debug("No connection available: {}", (Object)address, (Object)e);
            return null;
        }
    }

    public EndpointClient get(int index) {
        return this.endpointClients.get(index);
    }

    public int size() {
        return this.endpointClients.size();
    }

    public boolean isEmpty() {
        return this.endpointClients.isEmpty();
    }

    @Override
    public Iterator<EndpointClient> iterator() {
        return this.endpointClients.iterator();
    }

    public Stream<EndpointClient> stream() {
        return this.endpointClients.stream();
    }

    public EndpointCollection endpoints() {
        List endpoints = this.endpointClients.stream().map(e -> e.endpoint()).collect(Collectors.toList());
        return new EndpointCollection(endpoints);
    }

    public boolean hasRejectedEndpoints() {
        return !this.rejectedEndpoints.isEmpty();
    }

    public Collection<String> rejectionReasons() {
        return this.rejectedEndpoints.stream().map(e -> e.getAnnotations().getOrDefault(ApprovalResult.REJECTED_REASON_ANNOTATION, "unknown")).collect(Collectors.toSet());
    }
}

