/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class NeptuneInstanceMetadata {
    private static final Collection<String> AVAILABLE_STATES = Arrays.asList("available", "backing-up", "modifying", "upgrading");
    private String instanceId;
    private String role;
    private String endpoint;
    private String status;
    private String availabilityZone;
    private String instanceType;
    private final Map<String, String> tags = new HashMap<String, String>();

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public void setTags(Map<String, String> tags) {
        this.tags.clear();
        this.tags.putAll(tags);
    }

    public NeptuneInstanceMetadata withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public NeptuneInstanceMetadata withRole(String role) {
        this.setRole(role);
        return this;
    }

    public NeptuneInstanceMetadata withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public NeptuneInstanceMetadata withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public NeptuneInstanceMetadata withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public NeptuneInstanceMetadata withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public NeptuneInstanceMetadata withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getRole() {
        return this.role;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getStatus() {
        return this.status;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public boolean hasTag(String tag) {
        return this.tags.containsKey(tag);
    }

    public String getTag(String tag) {
        return this.tags.get(tag);
    }

    public String getTag(String tag, String defaultValue) {
        if (!this.tags.containsKey(tag)) {
            return defaultValue;
        }
        return this.tags.get(tag);
    }

    public boolean hasTag(String tag, String value) {
        return this.hasTag(tag) && this.getTag(tag).equals(value);
    }

    @JsonIgnore
    public boolean isAvailable() {
        return this.endpoint != null && AVAILABLE_STATES.contains(this.getStatus().toLowerCase());
    }

    @JsonIgnore
    public boolean isPrimary() {
        return this.getRole().equalsIgnoreCase("writer");
    }

    @JsonIgnore
    public boolean isReader() {
        return this.getRole().equalsIgnoreCase("reader");
    }

    public String toString() {
        return "NeptuneInstanceProperties{instanceId='" + this.instanceId + '\'' + ", endpoint='" + this.endpoint + '\'' + ", status='" + this.status + '\'' + ", availabilityZone='" + this.availabilityZone + '\'' + ", instanceType='" + this.instanceType + '\'' + ", tags=" + this.tags + '}';
    }
}

