/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.neptune.AmazonNeptune;
import com.amazonaws.services.neptune.AmazonNeptuneClientBuilder;
import com.amazonaws.services.neptune.model.AmazonNeptuneException;
import com.amazonaws.services.neptune.model.DBCluster;
import com.amazonaws.services.neptune.model.DBClusterMember;
import com.amazonaws.services.neptune.model.DescribeDBClustersRequest;
import com.amazonaws.services.neptune.model.DescribeDBClustersResult;
import com.amazonaws.services.neptune.model.DescribeDBInstancesRequest;
import com.amazonaws.services.neptune.model.DescribeDBInstancesResult;
import com.amazonaws.services.neptune.model.Filter;
import com.amazonaws.services.neptune.model.ListTagsForResourceRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.neptune.cluster.ClusterEndpointsFetchStrategy;
import software.amazon.neptune.cluster.ClusterMetadataFetchStrategy;
import software.amazon.neptune.cluster.EndpointsSelector;
import software.amazon.neptune.cluster.NeptuneClusterMetadata;
import software.amazon.neptune.cluster.NeptuneInstanceMetadata;
import software.amazon.utils.RegionUtils;

public class GetEndpointsFromNeptuneManagementApi
implements ClusterEndpointsFetchStrategy,
ClusterMetadataFetchStrategy {
    private static final Logger logger = LoggerFactory.getLogger(GetEndpointsFromNeptuneManagementApi.class);
    private static final Map<String, Map<String, String>> instanceTags = new HashMap<String, Map<String, String>>();
    private final String clusterId;
    private final String region;
    private final String iamProfile;
    private final AWSCredentialsProvider credentials;
    private final Collection<EndpointsSelector> selectors;
    private final AtomicReference<Map<EndpointsSelector, Collection<String>>> previousResults = new AtomicReference();
    private final AtomicReference<NeptuneClusterMetadata> previousClusterMetadata = new AtomicReference();

    public GetEndpointsFromNeptuneManagementApi(String clusterId, Collection<EndpointsSelector> selectors) {
        this(clusterId, selectors, RegionUtils.getCurrentRegionName());
    }

    public GetEndpointsFromNeptuneManagementApi(String clusterId, Collection<EndpointsSelector> selectors, String region) {
        this(clusterId, selectors, region, "default");
    }

    public GetEndpointsFromNeptuneManagementApi(String clusterId, Collection<EndpointsSelector> selectors, String region, String iamProfile) {
        this(clusterId, selectors, region, iamProfile, null);
    }

    public GetEndpointsFromNeptuneManagementApi(String clusterId, Collection<EndpointsSelector> selectors, String region, AWSCredentialsProvider credentials) {
        this(clusterId, selectors, region, "default", credentials);
    }

    private GetEndpointsFromNeptuneManagementApi(String clusterId, Collection<EndpointsSelector> selectors, String region, String iamProfile, AWSCredentialsProvider credentials) {
        this.clusterId = clusterId;
        this.selectors = selectors;
        this.region = region;
        this.iamProfile = iamProfile;
        this.credentials = credentials;
    }

    @Override
    public NeptuneClusterMetadata getClusterMetadata() {
        try {
            AmazonNeptuneClientBuilder builder = AmazonNeptuneClientBuilder.standard();
            if (StringUtils.isNotEmpty((CharSequence)this.region)) {
                builder = (AmazonNeptuneClientBuilder)builder.withRegion(this.region);
            }
            if (this.credentials != null) {
                builder = (AmazonNeptuneClientBuilder)builder.withCredentials(this.credentials);
            } else if (!this.iamProfile.equals("default")) {
                builder = (AmazonNeptuneClientBuilder)builder.withCredentials((AWSCredentialsProvider)new ProfileCredentialsProvider(this.iamProfile));
            }
            AmazonNeptune neptune = (AmazonNeptune)builder.build();
            DescribeDBClustersResult describeDBClustersResult = neptune.describeDBClusters(new DescribeDBClustersRequest().withDBClusterIdentifier(this.clusterId));
            if (describeDBClustersResult.getDBClusters().isEmpty()) {
                throw new IllegalStateException(String.format("Unable to find cluster %s", this.clusterId));
            }
            DBCluster dbCluster = (DBCluster)describeDBClustersResult.getDBClusters().get(0);
            String clusterEndpoint = dbCluster.getEndpoint();
            String readerEndpoint = dbCluster.getReaderEndpoint();
            List dbClusterMembers = dbCluster.getDBClusterMembers();
            Optional<DBClusterMember> clusterWriter = dbClusterMembers.stream().filter(DBClusterMember::isClusterWriter).findFirst();
            String primary = clusterWriter.map(DBClusterMember::getDBInstanceIdentifier).orElse("");
            List replicas = dbClusterMembers.stream().filter(dbClusterMember -> dbClusterMember.isClusterWriter() == false).map(DBClusterMember::getDBInstanceIdentifier).collect(Collectors.toList());
            DescribeDBInstancesRequest describeDBInstancesRequest = new DescribeDBInstancesRequest().withFilters(Collections.singletonList(new Filter().withName("db-cluster-id").withValues(new String[]{dbCluster.getDBClusterIdentifier()})));
            DescribeDBInstancesResult describeDBInstancesResult = neptune.describeDBInstances(describeDBInstancesRequest);
            ArrayList<NeptuneInstanceMetadata> instances = new ArrayList<NeptuneInstanceMetadata>();
            describeDBInstancesResult.getDBInstances().forEach(c -> {
                String role = "unknown";
                if (primary.equals(c.getDBInstanceIdentifier())) {
                    role = "writer";
                }
                if (replicas.contains(c.getDBInstanceIdentifier())) {
                    role = "reader";
                }
                String address = c.getEndpoint() == null ? null : c.getEndpoint().getAddress();
                instances.add(new NeptuneInstanceMetadata().withInstanceId(c.getDBInstanceIdentifier()).withRole(role).withEndpoint(address).withStatus(c.getDBInstanceStatus()).withAvailabilityZone(c.getAvailabilityZone()).withInstanceType(c.getDBInstanceClass()).withTags(this.getTags(c.getDBInstanceArn(), neptune)));
            });
            neptune.shutdown();
            return new NeptuneClusterMetadata().withInstances(instances).withClusterEndpoint(clusterEndpoint).withReaderEndpoint(readerEndpoint);
        }
        catch (AmazonNeptuneException e) {
            if (e.getErrorCode().equals("Throttling")) {
                logger.warn("Calls to the Neptune Management API are being throttled. Reduce the refresh rate and stagger refresh agent requests, or use a NeptuneEndpointsInfoLambda proxy.");
                NeptuneClusterMetadata previous = this.previousClusterMetadata.get();
                if (previous != null) {
                    return previous;
                }
                throw e;
            }
            throw e;
        }
    }

    @Override
    public Map<EndpointsSelector, Collection<String>> getAddresses() {
        NeptuneClusterMetadata clusterMetadata = this.getClusterMetadata();
        HashMap<EndpointsSelector, Collection<String>> results = new HashMap<EndpointsSelector, Collection<String>>();
        for (EndpointsSelector selector : this.selectors) {
            results.put(selector, selector.getEndpoints(clusterMetadata.getClusterEndpoint(), clusterMetadata.getReaderEndpoint(), clusterMetadata.getInstances()));
        }
        return results;
    }

    private Map<String, String> getTags(String dbInstanceArn, AmazonNeptune neptune) {
        if (instanceTags.containsKey(dbInstanceArn)) {
            return instanceTags.get(dbInstanceArn);
        }
        List tagList = neptune.listTagsForResource(new ListTagsForResourceRequest().withResourceName(dbInstanceArn)).getTagList();
        HashMap<String, String> tags = new HashMap<String, String>();
        tagList.forEach(t -> tags.put(t.getKey(), t.getValue()));
        instanceTags.put(dbInstanceArn, tags);
        return tags;
    }
}

