/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam.internals;

import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.auth.credentials.WebIdentityTokenFileCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FullJitterBackoffStrategy;
import software.amazon.awssdk.core.retry.conditions.AndRetryCondition;
import software.amazon.awssdk.core.retry.conditions.MaxNumberOfRetriesCondition;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryOnExceptionsCondition;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.profiles.ProfileFileSupplier;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.endpoints.StsEndpointParams;
import software.amazon.awssdk.services.sts.endpoints.StsEndpointProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;

public class MSKCredentialProvider
implements AwsCredentialsProvider,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MSKCredentialProvider.class);
    private static final String AWS_PROFILE_NAME_KEY = "awsProfileName";
    private static final String AWS_ROLE_ARN_KEY = "awsRoleArn";
    private static final String AWS_ROLE_EXTERNAL_ID = "awsRoleExternalId";
    private static final String AWS_ROLE_ACCESS_KEY_ID = "awsRoleAccessKeyId";
    private static final String AWS_ROLE_SECRET_ACCESS_KEY = "awsRoleSecretAccessKey";
    private static final String AWS_ROLE_SESSION_KEY = "awsRoleSessionName";
    private static final String AWS_ROLE_SESSION_TOKEN = "awsRoleSessionToken";
    private static final String AWS_STS_REGION = "awsStsRegion";
    private static final String AWS_DEBUG_CREDS_KEY = "awsDebugCreds";
    private static final String AWS_SHOULD_USE_FIPS = "awsShouldUseFips";
    private static final String AWS_MAX_RETRIES = "awsMaxRetries";
    private static final String AWS_MAX_BACK_OFF_TIME_MS = "awsMaxBackOffTimeMs";
    private static final String GLOBAL_REGION = "aws-global";
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final int DEFAULT_MAX_BACK_OFF_TIME_MS = 5000;
    private static final Duration BASE_DELAY = Duration.ofMillis(500L);
    private final List<AutoCloseable> closeableProviders;
    private final AwsCredentialsProvider compositeDelegate;
    private final Boolean shouldDebugCreds;
    private final String stsRegion;
    private final RetryPolicy retryPolicy;

    public MSKCredentialProvider(Map<String, ?> options) {
        this(new ProviderBuilder(options));
    }

    MSKCredentialProvider(ProviderBuilder builder) {
        this(builder.getProviders(), builder.shouldDebugCreds(), builder.getStsRegion(), builder.getMaxRetries(), builder.getMaxBackOffTimeMs());
    }

    MSKCredentialProvider(List<AwsCredentialsProvider> providers, Boolean shouldDebugCreds, String stsRegion, int maxRetries, int maxBackOffTimeMs) {
        AwsCredentialsProviderChain.Builder chain = AwsCredentialsProviderChain.builder();
        chain.credentialsProviders(providers);
        chain.addCredentialsProvider(this.getDefaultProvider());
        this.compositeDelegate = chain.build();
        this.closeableProviders = providers.stream().filter(p -> p instanceof AutoCloseable).map(p -> (AutoCloseable)p).collect(Collectors.toList());
        this.shouldDebugCreds = shouldDebugCreds;
        this.stsRegion = stsRegion;
        FullJitterBackoffStrategy backoffStrategy = FullJitterBackoffStrategy.builder().baseDelay(BASE_DELAY).maxBackoffTime(Duration.ofMillis(maxBackOffTimeMs)).build();
        if (maxRetries > 0) {
            AndRetryCondition retryCondition = AndRetryCondition.create((RetryCondition[])new RetryCondition[]{RetryOnExceptionsCondition.create((Class[])new Class[]{SdkClientException.class}), MaxNumberOfRetriesCondition.create((int)maxRetries)});
            this.retryPolicy = RetryPolicy.builder().retryCondition((RetryCondition)retryCondition).backoffStrategy((BackoffStrategy)backoffStrategy).build();
        } else {
            this.retryPolicy = RetryPolicy.builder().retryCondition(RetryCondition.none()).backoffStrategy((BackoffStrategy)backoffStrategy).build();
        }
    }

    protected AwsCredentialsProvider getDefaultProvider() {
        return AwsCredentialsProviderChain.of((AwsCredentialsProvider[])new AwsCredentialsProvider[]{EnvironmentVariableCredentialsProvider.create(), SystemPropertyCredentialsProvider.create(), WebIdentityTokenFileCredentialsProvider.builder().asyncCredentialUpdateEnabled(Boolean.valueOf(true)).build(), ProfileCredentialsProvider.builder().profileFile((Supplier)ProfileFileSupplier.defaultSupplier()).build(), ((ContainerCredentialsProvider.Builder)ContainerCredentialsProvider.builder().asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build(), ((InstanceProfileCredentialsProvider.Builder)InstanceProfileCredentialsProvider.builder().asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build()});
    }

    public AwsCredentials resolveCredentials() {
        AwsCredentials credentials = this.loadCredentialsWithRetry();
        if (credentials != null && this.shouldDebugCreds.booleanValue() && log.isDebugEnabled()) {
            this.logCallerIdentity(credentials);
        }
        return credentials;
    }

    private AwsCredentials loadCredentialsWithRetry() {
        RetryPolicyContext retryPolicyContext = RetryPolicyContext.builder().build();
        boolean shouldTry = true;
        try {
            while (shouldTry) {
                try {
                    AwsCredentials credentials = this.compositeDelegate.resolveCredentials();
                    if (credentials == null) {
                        throw SdkClientException.create((String)"Composite delegate returned empty credentials.");
                    }
                    return credentials;
                }
                catch (SdkException se) {
                    log.warn("Exception loading credentials. Retry Attempts: {}", (Object)retryPolicyContext.retriesAttempted(), (Object)se);
                    retryPolicyContext = this.createRetryPolicyContext(se, retryPolicyContext.retriesAttempted());
                    shouldTry = this.retryPolicy.retryCondition().shouldRetry(retryPolicyContext);
                    if (shouldTry) {
                        Thread.sleep(this.retryPolicy.backoffStrategy().computeDelayBeforeNextRetry(retryPolicyContext).toMillis());
                        retryPolicyContext = this.createRetryPolicyContext(retryPolicyContext.exception(), retryPolicyContext.retriesAttempted() + 1);
                        continue;
                    }
                    throw se;
                }
            }
            throw SdkClientException.create((String)("loadCredentialsWithRetry in unexpected location " + retryPolicyContext.totalRequests()), (Throwable)retryPolicyContext.exception());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for credentials.", ie);
        }
    }

    private RetryPolicyContext createRetryPolicyContext(SdkException sdkException, int retriesAttempted) {
        return RetryPolicyContext.builder().exception(sdkException).retriesAttempted(retriesAttempted).build();
    }

    private void logCallerIdentity(AwsCredentials credentials) {
        try {
            StsClient stsClient = this.getStsClientForDebuggingCreds(credentials);
            GetCallerIdentityResponse response = stsClient.getCallerIdentity();
            log.debug("The identity of the credentials is {}", (Object)response.toString());
        }
        catch (Exception e) {
            log.warn("Error identifying caller identity. If this is not transient, does this application haveaccess to AWS STS?", (Throwable)e);
        }
    }

    StsClient getStsClientForDebuggingCreds(AwsCredentials credentials) {
        return (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials))).region(Region.of((String)this.stsRegion))).build();
    }

    @Override
    public void close() {
        this.closeableProviders.stream().forEach(p -> {
            try {
                p.close();
            }
            catch (Exception e) {
                log.warn("Error closing credential provider", (Throwable)e);
            }
        });
    }

    Boolean getShouldDebugCreds() {
        return this.shouldDebugCreds;
    }

    public static class ProviderBuilder {
        private final Map<String, ?> optionsMap;

        public ProviderBuilder(Map<String, ?> optionsMap) {
            this.optionsMap = optionsMap;
            if (log.isDebugEnabled()) {
                log.debug("Number of options to configure credential provider {}", (Object)optionsMap.size());
            }
        }

        public List<AwsCredentialsProvider> getProviders() {
            ArrayList<AwsCredentialsProvider> providers = new ArrayList<AwsCredentialsProvider>();
            this.getProfileProvider().ifPresent(providers::add);
            this.getStsRoleProvider().ifPresent(providers::add);
            return providers;
        }

        public Boolean shouldDebugCreds() {
            return Optional.ofNullable(this.optionsMap.get(MSKCredentialProvider.AWS_DEBUG_CREDS_KEY)).map(d -> d.equals("true")).orElse(false);
        }

        public Boolean shouldUseFips() {
            return Optional.ofNullable(this.optionsMap.get(MSKCredentialProvider.AWS_SHOULD_USE_FIPS)).map(d -> d.equals("true")).orElse(false);
        }

        public String getStsRegion() {
            return Optional.ofNullable((String)this.optionsMap.get(MSKCredentialProvider.AWS_STS_REGION)).orElse(MSKCredentialProvider.GLOBAL_REGION);
        }

        public int getMaxRetries() {
            return Optional.ofNullable(this.optionsMap.get(MSKCredentialProvider.AWS_MAX_RETRIES)).map(p -> (String)p).map(Integer::parseInt).orElse(3);
        }

        public int getMaxBackOffTimeMs() {
            return Optional.ofNullable(this.optionsMap.get(MSKCredentialProvider.AWS_MAX_BACK_OFF_TIME_MS)).map(p -> (String)p).map(Integer::parseInt).orElse(5000);
        }

        public URI buildEndpointConfiguration(Region stsRegion) {
            StsEndpointParams params = StsEndpointParams.builder().region(stsRegion).build();
            try {
                return ((Endpoint)StsEndpointProvider.defaultProvider().resolveEndpoint(params).get()).url();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private StsClientBuilder getStsClientBuilder(Region stsRegion, Boolean shouldUseFips) {
            StsClientBuilder builder = (StsClientBuilder)StsClient.builder().region(stsRegion);
            if (stsRegion != Region.AWS_GLOBAL && !shouldUseFips.booleanValue()) {
                log.debug("Using STS Endpoint override");
                builder.endpointOverride(this.buildEndpointConfiguration(stsRegion));
            }
            return builder;
        }

        private Optional<ProfileCredentialsProvider> getProfileProvider() {
            return Optional.ofNullable(this.optionsMap.get(MSKCredentialProvider.AWS_PROFILE_NAME_KEY)).map(p -> {
                if (log.isDebugEnabled()) {
                    log.debug("Profile name {}", p);
                }
                return this.createEnhancedProfileCredentialsProvider((String)p);
            });
        }

        ProfileCredentialsProvider createEnhancedProfileCredentialsProvider(String p) {
            return ProfileCredentialsProvider.builder().profileName(p).profileFile((Supplier)ProfileFileSupplier.defaultSupplier()).build();
        }

        private Optional<StsAssumeRoleCredentialsProvider> getStsRoleProvider() {
            return Optional.ofNullable(this.optionsMap.get(MSKCredentialProvider.AWS_ROLE_ARN_KEY)).map(p -> {
                if (log.isDebugEnabled()) {
                    log.debug("Role ARN {}", p);
                }
                String sessionName = Optional.ofNullable((String)this.optionsMap.get(MSKCredentialProvider.AWS_ROLE_SESSION_KEY)).orElse("aws-msk-iam-auth");
                String stsRegion = this.getStsRegion();
                Boolean shouldUseFIPs = this.shouldUseFips();
                String accessKey = this.optionsMap.getOrDefault(MSKCredentialProvider.AWS_ROLE_ACCESS_KEY_ID, null);
                String secretKey = this.optionsMap.getOrDefault(MSKCredentialProvider.AWS_ROLE_SECRET_ACCESS_KEY, null);
                String sessionToken = this.optionsMap.getOrDefault(MSKCredentialProvider.AWS_ROLE_SESSION_TOKEN, null);
                String externalId = this.optionsMap.getOrDefault(MSKCredentialProvider.AWS_ROLE_EXTERNAL_ID, null);
                if (accessKey != null && secretKey != null) {
                    StaticCredentialsProvider credentials = StaticCredentialsProvider.create((AwsCredentials)(sessionToken != null ? AwsSessionCredentials.create((String)accessKey, (String)secretKey, (String)sessionToken) : AwsBasicCredentials.create((String)accessKey, (String)secretKey)));
                    return this.createSTSRoleCredentialProvider((String)p, sessionName, stsRegion, (AwsCredentialsProvider)credentials, shouldUseFIPs);
                }
                if (externalId != null) {
                    return this.createSTSRoleCredentialProvider((String)p, externalId, sessionName, stsRegion, shouldUseFIPs);
                }
                return this.createSTSRoleCredentialProvider((String)p, sessionName, stsRegion, shouldUseFIPs);
            });
        }

        StsAssumeRoleCredentialsProvider createSTSRoleCredentialProvider(String roleArn, String sessionName, String stsRegion, Boolean shouldUseFips) {
            AssumeRoleRequest roleRequest = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(sessionName).build();
            StsClient stsClient = (StsClient)this.getStsClientBuilder(Region.of((String)stsRegion), shouldUseFips).build();
            return ((StsAssumeRoleCredentialsProvider.Builder)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(roleRequest).asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build();
        }

        StsAssumeRoleCredentialsProvider createSTSRoleCredentialProvider(String roleArn, String sessionName, String stsRegion, AwsCredentialsProvider credentials, Boolean shouldUseFips) {
            AssumeRoleRequest roleRequest = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(sessionName).build();
            StsClient stsClient = (StsClient)((StsClientBuilder)this.getStsClientBuilder(Region.of((String)stsRegion), shouldUseFips).credentialsProvider(credentials)).build();
            return ((StsAssumeRoleCredentialsProvider.Builder)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(roleRequest).asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build();
        }

        StsAssumeRoleCredentialsProvider createSTSRoleCredentialProvider(String roleArn, String externalId, String sessionName, String stsRegion, Boolean shouldUseFips) {
            AssumeRoleRequest roleRequest = (AssumeRoleRequest)AssumeRoleRequest.builder().externalId(externalId).roleArn(roleArn).roleSessionName(sessionName).build();
            return ((StsAssumeRoleCredentialsProvider.Builder)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient((StsClient)this.getStsClientBuilder(Region.of((String)stsRegion), shouldUseFips).build())).refreshRequest(roleRequest).asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build();
        }
    }
}

