/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import lombok.NonNull;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.msk.auth.iam.IAMOAuthBearerToken;
import software.amazon.msk.auth.iam.internals.AWS4SignedPayloadGenerator;
import software.amazon.msk.auth.iam.internals.AuthenticationRequestParams;
import software.amazon.msk.auth.iam.internals.MSKCredentialProvider;
import software.amazon.msk.auth.iam.internals.UserAgentUtils;

public class IAMOAuthBearerLoginCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(IAMOAuthBearerLoginCallbackHandler.class);
    private static final String USER_AGENT_KEY = "User-Agent";
    private final AWS4SignedPayloadGenerator aws4Signer = new AWS4SignedPayloadGenerator();
    private AwsCredentialsProvider credentialsProvider;
    private AwsRegionProvider awsRegionProvider;
    private boolean configured = false;

    public boolean configured() {
        return this.configured;
    }

    public void configure(Map<String, ?> configs, @NonNull String saslMechanism, @NonNull List<AppConfigurationEntry> jaasConfigEntries) {
        if (saslMechanism == null) {
            throw new NullPointerException("saslMechanism is marked non-null but is null");
        }
        if (jaasConfigEntries == null) {
            throw new NullPointerException("jaasConfigEntries is marked non-null but is null");
        }
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        Optional<AppConfigurationEntry> configEntry = jaasConfigEntries.stream().filter(j -> OAuthBearerLoginModule.class.getCanonicalName().equals(j.getLoginModuleName())).findFirst();
        this.credentialsProvider = configEntry.map(c -> new MSKCredentialProvider(c.getOptions())).orElse((AwsCredentialsProvider)DefaultCredentialsProvider.create());
        this.awsRegionProvider = new DefaultAwsRegionProviderChain();
        this.configured = true;
    }

    public void close() {
        try {
            if (this.credentialsProvider instanceof AutoCloseable) {
                ((AutoCloseable)this.credentialsProvider).close();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error closing provider", (Throwable)e);
        }
    }

    public void handle(@NonNull Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null) {
            throw new NullPointerException("callbacks is marked non-null but is null");
        }
        if (!this.configured()) {
            throw new IllegalStateException("Callback handler not configured");
        }
        for (Callback callback : callbacks) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Type information for callback: " + IAMOAuthBearerLoginCallbackHandler.debugClassString(callback.getClass()) + " from " + IAMOAuthBearerLoginCallbackHandler.debugClassString(this.getClass()));
            }
            if (callback instanceof OAuthBearerTokenCallback) {
                try {
                    this.handleCallback((OAuthBearerTokenCallback)callback);
                    continue;
                }
                catch (URISyntaxException | ParseException e) {
                    throw new MalformedURLException(e.getMessage());
                }
            }
            String message = "Unsupported callback type: " + IAMOAuthBearerLoginCallbackHandler.debugClassString(callback.getClass()) + " from " + IAMOAuthBearerLoginCallbackHandler.debugClassString(this.getClass());
            throw new UnsupportedCallbackException(callback, message);
        }
    }

    private void handleCallback(OAuthBearerTokenCallback callback) throws IOException, URISyntaxException, ParseException {
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had a token already");
        }
        AwsCredentials awsCredentials = this.credentialsProvider.resolveCredentials();
        String tokenValue = this.generateTokenValue(awsCredentials, this.getCurrentRegion());
        callback.token(this.getOAuthBearerToken(tokenValue));
    }

    private String generateTokenValue(@NonNull AwsCredentials awsCredentials, @NonNull Region region) {
        if (awsCredentials == null) {
            throw new NullPointerException("awsCredentials is marked non-null but is null");
        }
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        String userAgentValue = UserAgentUtils.getUserAgentValue();
        AuthenticationRequestParams authenticationRequestParams = AuthenticationRequestParams.create(this.getHostName(region), awsCredentials, userAgentValue);
        SdkHttpFullRequest.Builder requestBuilder = this.aws4Signer.presignRequest(authenticationRequestParams).toBuilder();
        requestBuilder.appendRawQueryParameter(USER_AGENT_KEY, userAgentValue);
        SdkHttpFullRequest fullRequest = requestBuilder.build();
        String signedUrl = fullRequest.getUri().toString();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(signedUrl.getBytes(StandardCharsets.UTF_8));
    }

    private String getHostName(Region region) {
        return String.format("kafka.%s.amazonaws.com", region.toString());
    }

    private Region getCurrentRegion() throws IOException {
        try {
            return this.awsRegionProvider.getRegion();
        }
        catch (SdkClientException exception) {
            throw new IOException("AWS region could not be resolved.");
        }
    }

    private OAuthBearerToken getOAuthBearerToken(String token) throws URISyntaxException, ParseException {
        return new IAMOAuthBearerToken(token);
    }

    static String debugClassString(Class<?> clazz) {
        return "class: " + clazz.getName() + " classloader: " + clazz.getClassLoader().toString();
    }
}

