/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam.internals;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.WebIdentityTokenCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.msk.auth.iam.internals.EnhancedProfileCredentialsProvider;

public class MSKCredentialProvider
implements AWSCredentialsProvider,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MSKCredentialProvider.class);
    private static final String AWS_PROFILE_NAME_KEY = "awsProfileName";
    private static final String AWS_ROLE_ARN_KEY = "awsRoleArn";
    private static final String AWS_ROLE_SESSION_KEY = "awsRoleSessionName";
    private static final String AWS_STS_REGION = "awsStsRegion";
    private static final String AWS_DEBUG_CREDS_KEY = "awsDebugCreds";
    private final List<AutoCloseable> closeableProviders;
    private final AWSCredentialsProvider compositeDelegate;
    private final Boolean shouldDebugCreds;
    private final String stsRegion;

    public MSKCredentialProvider(Map<String, ?> options) {
        this(new ProviderBuilder(options));
    }

    MSKCredentialProvider(ProviderBuilder builder) {
        this(builder.getProviders(), builder.shouldDebugCreds(), builder.getStsRegion());
    }

    MSKCredentialProvider(List<AWSCredentialsProvider> providers, Boolean shouldDebugCreds, String stsRegion) {
        ArrayList<AWSCredentialsProvider> delegateList = new ArrayList<AWSCredentialsProvider>(providers);
        delegateList.add((AWSCredentialsProvider)this.getDefaultProvider());
        this.compositeDelegate = new AWSCredentialsProviderChain(delegateList);
        this.closeableProviders = providers.stream().filter(p -> p instanceof AutoCloseable).map(p -> (AutoCloseable)p).collect(Collectors.toList());
        this.shouldDebugCreds = shouldDebugCreds;
        this.stsRegion = stsRegion;
    }

    protected AWSCredentialsProviderChain getDefaultProvider() {
        return new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider(), WebIdentityTokenCredentialsProvider.create(), new EnhancedProfileCredentialsProvider(), new EC2ContainerCredentialsProviderWrapper()});
    }

    public AWSCredentials getCredentials() {
        AWSCredentials credentials = this.compositeDelegate.getCredentials();
        if (credentials != null && this.shouldDebugCreds.booleanValue() && log.isDebugEnabled()) {
            this.logCallerIdentity(credentials);
        }
        return credentials;
    }

    private void logCallerIdentity(AWSCredentials credentials) {
        AWSSecurityTokenService stsClient = this.getStsClientForDebuggingCreds(credentials);
        GetCallerIdentityResult response = stsClient.getCallerIdentity(new GetCallerIdentityRequest());
        log.debug("The identity of the credentials is {}", (Object)response.toString());
    }

    AWSSecurityTokenService getStsClientForDebuggingCreds(final AWSCredentials credentials) {
        return (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(this.stsRegion)).withCredentials(new AWSCredentialsProvider(){

            public AWSCredentials getCredentials() {
                return credentials;
            }

            public void refresh() {
            }
        })).build();
    }

    public void refresh() {
        this.compositeDelegate.refresh();
    }

    @Override
    public void close() {
        this.closeableProviders.stream().forEach(p -> {
            try {
                p.close();
            }
            catch (Exception e) {
                log.warn("Error closing credential provider", (Throwable)e);
            }
        });
    }

    Boolean getShouldDebugCreds() {
        return this.shouldDebugCreds;
    }

    public static class ProviderBuilder {
        private final Map<String, ?> optionsMap;

        public ProviderBuilder(Map<String, ?> optionsMap) {
            this.optionsMap = optionsMap;
            if (log.isDebugEnabled()) {
                log.debug("Number of options to configure credential provider {}", (Object)optionsMap.size());
            }
        }

        public List<AWSCredentialsProvider> getProviders() {
            ArrayList<AWSCredentialsProvider> providers = new ArrayList<AWSCredentialsProvider>();
            this.getProfileProvider().ifPresent(providers::add);
            this.getStsRoleProvider().ifPresent(providers::add);
            return providers;
        }

        public Boolean shouldDebugCreds() {
            return Optional.ofNullable(this.optionsMap.get(MSKCredentialProvider.AWS_DEBUG_CREDS_KEY)).map(d -> d.equals("true")).orElse(false);
        }

        public String getStsRegion() {
            return Optional.ofNullable((String)this.optionsMap.get(MSKCredentialProvider.AWS_STS_REGION)).orElse("aws-global");
        }

        private Optional<EnhancedProfileCredentialsProvider> getProfileProvider() {
            return Optional.ofNullable(this.optionsMap.get(MSKCredentialProvider.AWS_PROFILE_NAME_KEY)).map(p -> {
                if (log.isDebugEnabled()) {
                    log.debug("Profile name {}", p);
                }
                return this.createEnhancedProfileCredentialsProvider((String)p);
            });
        }

        EnhancedProfileCredentialsProvider createEnhancedProfileCredentialsProvider(String p) {
            return new EnhancedProfileCredentialsProvider(p);
        }

        private Optional<STSAssumeRoleSessionCredentialsProvider> getStsRoleProvider() {
            return Optional.ofNullable(this.optionsMap.get(MSKCredentialProvider.AWS_ROLE_ARN_KEY)).map(p -> {
                if (log.isDebugEnabled()) {
                    log.debug("Role ARN {}", p);
                }
                String sessionName = Optional.ofNullable((String)this.optionsMap.get(MSKCredentialProvider.AWS_ROLE_SESSION_KEY)).orElse("aws-msk-iam-auth");
                String stsRegion = this.getStsRegion();
                return this.createSTSRoleCredentialProvider((String)p, sessionName, stsRegion);
            });
        }

        STSAssumeRoleSessionCredentialsProvider createSTSRoleCredentialProvider(String roleArn, String sessionName, String stsRegion) {
            AWSSecurityTokenService stsClient = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(stsRegion)).build();
            return new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, sessionName).withStsClient(stsClient).build();
        }
    }
}

