/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import lombok.NonNull;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.msk.auth.iam.IAMLoginModule;
import software.amazon.msk.auth.iam.internals.AWSCredentialsCallback;
import software.amazon.msk.auth.iam.internals.MSKCredentialProvider;

public class IAMClientCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(IAMClientCallbackHandler.class);
    private AWSCredentialsProvider provider;

    public void configure(Map<String, ?> configs, @NonNull String saslMechanism, @NonNull List<AppConfigurationEntry> jaasConfigEntries) {
        if (saslMechanism == null) {
            throw new NullPointerException("saslMechanism is marked non-null but is null");
        }
        if (jaasConfigEntries == null) {
            throw new NullPointerException("jaasConfigEntries is marked non-null but is null");
        }
        if (!"AWS_MSK_IAM".equals(saslMechanism)) {
            throw new IllegalArgumentException("Unexpected SASL mechanism: " + saslMechanism);
        }
        Optional<AppConfigurationEntry> configEntry = jaasConfigEntries.stream().filter(j -> IAMLoginModule.class.getCanonicalName().equals(j.getLoginModuleName())).findFirst();
        this.provider = configEntry.map(c -> new MSKCredentialProvider(c.getOptions())).orElse((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    public void close() {
    }

    public void handle(@NonNull Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null) {
            throw new NullPointerException("callbacks is marked non-null but is null");
        }
        for (Callback callback : callbacks) {
            if (!(callback instanceof AWSCredentialsCallback)) {
                throw new UnsupportedCallbackException(callback);
            }
            this.handleCallback((AWSCredentialsCallback)callback);
        }
    }

    protected void handleCallback(AWSCredentialsCallback callback) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Selecting provider {} to load credentials", (Object)this.provider.getClass().getName());
        }
        try {
            this.provider.refresh();
            callback.setAwsCredentials(this.provider.getCredentials());
        }
        catch (Exception e) {
            callback.setLoadingException(e);
        }
    }
}

