/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.utilities;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import io.burt.jmespath.JmesPath;
import io.burt.jmespath.RuntimeConfiguration;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.Function;
import io.burt.jmespath.function.FunctionRegistry;
import io.burt.jmespath.jackson.JacksonRuntime;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import software.amazon.lambda.powertools.utilities.jmespath.Base64Function;
import software.amazon.lambda.powertools.utilities.jmespath.Base64GZipFunction;
import software.amazon.lambda.powertools.utilities.jmespath.JsonFunction;

public final class JsonConfig {
    private static final Supplier<ObjectMapper> objectMapperSupplier = () -> ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).defaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.USE_DEFAULTS))).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true)).addModule((Module)new JodaModule())).build();
    private static final ThreadLocal<ObjectMapper> om = ThreadLocal.withInitial(objectMapperSupplier);
    private final FunctionRegistry defaultFunctions = FunctionRegistry.defaultRegistry();
    private final FunctionRegistry customFunctions = this.defaultFunctions.extend(new Function[]{new Base64Function(), new Base64GZipFunction(), new JsonFunction()});
    private final RuntimeConfiguration configuration = new RuntimeConfiguration.Builder().withSilentTypeErrors(true).withFunctionRegistry(this.customFunctions).build();
    private JmesPath<JsonNode> jmesPath = new JacksonRuntime(this.configuration, this.getObjectMapper());

    private JsonConfig() {
    }

    public static JsonConfig get() {
        return ConfigHolder.instance;
    }

    public ObjectMapper getObjectMapper() {
        return om.get();
    }

    public static <T> TypeReference<T> toTypeReference(final Class<T> clazz) {
        return new TypeReference<T>(){

            public Type getType() {
                return clazz;
            }
        };
    }

    public JmesPath<JsonNode> getJmesPath() {
        return this.jmesPath;
    }

    public <T extends BaseFunction> void addFunction(T function) {
        FunctionRegistry functionRegistryWithExtendedFunctions = this.configuration.functionRegistry().extend(new Function[]{function});
        RuntimeConfiguration updatedConfig = new RuntimeConfiguration.Builder().withFunctionRegistry(functionRegistryWithExtendedFunctions).build();
        this.jmesPath = new JacksonRuntime(updatedConfig, this.getObjectMapper());
    }

    private static final class ConfigHolder {
        private static final JsonConfig instance = new JsonConfig();

        private ConfigHolder() {
        }
    }
}

