/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters.cache;

import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;

public class DataStore {
    private final ConcurrentHashMap<String, ValueNode> store = new ConcurrentHashMap();

    public void put(String key, Object value, Instant time) {
        this.store.put(key, new ValueNode(value, time));
    }

    public void remove(String Key) {
        this.store.remove(Key);
    }

    public Object get(String key) {
        ValueNode node = this.store.get(key);
        return node != null ? node.value : null;
    }

    public boolean hasExpired(String key, Instant now) {
        boolean hasExpired;
        boolean bl = hasExpired = !this.store.containsKey(key) || now.isAfter(this.store.get((Object)key).time);
        if (hasExpired) {
            this.remove(key);
        }
        return hasExpired;
    }

    static class ValueNode {
        public final Object value;
        public final Instant time;

        public ValueNode(Object value, Instant time) {
            this.value = value;
            this.time = time;
        }
    }
}

