/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.lambda.powertools.parameters.BaseProvider;
import software.amazon.lambda.powertools.parameters.DynamoDbProvider;
import software.amazon.lambda.powertools.parameters.SSMProvider;
import software.amazon.lambda.powertools.parameters.SecretsProvider;
import software.amazon.lambda.powertools.parameters.cache.CacheManager;
import software.amazon.lambda.powertools.parameters.transform.TransformationManager;

public final class ParamManager {
    private static final CacheManager cacheManager = new CacheManager();
    private static final TransformationManager transformationManager = new TransformationManager();
    private static ConcurrentHashMap<Class<? extends BaseProvider>, BaseProvider> providers = new ConcurrentHashMap();

    public static <T extends BaseProvider> T getProvider(Class<T> providerClass) {
        if (providerClass == null) {
            throw new IllegalStateException("providerClass cannot be null.");
        }
        return (T)providers.computeIfAbsent(providerClass, ParamManager::createProvider);
    }

    public static SecretsProvider getSecretsProvider() {
        return ParamManager.getProvider(SecretsProvider.class);
    }

    public static SSMProvider getSsmProvider() {
        return ParamManager.getProvider(SSMProvider.class);
    }

    public static DynamoDbProvider getDynamoDbProvider(String tableName) {
        return DynamoDbProvider.builder().withCacheManager(cacheManager).withTable(tableName).withTransformationManager(transformationManager).build();
    }

    public static SecretsProvider getSecretsProvider(SecretsManagerClient client) {
        return (SecretsProvider)providers.computeIfAbsent(SecretsProvider.class, k -> SecretsProvider.builder().withClient(client).withCacheManager(cacheManager).withTransformationManager(transformationManager).build());
    }

    public static SSMProvider getSsmProvider(SsmClient client) {
        return (SSMProvider)providers.computeIfAbsent(SSMProvider.class, k -> SSMProvider.builder().withClient(client).withCacheManager(cacheManager).withTransformationManager(transformationManager).build());
    }

    public static DynamoDbProvider getDynamoDbProvider(DynamoDbClient client, String table) {
        return (DynamoDbProvider)providers.computeIfAbsent(DynamoDbProvider.class, k -> DynamoDbProvider.builder().withClient(client).withTable(table).withCacheManager(cacheManager).withTransformationManager(transformationManager).build());
    }

    public static CacheManager getCacheManager() {
        return cacheManager;
    }

    public static TransformationManager getTransformationManager() {
        return transformationManager;
    }

    private static <T extends BaseProvider> T createProvider(Class<T> providerClass) {
        try {
            Constructor<T> constructor = providerClass.getDeclaredConstructor(CacheManager.class);
            BaseProvider provider = (BaseProvider)constructor.newInstance(cacheManager);
            provider.setTransformationManager(transformationManager);
            return (T)provider;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unexpected error occurred. Please raise issue at https://github.com/awslabs/aws-lambda-powertools-java/issues", e);
        }
    }
}

