/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.argument;

import java.util.Objects;
import software.amazon.lambda.powertools.logging.argument.StructuredArgument;
import software.amazon.lambda.powertools.logging.internal.JsonSerializer;

class JsonArgument
implements StructuredArgument {
    private final String key;
    private final String rawJson;

    public JsonArgument(String key, String rawJson) {
        this.key = Objects.requireNonNull(key, "key must not be null");
        this.rawJson = Objects.requireNonNull(rawJson, "rawJson must not be null");
    }

    @Override
    public void writeTo(JsonSerializer serializer) {
        serializer.writeFieldName(this.key);
        serializer.writeRaw(this.rawJson);
    }

    @Override
    public String toString() {
        return String.valueOf(this.key) + "=" + this.rawJson;
    }
}

