/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.internal;

import com.amazonaws.services.lambda.runtime.Context;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PowertoolsLoggedFields {
    FUNCTION_NAME("function_name"),
    FUNCTION_VERSION("function_version"),
    FUNCTION_ARN("function_arn"),
    FUNCTION_MEMORY_SIZE("function_memory_size"),
    FUNCTION_REQUEST_ID("function_request_id"),
    FUNCTION_COLD_START("cold_start"),
    FUNCTION_TRACE_ID("xray_trace_id"),
    SAMPLING_RATE("sampling_rate"),
    CORRELATION_ID("correlation_id"),
    SERVICE("service");

    private final String name;

    private PowertoolsLoggedFields(String name) {
        this.name = name;
    }

    public static List<String> stringValues() {
        return Stream.of(PowertoolsLoggedFields.values()).map(PowertoolsLoggedFields::getName).collect(Collectors.toList());
    }

    static Map<String, String> setValuesFromLambdaContext(Context context) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PowertoolsLoggedFields.FUNCTION_NAME.name, context.getFunctionName());
        hashMap.put(PowertoolsLoggedFields.FUNCTION_VERSION.name, context.getFunctionVersion());
        hashMap.put(PowertoolsLoggedFields.FUNCTION_ARN.name, context.getInvokedFunctionArn());
        hashMap.put(PowertoolsLoggedFields.FUNCTION_MEMORY_SIZE.name, String.valueOf(context.getMemoryLimitInMB()));
        hashMap.put(PowertoolsLoggedFields.FUNCTION_REQUEST_ID.name, String.valueOf(context.getAwsRequestId()));
        return hashMap;
    }

    public String getName() {
        return this.name;
    }
}

