/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.argument;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.lambda.powertools.logging.argument.ArrayArgument;
import software.amazon.lambda.powertools.logging.argument.JsonArgument;
import software.amazon.lambda.powertools.logging.argument.KeyValueArgument;
import software.amazon.lambda.powertools.logging.argument.MapArgument;
import software.amazon.lambda.powertools.logging.argument.StructuredArgument;
import software.amazon.lambda.powertools.logging.internal.PowertoolsLoggedFields;

public class StructuredArguments {
    private static final Logger LOGGER = LoggerFactory.getLogger(StructuredArguments.class);
    private static final Set<String> RESERVED_KEYS = Stream.concat(PowertoolsLoggedFields.stringValues().stream(), List.of("message", "level", "timestamp", "error").stream()).collect(Collectors.toSet());

    private StructuredArguments() {
    }

    private static boolean isReservedKey(String key) {
        if (key != null && RESERVED_KEYS.contains(key)) {
            LOGGER.warn("Attempted to use reserved key '{}' in structured argument. This key will be ignored.", (Object)key);
            return true;
        }
        return false;
    }

    public static StructuredArgument entry(String key, Object value) {
        if (StructuredArguments.isReservedKey(key)) {
            return null;
        }
        return new KeyValueArgument(key, value);
    }

    public static StructuredArgument entries(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        HashMap filteredMap = new HashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String keyStr;
            if (entry.getKey() == null || StructuredArguments.isReservedKey(keyStr = String.valueOf(entry.getKey()))) continue;
            filteredMap.put(entry.getKey(), entry.getValue());
        }
        return new MapArgument(filteredMap);
    }

    public static StructuredArgument array(String key, Object ... values) {
        if (StructuredArguments.isReservedKey(key)) {
            return null;
        }
        return new ArrayArgument(key, values);
    }

    public static StructuredArgument json(String key, String rawJson) {
        if (StructuredArguments.isReservedKey(key)) {
            return null;
        }
        return new JsonArgument(key, rawJson);
    }

    public static String toString(Object arg) {
        if (arg == null) {
            return "null";
        }
        Class<?> argClass = arg.getClass();
        try {
            if (!argClass.isArray()) {
                return String.valueOf(arg);
            }
            if (argClass == byte[].class) {
                return Arrays.toString((byte[])arg);
            }
            if (argClass == short[].class) {
                return Arrays.toString((short[])arg);
            }
            if (argClass == int[].class) {
                return Arrays.toString((int[])arg);
            }
            if (argClass == long[].class) {
                return Arrays.toString((long[])arg);
            }
            if (argClass == char[].class) {
                return Arrays.toString((char[])arg);
            }
            if (argClass == float[].class) {
                return Arrays.toString((float[])arg);
            }
            if (argClass == double[].class) {
                return Arrays.toString((double[])arg);
            }
            if (argClass == boolean[].class) {
                return Arrays.toString((boolean[])arg);
            }
            return Arrays.deepToString((Object[])arg);
        }
        catch (Exception exception) {
            System.err.println("Failed toString() invocation on an object of type [" + argClass.getName() + "]");
            return "[FAILED toString()]";
        }
    }
}

