/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.failover;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.plugin.failover.FailoverRestriction;
import software.amazon.jdbc.plugin.failover.ReaderFailoverHandler;
import software.amazon.jdbc.plugin.failover.ReaderFailoverResult;
import software.amazon.jdbc.util.ExecutorFactory;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.ServiceUtility;
import software.amazon.jdbc.util.Utils;

public class ClusterAwareReaderFailoverHandler
implements ReaderFailoverHandler {
    private static final Logger LOGGER = Logger.getLogger(ClusterAwareReaderFailoverHandler.class.getName());
    protected static final ReaderFailoverResult FAILED_READER_FAILOVER_RESULT = new ReaderFailoverResult(null, null, false);
    protected static final int DEFAULT_FAILOVER_TIMEOUT = 60000;
    protected static final int DEFAULT_READER_CONNECT_TIMEOUT = 30000;
    protected final Map<String, HostAvailability> hostAvailabilityMap = new ConcurrentHashMap<String, HostAvailability>();
    protected final FullServicesContainer servicesContainer;
    protected final PluginService pluginService;
    protected Properties props;
    protected int maxFailoverTimeoutMs;
    protected int timeoutMs;
    protected boolean isStrictReaderRequired;

    public ClusterAwareReaderFailoverHandler(FullServicesContainer servicesContainer, Properties props) {
        this(servicesContainer, props, 60000, 30000, false);
    }

    public ClusterAwareReaderFailoverHandler(FullServicesContainer servicesContainer, Properties props, int maxFailoverTimeoutMs, int timeoutMs, boolean isStrictReaderRequired) {
        this.servicesContainer = servicesContainer;
        this.pluginService = servicesContainer.getPluginService();
        this.props = props;
        this.maxFailoverTimeoutMs = maxFailoverTimeoutMs;
        this.timeoutMs = timeoutMs;
        this.isStrictReaderRequired = isStrictReaderRequired;
    }

    @Override
    public Map<String, HostAvailability> getHostAvailabilityMap() {
        return this.hostAvailabilityMap;
    }

    protected void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    @Override
    public ReaderFailoverResult failover(List<HostSpec> hosts, HostSpec currentHost) throws SQLException {
        if (Utils.isNullOrEmpty(hosts)) {
            LOGGER.fine(() -> Messages.get("ClusterAwareReaderFailoverHandler.invalidTopology", new Object[]{"failover"}));
            return FAILED_READER_FAILOVER_RESULT;
        }
        ExecutorService executor = ExecutorFactory.newSingleThreadExecutor("failover");
        Future<ReaderFailoverResult> future = this.submitInternalFailoverTask(hosts, currentHost, executor);
        return this.getInternalFailoverResult(executor, future);
    }

    private Future<ReaderFailoverResult> submitInternalFailoverTask(List<HostSpec> hosts, HostSpec currentHost, ExecutorService executor) {
        Future<ReaderFailoverResult> future = executor.submit(() -> {
            try {
                while (true) {
                    ReaderFailoverResult result;
                    if ((result = this.failoverInternal(hosts, currentHost)) != null && result.isConnected()) {
                        return result;
                    }
                    TimeUnit.SECONDS.sleep(1L);
                }
            }
            catch (SQLException ex) {
                return new ReaderFailoverResult(null, null, false, ex);
            }
            catch (Exception ex) {
                return new ReaderFailoverResult(null, null, false, new SQLException(ex));
            }
        });
        executor.shutdown();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReaderFailoverResult getInternalFailoverResult(ExecutorService executor, Future<ReaderFailoverResult> future) throws SQLException {
        try {
            ReaderFailoverResult result = future.get(this.maxFailoverTimeoutMs, TimeUnit.MILLISECONDS);
            if (result == null) {
                LOGGER.warning(Messages.get("ClusterAwareReaderFailoverHandler.timeout", new Object[]{this.maxFailoverTimeoutMs}));
                ReaderFailoverResult readerFailoverResult = FAILED_READER_FAILOVER_RESULT;
                return readerFailoverResult;
            }
            ReaderFailoverResult readerFailoverResult = result;
            return readerFailoverResult;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException(Messages.get("ClusterAwareReaderFailoverHandler.interruptedThread"), "70100", e);
        }
        catch (ExecutionException e) {
            ReaderFailoverResult readerFailoverResult = FAILED_READER_FAILOVER_RESULT;
            return readerFailoverResult;
        }
        catch (TimeoutException e) {
            future.cancel(true);
            ReaderFailoverResult readerFailoverResult = FAILED_READER_FAILOVER_RESULT;
            return readerFailoverResult;
        }
        finally {
            if (!executor.isTerminated()) {
                executor.shutdownNow();
            }
        }
    }

    protected ReaderFailoverResult failoverInternal(List<HostSpec> hosts, HostSpec currentHost) throws SQLException {
        if (currentHost != null) {
            this.pluginService.setAvailability(currentHost.asAliases(), HostAvailability.NOT_AVAILABLE);
            this.hostAvailabilityMap.put(currentHost.getHost(), HostAvailability.NOT_AVAILABLE);
        }
        List<HostSpec> hostsByPriority = this.getHostsByPriority(hosts);
        return this.getConnectionFromHostGroup(hostsByPriority);
    }

    public List<HostSpec> getHostsByPriority(List<HostSpec> hosts) {
        ArrayList<HostSpec> activeReaders = new ArrayList<HostSpec>();
        ArrayList<HostSpec> downHostList = new ArrayList<HostSpec>();
        HostSpec writerHost = null;
        for (HostSpec host : hosts) {
            if (host.getRole() == HostRole.WRITER) {
                writerHost = host;
                continue;
            }
            if (host.getRawAvailability() == HostAvailability.AVAILABLE) {
                activeReaders.add(host);
                continue;
            }
            downHostList.add(host);
        }
        Collections.shuffle(activeReaders);
        Collections.shuffle(downHostList);
        ArrayList<HostSpec> hostsByPriority = new ArrayList<HostSpec>(activeReaders);
        int numOfReaders = activeReaders.size() + downHostList.size();
        if (writerHost != null || numOfReaders == 0) {
            hostsByPriority.add(writerHost);
        }
        hostsByPriority.addAll(downHostList);
        return hostsByPriority;
    }

    @Override
    public ReaderFailoverResult getReaderConnection(List<HostSpec> hostList) throws SQLException {
        if (Utils.isNullOrEmpty(hostList)) {
            LOGGER.fine(() -> Messages.get("ClusterAwareReaderFailover.invalidTopology", new Object[]{"getReaderConnection"}));
            return FAILED_READER_FAILOVER_RESULT;
        }
        List<HostSpec> hostsByPriority = this.getReaderHostsByPriority(hostList);
        return this.getConnectionFromHostGroup(hostsByPriority);
    }

    public List<HostSpec> getReaderHostsByPriority(List<HostSpec> hosts) {
        boolean shouldIncludeWriter;
        ArrayList<HostSpec> activeReaders = new ArrayList<HostSpec>();
        ArrayList<HostSpec> downHostList = new ArrayList<HostSpec>();
        HostSpec writerHost = null;
        for (HostSpec host : hosts) {
            if (host.getRole() == HostRole.WRITER) {
                writerHost = host;
                continue;
            }
            if (host.getRawAvailability() == HostAvailability.AVAILABLE) {
                activeReaders.add(host);
                continue;
            }
            downHostList.add(host);
        }
        Collections.shuffle(activeReaders);
        Collections.shuffle(downHostList);
        ArrayList<HostSpec> hostsByPriority = new ArrayList<HostSpec>(activeReaders);
        int numOfReaders = activeReaders.size() + downHostList.size();
        hostsByPriority.addAll(downHostList);
        if (writerHost == null) {
            return hostsByPriority;
        }
        boolean bl = shouldIncludeWriter = numOfReaders == 0 || this.pluginService.getDialect().getFailoverRestrictions().contains((Object)FailoverRestriction.ENABLE_WRITER_IN_TASK_B);
        if (shouldIncludeWriter) {
            hostsByPriority.add(writerHost);
        }
        return hostsByPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReaderFailoverResult getConnectionFromHostGroup(List<HostSpec> hosts) throws SQLException {
        ExecutorService executor = ExecutorFactory.newFixedThreadPool(2, "failover");
        ExecutorCompletionService<ReaderFailoverResult> completionService = new ExecutorCompletionService<ReaderFailoverResult>(executor);
        FullServicesContainer servicesContainer1 = this.newServicesContainer();
        FullServicesContainer servicesContainer2 = this.newServicesContainer();
        try {
            for (int i = 0; i < hosts.size(); i += 2) {
                ReaderFailoverResult result = this.getResultFromNextTaskBatch(hosts, executor, completionService, servicesContainer1, servicesContainer2, i);
                if (result.isConnected() || result.getException() != null) {
                    ReaderFailoverResult readerFailoverResult = result;
                    return readerFailoverResult;
                }
                try {
                    TimeUnit.SECONDS.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SQLException(Messages.get("ClusterAwareReaderFailoverHandler.interruptedThread"), "70100", e);
                }
            }
            ReaderFailoverResult readerFailoverResult = new ReaderFailoverResult(null, null, false);
            return readerFailoverResult;
        }
        finally {
            executor.shutdownNow();
        }
    }

    protected FullServicesContainer newServicesContainer() throws SQLException {
        return ServiceUtility.getInstance().createMinimalServiceContainer(this.servicesContainer, this.props);
    }

    private ReaderFailoverResult getResultFromNextTaskBatch(List<HostSpec> hosts, ExecutorService executor, CompletionService<ReaderFailoverResult> completionService, FullServicesContainer servicesContainer1, FullServicesContainer servicesContainer2, int i) throws SQLException {
        int numTasks = i + 1 < hosts.size() ? 2 : 1;
        completionService.submit(new ConnectionAttemptTask(servicesContainer1, this.hostAvailabilityMap, hosts.get(i), this.props, this.isStrictReaderRequired));
        if (numTasks == 2) {
            completionService.submit(new ConnectionAttemptTask(servicesContainer2, this.hostAvailabilityMap, hosts.get(i + 1), this.props, this.isStrictReaderRequired));
        }
        for (int taskNum = 0; taskNum < numTasks; ++taskNum) {
            ReaderFailoverResult result = this.getNextResult(completionService);
            if (result.isConnected()) {
                executor.shutdownNow();
                return result;
            }
            if (result.getException() == null) continue;
            executor.shutdownNow();
            return result;
        }
        return new ReaderFailoverResult(null, null, false);
    }

    private ReaderFailoverResult getNextResult(CompletionService<ReaderFailoverResult> service) throws SQLException {
        try {
            Future<ReaderFailoverResult> future = service.poll(this.timeoutMs, TimeUnit.MILLISECONDS);
            if (future == null) {
                return FAILED_READER_FAILOVER_RESULT;
            }
            ReaderFailoverResult result = future.get();
            return result == null ? FAILED_READER_FAILOVER_RESULT : result;
        }
        catch (ExecutionException e) {
            return FAILED_READER_FAILOVER_RESULT;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException(Messages.get("ClusterAwareReaderFailoverHandler.interruptedThread"), "70100", e);
        }
    }

    private static class ConnectionAttemptTask
    implements Callable<ReaderFailoverResult> {
        private final PluginService pluginService;
        private final Map<String, HostAvailability> availabilityMap;
        private final HostSpec newHost;
        private final Properties props;
        private final boolean isStrictReaderRequired;

        private ConnectionAttemptTask(FullServicesContainer servicesContainer, Map<String, HostAvailability> availabilityMap, HostSpec newHost, Properties props, boolean isStrictReaderRequired) {
            this.pluginService = servicesContainer.getPluginService();
            this.availabilityMap = availabilityMap;
            this.newHost = newHost;
            this.props = props;
            this.isStrictReaderRequired = isStrictReaderRequired;
        }

        @Override
        public ReaderFailoverResult call() {
            LOGGER.fine(() -> Messages.get("ClusterAwareReaderFailoverHandler.attemptingReaderConnection", new Object[]{this.newHost.getUrl(), PropertyUtils.maskProperties(this.props)}));
            try {
                Connection conn;
                block10: {
                    Properties copy = new Properties();
                    copy.putAll((Map<?, ?>)this.props);
                    conn = this.pluginService.forceConnect(this.newHost, copy);
                    this.availabilityMap.put(this.newHost.getHost(), HostAvailability.AVAILABLE);
                    if (this.isStrictReaderRequired) {
                        try {
                            HostRole role = this.pluginService.getHostRole(conn);
                            if (HostRole.READER.equals((Object)role)) break block10;
                            LOGGER.fine(Messages.get("ClusterAwareReaderFailoverHandler.readerRequired", new Object[]{this.newHost.getUrl(), role}));
                            try {
                                conn.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            return FAILED_READER_FAILOVER_RESULT;
                        }
                        catch (SQLException e) {
                            LOGGER.fine(Messages.get("ClusterAwareReaderFailoverHandler.errorGettingHostRole", new Object[]{e}));
                            try {
                                conn.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            return FAILED_READER_FAILOVER_RESULT;
                        }
                    }
                }
                LOGGER.fine(() -> Messages.get("ClusterAwareReaderFailoverHandler.successfulReaderConnection", new Object[]{this.newHost.getUrl()}));
                LOGGER.fine("New reader failover connection object: " + conn);
                return new ReaderFailoverResult(conn, this.newHost, true);
            }
            catch (SQLException e) {
                this.availabilityMap.put(this.newHost.getHost(), HostAvailability.NOT_AVAILABLE);
                LOGGER.fine(() -> Messages.get("ClusterAwareReaderFailoverHandler.failedReaderConnection", new Object[]{this.newHost.getUrl()}));
                if (!this.pluginService.isNetworkException(e, this.pluginService.getTargetDriverDialect())) {
                    return new ReaderFailoverResult(null, null, false, e);
                }
                return FAILED_READER_FAILOVER_RESULT;
            }
        }
    }
}

