/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.strategy.fastestresponse;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.RandomHostSelector;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.strategy.fastestresponse.HostResponseTimeService;
import software.amazon.jdbc.plugin.strategy.fastestresponse.HostResponseTimeServiceImpl;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.storage.CacheMap;

public class FastestResponseStrategyPlugin
extends AbstractConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(FastestResponseStrategyPlugin.class.getName());
    public static final String FASTEST_RESPONSE_STRATEGY_NAME = "fastestResponse";
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("connect");
            this.add("forceConnect");
            this.add("notifyNodeListChanged");
            this.add("acceptsStrategy");
            this.add("getHostSpecByStrategy");
        }
    });
    public static final AwsWrapperProperty RESPONSE_MEASUREMENT_INTERVAL_MILLIS = new AwsWrapperProperty("responseMeasurementIntervalMs", "30000", "Interval in millis between measuring response time to a database node.");
    protected static final CacheMap<String, HostSpec> cachedFastestResponseHostByRole = new CacheMap();
    protected static final RandomHostSelector randomHostSelector = new RandomHostSelector();
    protected final @NonNull PluginService pluginService;
    protected final @NonNull Properties properties;
    protected final @NonNull HostResponseTimeService hostResponseTimeService;
    protected long cacheExpirationNano;
    protected List<HostSpec> hosts = new ArrayList<HostSpec>();

    public FastestResponseStrategyPlugin(FullServicesContainer servicesContainer, @NonNull Properties properties) {
        this(servicesContainer.getPluginService(), properties, new HostResponseTimeServiceImpl(servicesContainer, properties, RESPONSE_MEASUREMENT_INTERVAL_MILLIS.getInteger(properties)));
    }

    public FastestResponseStrategyPlugin(@NonNull PluginService pluginService, @NonNull Properties properties, @NonNull HostResponseTimeService hostResponseTimeService) {
        this.pluginService = pluginService;
        this.properties = properties;
        this.hostResponseTimeService = hostResponseTimeService;
        this.cacheExpirationNano = TimeUnit.MILLISECONDS.toNanos(RESPONSE_MEASUREMENT_INTERVAL_MILLIS.getInteger(this.properties));
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        Connection conn = connectFunc.call();
        if (isInitialConnection) {
            this.hostResponseTimeService.setHosts(this.pluginService.getHosts());
        }
        return conn;
    }

    @Override
    public boolean acceptsStrategy(HostRole role, String strategy) {
        return FASTEST_RESPONSE_STRATEGY_NAME.equalsIgnoreCase(strategy);
    }

    @Override
    public HostSpec getHostSpecByStrategy(HostRole role, String strategy) throws SQLException, UnsupportedOperationException {
        HostSpec foundHostSpec;
        if (!this.acceptsStrategy(role, strategy)) {
            return null;
        }
        HostSpec fastestResponseHost = cachedFastestResponseHostByRole.get(role.name());
        if (fastestResponseHost != null && (foundHostSpec = (HostSpec)this.pluginService.getHosts().stream().filter(x -> x.equals(fastestResponseHost)).findAny().orElse(null)) != null) {
            return foundHostSpec;
        }
        HostSpec calculatedFastestResponseHost = this.pluginService.getHosts().stream().filter(x -> role.equals((Object)x.getRole())).map(x -> new ResponseTimeTuple((HostSpec)x, this.hostResponseTimeService.getResponseTime((HostSpec)x))).sorted(Comparator.comparingInt(x -> x.responseTime)).map(x -> x.hostSpec).findFirst().orElse(null);
        if (calculatedFastestResponseHost == null) {
            return randomHostSelector.getHost(this.hosts, role, this.properties);
        }
        cachedFastestResponseHostByRole.put(role.name(), calculatedFastestResponseHost, this.cacheExpirationNano);
        return calculatedFastestResponseHost;
    }

    @Override
    public void notifyNodeListChanged(Map<String, EnumSet<NodeChangeOptions>> changes) {
        this.hosts = this.pluginService.getHosts();
        this.hostResponseTimeService.setHosts(this.hosts);
    }

    public static void clearCache() {
        cachedFastestResponseHostByRole.clear();
    }

    static {
        PropertyDefinition.registerPluginProperties(FastestResponseStrategyPlugin.class);
        PropertyDefinition.registerPluginProperties("frt-");
    }

    private static class ResponseTimeTuple {
        public HostSpec hostSpec;
        public int responseTime;

        public ResponseTimeTuple(HostSpec hostSpec, int responseTime) {
            this.hostSpec = hostSpec;
            this.responseTime = responseTime;
        }
    }
}

