/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.telemetry;

import java.util.Properties;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.util.telemetry.GaugeCallable;
import software.amazon.jdbc.util.telemetry.OpenTelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryGauge;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;
import software.amazon.jdbc.util.telemetry.XRayTelemetryFactory;

public class DefaultTelemetryFactory
implements TelemetryFactory {
    private static final OpenTelemetryFactory OPEN_TELEMETRY_FACTORY = new OpenTelemetryFactory();
    private static final XRayTelemetryFactory X_RAY_TELEMETRY_FACTORY = new XRayTelemetryFactory();
    private final boolean enableTelemetry;
    private final String telemetryTracesBackend;
    private final String telemetryMetricsBackend;
    private final boolean telemetrySubmitTopLevel;
    private final TelemetryFactory tracesTelemetryFactory;
    private final TelemetryFactory metricsTelemetryFactory;
    private final boolean telemetryInUse;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DefaultTelemetryFactory(Properties properties) {
        this.enableTelemetry = PropertyDefinition.ENABLE_TELEMETRY.getBoolean(properties);
        this.telemetryTracesBackend = PropertyDefinition.TELEMETRY_TRACES_BACKEND.getString(properties);
        this.telemetryMetricsBackend = PropertyDefinition.TELEMETRY_METRICS_BACKEND.getString(properties);
        this.telemetrySubmitTopLevel = PropertyDefinition.TELEMETRY_SUBMIT_TOPLEVEL.getBoolean(properties);
        if (this.enableTelemetry) {
            if ("otlp".equalsIgnoreCase(this.telemetryTracesBackend)) {
                this.tracesTelemetryFactory = OPEN_TELEMETRY_FACTORY;
            } else if ("xray".equalsIgnoreCase(this.telemetryTracesBackend)) {
                this.tracesTelemetryFactory = X_RAY_TELEMETRY_FACTORY;
            } else {
                if (!"none".equalsIgnoreCase(this.telemetryTracesBackend)) throw new RuntimeException(this.telemetryTracesBackend + " is not a valid tracing backend. Available options: OTLP, XRAY, NONE.");
                this.tracesTelemetryFactory = null;
            }
        } else {
            this.tracesTelemetryFactory = null;
        }
        if (this.enableTelemetry) {
            if ("otlp".equalsIgnoreCase(this.telemetryMetricsBackend)) {
                this.metricsTelemetryFactory = OPEN_TELEMETRY_FACTORY;
            } else {
                if (!"none".equalsIgnoreCase(this.telemetryMetricsBackend)) throw new RuntimeException(this.telemetryTracesBackend + " is not a valid metrics backend. Available options: OTLP, NONE.");
                this.metricsTelemetryFactory = null;
            }
        } else {
            this.metricsTelemetryFactory = null;
        }
        this.telemetryInUse = this.tracesTelemetryFactory != null || this.metricsTelemetryFactory != null;
    }

    @Override
    public TelemetryContext openTelemetryContext(String name, TelemetryTraceLevel traceLevel) {
        if (this.tracesTelemetryFactory == null) {
            return null;
        }
        TelemetryTraceLevel effectiveTraceLevel = traceLevel;
        if (!this.telemetrySubmitTopLevel && traceLevel == TelemetryTraceLevel.TOP_LEVEL) {
            effectiveTraceLevel = TelemetryTraceLevel.NESTED;
        }
        return this.tracesTelemetryFactory.openTelemetryContext(name, effectiveTraceLevel);
    }

    @Override
    public void postCopy(TelemetryContext telemetryContext, TelemetryTraceLevel traceLevel) {
        if (this.tracesTelemetryFactory != null) {
            this.tracesTelemetryFactory.postCopy(telemetryContext, traceLevel);
        }
    }

    @Override
    public TelemetryCounter createCounter(String name) {
        if (this.metricsTelemetryFactory == null) {
            return null;
        }
        return this.metricsTelemetryFactory.createCounter(name);
    }

    @Override
    public TelemetryGauge createGauge(String name, GaugeCallable<Long> callback) {
        if (this.metricsTelemetryFactory == null) {
            return null;
        }
        return this.metricsTelemetryFactory.createGauge(name, callback);
    }

    @Override
    public boolean inUse() {
        return this.telemetryInUse;
    }
}

