/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.OldConnectionSuggestedAction;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.efm2.HostMonitorConnectionContext;
import software.amazon.jdbc.plugin.efm2.HostMonitorService;
import software.amazon.jdbc.plugin.efm2.HostMonitorServiceImpl;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;

public class HostMonitoringConnectionPlugin
extends AbstractConnectionPlugin
implements CanReleaseResources {
    private static final Logger LOGGER = Logger.getLogger(HostMonitoringConnectionPlugin.class.getName());
    public static final AwsWrapperProperty FAILURE_DETECTION_ENABLED = new AwsWrapperProperty("failureDetectionEnabled", "true", "Enable failure detection logic (aka node monitoring thread).");
    public static final AwsWrapperProperty FAILURE_DETECTION_TIME = new AwsWrapperProperty("failureDetectionTime", "30000", "Interval in millis between sending SQL to the server and the first probe to database node.");
    public static final AwsWrapperProperty FAILURE_DETECTION_INTERVAL = new AwsWrapperProperty("failureDetectionInterval", "5000", "Interval in millis between probes to database node.");
    public static final AwsWrapperProperty FAILURE_DETECTION_COUNT = new AwsWrapperProperty("failureDetectionCount", "3", "Number of failed connection checks before considering database node unhealthy.");
    protected final Set<String> subscribedMethods;
    protected @NonNull Properties properties;
    private final @NonNull Supplier<HostMonitorService> monitorServiceSupplier;
    private final @NonNull PluginService pluginService;
    private HostMonitorService monitorService;
    private final RdsUtils rdsHelper;
    private HostSpec monitoringHostSpec;
    protected final boolean isEnabled;

    public HostMonitoringConnectionPlugin(@NonNull PluginService pluginService, @NonNull Properties properties) {
        this(pluginService, properties, () -> new HostMonitorServiceImpl(pluginService), new RdsUtils());
    }

    HostMonitoringConnectionPlugin(@NonNull PluginService pluginService, @NonNull Properties properties, @NonNull Supplier<HostMonitorService> monitorServiceSupplier, RdsUtils rdsHelper) {
        this.pluginService = pluginService;
        this.properties = properties;
        this.monitorServiceSupplier = monitorServiceSupplier;
        this.rdsHelper = rdsHelper;
        this.isEnabled = FAILURE_DETECTION_ENABLED.getBoolean(this.properties);
        HashSet<String> methods = new HashSet<String>();
        if (this.isEnabled) {
            methods.add(JdbcMethod.CONNECT.methodName);
            methods.addAll(this.pluginService.getTargetDriverDialect().getNetworkBoundMethodNames(this.properties));
        }
        this.subscribedMethods = Collections.unmodifiableSet(methods);
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return this.subscribedMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        T result;
        if (!this.isEnabled || !this.subscribedMethods.contains(methodName)) {
            return jdbcMethodFunc.call();
        }
        int failureDetectionTimeMillis = FAILURE_DETECTION_TIME.getInteger(this.properties);
        int failureDetectionIntervalMillis = FAILURE_DETECTION_INTERVAL.getInteger(this.properties);
        int failureDetectionCount = FAILURE_DETECTION_COUNT.getInteger(this.properties);
        this.initMonitorService();
        HostMonitorConnectionContext monitorContext = null;
        try {
            LOGGER.finest(() -> Messages.get("HostMonitoringConnectionPlugin.activatedMonitoring", new Object[]{methodName}));
            HostSpec monitoringHostSpec = this.getMonitoringHostSpec();
            monitorContext = this.monitorService.startMonitoring(this.pluginService.getCurrentConnection(), monitoringHostSpec, this.properties, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount);
            result = jdbcMethodFunc.call();
            if (monitorContext != null) {
                this.monitorService.stopMonitoring(monitorContext, this.pluginService.getCurrentConnection());
            }
            LOGGER.finest(() -> Messages.get("HostMonitoringConnectionPlugin.monitoringDeactivated", new Object[]{methodName}));
        }
        catch (Throwable throwable) {
            if (monitorContext != null) {
                this.monitorService.stopMonitoring(monitorContext, this.pluginService.getCurrentConnection());
            }
            LOGGER.finest(() -> Messages.get("HostMonitoringConnectionPlugin.monitoringDeactivated", new Object[]{methodName}));
            throw throwable;
        }
        return result;
    }

    private void initMonitorService() {
        if (this.monitorService == null) {
            this.monitorService = this.monitorServiceSupplier.get();
        }
    }

    @Override
    public void releaseResources() {
        if (this.monitorService != null) {
            this.monitorService.releaseResources();
        }
        this.monitorService = null;
    }

    @Override
    public OldConnectionSuggestedAction notifyConnectionChanged(EnumSet<NodeChangeOptions> changes) {
        if (changes.contains((Object)NodeChangeOptions.HOSTNAME) || changes.contains((Object)NodeChangeOptions.NODE_CHANGED)) {
            this.monitoringHostSpec = null;
        }
        return OldConnectionSuggestedAction.NO_OPINION;
    }

    @Override
    public Connection connect(@NonNull String driverProtocol, @NonNull HostSpec hostSpec, @NonNull Properties props, boolean isInitialConnection, @NonNull JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        RdsUrlType type;
        Connection conn = connectFunc.call();
        if (conn != null && (type = this.rdsHelper.identifyRdsType(hostSpec.getHost())).isRdsCluster()) {
            hostSpec.resetAliases();
            this.pluginService.fillAliases(conn, hostSpec);
        }
        return conn;
    }

    public HostSpec getMonitoringHostSpec() {
        if (this.monitoringHostSpec == null) {
            this.monitoringHostSpec = this.pluginService.getCurrentHostSpec();
            RdsUrlType rdsUrlType = this.rdsHelper.identifyRdsType(this.monitoringHostSpec.getUrl());
            try {
                if (rdsUrlType.isRdsCluster()) {
                    LOGGER.finest("Monitoring HostSpec is associated with a cluster endpoint, plugin needs to identify the cluster connection.");
                    this.monitoringHostSpec = this.pluginService.identifyConnection(this.pluginService.getCurrentConnection());
                    if (this.monitoringHostSpec == null) {
                        throw new RuntimeException(Messages.get("HostMonitoringConnectionPlugin.unableToIdentifyConnection", new Object[]{this.pluginService.getCurrentHostSpec().getHost(), this.pluginService.getHostListProvider()}));
                    }
                    this.pluginService.fillAliases(this.pluginService.getCurrentConnection(), this.monitoringHostSpec);
                }
            }
            catch (SQLException e) {
                LOGGER.finest(Messages.get("HostMonitoringConnectionPlugin.errorIdentifyingConnection", new Object[]{e}));
                throw new RuntimeException(e);
            }
        }
        return this.monitoringHostSpec;
    }

    static {
        PropertyDefinition.registerPluginProperties(HostMonitoringConnectionPlugin.class);
        PropertyDefinition.registerPluginProperties("monitoring-");
    }
}

