/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.hostlistprovider.monitoring;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Properties;
import java.util.logging.Logger;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.hostlistprovider.monitoring.ClusterTopologyMonitorImpl;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.connection.ConnectionService;
import software.amazon.jdbc.util.storage.StorageService;

public class MultiAzClusterTopologyMonitorImpl
extends ClusterTopologyMonitorImpl {
    private static final Logger LOGGER = Logger.getLogger(MultiAzClusterTopologyMonitorImpl.class.getName());
    protected final String fetchWriterNodeQuery;
    protected final String fetchWriterNodeColumnName;

    public MultiAzClusterTopologyMonitorImpl(String clusterId, StorageService storageService, ConnectionService connectionService, HostSpec initialHostSpec, Properties properties, HostListProviderService hostListProviderService, HostSpec clusterInstanceTemplate, long refreshRateNano, long highRefreshRateNano, String topologyQuery, String writerTopologyQuery, String nodeIdQuery, String fetchWriterNodeQuery, String fetchWriterNodeColumnName) {
        super(clusterId, storageService, connectionService, initialHostSpec, properties, hostListProviderService, clusterInstanceTemplate, refreshRateNano, highRefreshRateNano, topologyQuery, writerTopologyQuery, nodeIdQuery);
        this.fetchWriterNodeQuery = fetchWriterNodeQuery;
        this.fetchWriterNodeColumnName = fetchWriterNodeColumnName;
    }

    @Override
    protected String getWriterNodeId(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            try (ResultSet resultSet = stmt.executeQuery(this.fetchWriterNodeQuery);){
                String nodeId;
                if (resultSet.next() && !StringUtils.isNullOrEmpty(nodeId = resultSet.getString(this.fetchWriterNodeColumnName))) {
                    String string = null;
                    return string;
                }
            }
            resultSet = stmt.executeQuery(this.nodeIdQuery);
            var5_7 = null;
            try {
                if (resultSet.next()) {
                    String string = resultSet.getString(1);
                    return string;
                }
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (resultSet != null) {
                    if (var5_7 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        return null;
    }

    @Override
    protected String getSuggestedWriterNodeId(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            try (ResultSet resultSet = stmt.executeQuery(this.fetchWriterNodeQuery);){
                String nodeId;
                if (resultSet.next() && !StringUtils.isNullOrEmpty(nodeId = resultSet.getString(this.fetchWriterNodeColumnName))) {
                    String string = nodeId;
                    return string;
                }
            }
            resultSet = stmt.executeQuery(this.nodeIdQuery);
            var5_7 = null;
            try {
                if (resultSet.next()) {
                    String string = resultSet.getString(1);
                    return string;
                }
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (resultSet != null) {
                    if (var5_7 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        return null;
    }

    @Override
    protected HostSpec createHost(ResultSet resultSet, String suggestedWriterNodeId) throws SQLException {
        String endpoint = resultSet.getString("endpoint");
        String instanceName = endpoint.substring(0, endpoint.indexOf("."));
        String hostId = resultSet.getString("id");
        boolean isWriter = hostId.equals(suggestedWriterNodeId);
        return this.createHost(instanceName, isWriter, 0L, Timestamp.from(Instant.now()));
    }
}

