/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.bluegreen.routing;

import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenRole;
import software.amazon.jdbc.plugin.bluegreen.routing.BaseExecuteRouting;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.WrapperUtils;

public class CloseConnectionExecuteRouting
extends BaseExecuteRouting {
    private static final Logger LOGGER = Logger.getLogger(CloseConnectionExecuteRouting.class.getName());

    public CloseConnectionExecuteRouting(@Nullable String hostAndPort, @Nullable BlueGreenRole role) {
        super(hostAndPort, role);
    }

    @Override
    public <T, E extends Exception> Optional<T> apply(ConnectionPlugin plugin, Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs, PluginService pluginService, Properties props) throws E {
        try {
            if (pluginService.getCurrentConnection() != null && !pluginService.getCurrentConnection().isClosed()) {
                pluginService.getCurrentConnection().close();
            }
            throw new SQLException(Messages.get("bgd.inProgressConnectionClosed"), "08001");
        }
        catch (SQLException ex) {
            throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, ex);
        }
    }
}

