/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.util.Messages;

public class Utils {
    public static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean containsUrl(List<HostSpec> hosts, String url) {
        for (HostSpec hostSpec : hosts) {
            if (!hostSpec.getUrl().equals(url)) continue;
            return true;
        }
        return false;
    }

    public static String logTopology(@Nullable List<HostSpec> hosts) {
        return Utils.logTopology(hosts, null);
    }

    public static String logTopology(@Nullable List<HostSpec> hosts, @Nullable String messagePrefix) {
        StringBuilder msg = new StringBuilder();
        if (hosts == null) {
            msg.append("<null>");
        } else {
            for (HostSpec host : hosts) {
                if (msg.length() > 0) {
                    msg.append("\n");
                }
                msg.append("   ").append(host == null ? "<null>" : host);
            }
        }
        return Messages.get("Utils.topology", new Object[]{messagePrefix == null ? "Topology:" : messagePrefix, msg.toString()});
    }
}

