/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.telemetry;

import java.util.Properties;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.util.telemetry.GaugeCallable;
import software.amazon.jdbc.util.telemetry.NullTelemetryFactory;
import software.amazon.jdbc.util.telemetry.OpenTelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryGauge;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;
import software.amazon.jdbc.util.telemetry.XRayTelemetryFactory;

public class DefaultTelemetryFactory
implements TelemetryFactory {
    private final boolean enableTelemetry;
    private final String telemetryTracesBackend;
    private final String telemetryMetricsBackend;
    private final boolean telemetrySubmitToplevel;
    private final TelemetryFactory tracesTelemetryFactory;
    private final TelemetryFactory metricsTelemetryFactory;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DefaultTelemetryFactory(Properties properties) {
        this.enableTelemetry = PropertyDefinition.ENABLE_TELEMETRY.getBoolean(properties);
        this.telemetryTracesBackend = PropertyDefinition.TELEMETRY_TRACES_BACKEND.getString(properties);
        this.telemetryMetricsBackend = PropertyDefinition.TELEMETRY_METRICS_BACKEND.getString(properties);
        this.telemetrySubmitToplevel = PropertyDefinition.TELEMETRY_SUBMIT_TOPLEVEL.getBoolean(properties);
        if (this.enableTelemetry) {
            if ("otlp".equalsIgnoreCase(this.telemetryTracesBackend)) {
                this.tracesTelemetryFactory = new OpenTelemetryFactory();
            } else if ("xray".equalsIgnoreCase(this.telemetryTracesBackend)) {
                this.tracesTelemetryFactory = new XRayTelemetryFactory();
            } else {
                if (!"none".equalsIgnoreCase(this.telemetryTracesBackend)) throw new RuntimeException(this.telemetryTracesBackend + " is not a valid tracing backend. Available options: OTLP, XRAY, NONE.");
                this.tracesTelemetryFactory = new NullTelemetryFactory();
            }
        } else {
            this.tracesTelemetryFactory = new NullTelemetryFactory();
        }
        if (this.enableTelemetry) {
            if ("otlp".equalsIgnoreCase(this.telemetryMetricsBackend)) {
                this.metricsTelemetryFactory = new OpenTelemetryFactory();
                return;
            } else {
                if (!"none".equalsIgnoreCase(this.telemetryMetricsBackend)) throw new RuntimeException(this.telemetryTracesBackend + " is not a valid metrics backend. Available options: OTLP, NONE.");
                this.metricsTelemetryFactory = new NullTelemetryFactory();
            }
            return;
        } else {
            this.metricsTelemetryFactory = new NullTelemetryFactory();
        }
    }

    @Override
    public TelemetryContext openTelemetryContext(String name, TelemetryTraceLevel traceLevel) {
        TelemetryTraceLevel effectiveTraceLevel = traceLevel;
        if (!this.telemetrySubmitToplevel && traceLevel == TelemetryTraceLevel.TOP_LEVEL) {
            effectiveTraceLevel = TelemetryTraceLevel.NESTED;
        }
        return this.tracesTelemetryFactory.openTelemetryContext(name, effectiveTraceLevel);
    }

    @Override
    public void postCopy(TelemetryContext telemetryContext, TelemetryTraceLevel traceLevel) {
        this.tracesTelemetryFactory.postCopy(telemetryContext, traceLevel);
    }

    @Override
    public TelemetryCounter createCounter(String name) {
        return this.metricsTelemetryFactory.createCounter(name);
    }

    @Override
    public TelemetryGauge createGauge(String name, GaugeCallable<Long> callback) {
        return this.metricsTelemetryFactory.createGauge(name, callback);
    }
}

