/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.cleanup.CanReleaseResources;

public class ConnectionProviderManager {
    private static AtomicReference<ConnectionProvider> customConnectionProvider = new AtomicReference<Object>(null);
    private final ConnectionProvider defaultProvider;
    private final @Nullable ConnectionProvider effectiveConnProvider;
    private static ConnectionInitFunc connectionInitFunc = null;

    public ConnectionProviderManager(ConnectionProvider defaultProvider, @Nullable ConnectionProvider effectiveConnProvider) {
        this.defaultProvider = defaultProvider;
        this.effectiveConnProvider = effectiveConnProvider;
    }

    public static void setConnectionProvider(ConnectionProvider connProvider) {
        customConnectionProvider.set(connProvider);
    }

    public ConnectionProvider getConnectionProvider(String driverProtocol, HostSpec host, Properties props) {
        ConnectionProvider tmpCustomConnectionProvider = customConnectionProvider.get();
        if (tmpCustomConnectionProvider != null && tmpCustomConnectionProvider.acceptsUrl(driverProtocol, host, props)) {
            return tmpCustomConnectionProvider;
        }
        if (this.effectiveConnProvider != null && this.effectiveConnProvider.acceptsUrl(driverProtocol, host, props)) {
            return this.effectiveConnProvider;
        }
        return this.defaultProvider;
    }

    public ConnectionProvider getDefaultProvider() {
        return this.defaultProvider;
    }

    public boolean acceptsStrategy(HostRole role, String strategy) {
        ConnectionProvider tmpCustomConnectionProvider = customConnectionProvider.get();
        if (tmpCustomConnectionProvider != null && tmpCustomConnectionProvider.acceptsStrategy(role, strategy)) {
            return true;
        }
        if (this.effectiveConnProvider != null && this.effectiveConnProvider.acceptsStrategy(role, strategy)) {
            return true;
        }
        return this.defaultProvider.acceptsStrategy(role, strategy);
    }

    public HostSpec getHostSpecByStrategy(List<HostSpec> hosts, HostRole role, String strategy, Properties props) throws SQLException, UnsupportedOperationException {
        HostSpec host = null;
        ConnectionProvider tmpCustomConnectionProvider = customConnectionProvider.get();
        try {
            if (tmpCustomConnectionProvider != null && tmpCustomConnectionProvider.acceptsStrategy(role, strategy)) {
                host = tmpCustomConnectionProvider.getHostSpecByStrategy(hosts, role, strategy, props);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (host != null) {
            return host;
        }
        if (this.effectiveConnProvider != null && this.effectiveConnProvider.acceptsStrategy(role, strategy) && (host = this.effectiveConnProvider.getHostSpecByStrategy(hosts, role, strategy, props)) != null) {
            return host;
        }
        return this.defaultProvider.getHostSpecByStrategy(hosts, role, strategy, props);
    }

    public static void resetProvider() {
        customConnectionProvider.set(null);
    }

    public static void releaseResources() {
        ConnectionProvider tmpCustomConnectionProvider = customConnectionProvider.get();
        if (tmpCustomConnectionProvider instanceof CanReleaseResources) {
            ((CanReleaseResources)((Object)tmpCustomConnectionProvider)).releaseResources();
        }
    }

    public static void setConnectionInitFunc(@NonNull ConnectionInitFunc func) {
        connectionInitFunc = func;
    }

    public static void resetConnectionInitFunc() {
        connectionInitFunc = null;
    }

    public void initConnection(@Nullable Connection connection, @NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        ConnectionInitFunc copy = connectionInitFunc;
        if (copy == null) {
            return;
        }
        copy.initConnection(connection, protocol, hostSpec, props);
    }

    public static interface ConnectionInitFunc {
        public void initConnection(@Nullable Connection var1, @NonNull String var2, @NonNull HostSpec var3, @NonNull Properties var4) throws SQLException;
    }
}

