/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.limitless;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.RoundRobinHostSelector;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.plugin.limitless.LimitlessConnectionContext;
import software.amazon.jdbc.plugin.limitless.LimitlessConnectionPlugin;
import software.amazon.jdbc.plugin.limitless.LimitlessQueryHelper;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterMonitor;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterMonitorInitializer;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterService;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.SlidingExpirationCacheWithCleanupThread;
import software.amazon.jdbc.util.Utils;

public class LimitlessRouterServiceImpl
implements LimitlessRouterService {
    private static final Logger LOGGER = Logger.getLogger(LimitlessRouterServiceImpl.class.getName());
    public static final AwsWrapperProperty MONITOR_DISPOSAL_TIME_MS = new AwsWrapperProperty("limitlessTransactionRouterMonitorDisposalTimeMs", "600000", "Interval in milliseconds for an Limitless router monitor to be considered inactive and to be disposed.");
    protected static final long CACHE_CLEANUP_NANO = TimeUnit.MINUTES.toNanos(1L);
    protected static final Map<String, ReentrantLock> forceGetLimitlessRoutersLockMap = new ConcurrentHashMap<String, ReentrantLock>();
    protected final PluginService pluginService;
    protected final LimitlessQueryHelper queryHelper;
    protected final LimitlessRouterMonitorInitializer limitlessRouterMonitorInitializer;
    protected static final SlidingExpirationCacheWithCleanupThread<String, LimitlessRouterMonitor> limitlessRouterMonitors = new SlidingExpirationCacheWithCleanupThread(limitlessRouterMonitor -> true, limitlessRouterMonitor -> {
        try {
            limitlessRouterMonitor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }, CACHE_CLEANUP_NANO);
    protected static final SlidingExpirationCacheWithCleanupThread<String, List<HostSpec>> limitlessRouterCache = new SlidingExpirationCacheWithCleanupThread(x -> true, x -> {}, CACHE_CLEANUP_NANO);

    public LimitlessRouterServiceImpl(@NonNull PluginService pluginService) {
        this(pluginService, (hostSpec, routerCache, routerCacheKey, props, intervalMs) -> new LimitlessRouterMonitor(pluginService, hostSpec, routerCache, routerCacheKey, props, intervalMs), new LimitlessQueryHelper(pluginService));
    }

    public LimitlessRouterServiceImpl(@NonNull PluginService pluginService, LimitlessRouterMonitorInitializer limitlessRouterMonitorInitializer, LimitlessQueryHelper queryHelper) {
        this.pluginService = pluginService;
        this.limitlessRouterMonitorInitializer = limitlessRouterMonitorInitializer;
        this.queryHelper = queryHelper;
    }

    @Override
    public void establishConnection(LimitlessConnectionContext context) throws SQLException {
        HostSpec selectedHostSpec;
        context.setLimitlessRouters(this.getLimitlessRouters(this.pluginService.getHostListProvider().getClusterId(), context.getProps()));
        if (Utils.isNullOrEmpty(context.getLimitlessRouters())) {
            LOGGER.finest(Messages.get("LimitlessRouterServiceImpl.limitlessRouterCacheEmpty"));
            boolean waitForRouterInfo = LimitlessConnectionPlugin.WAIT_F0R_ROUTER_INFO.getBoolean(context.getProps());
            if (waitForRouterInfo) {
                this.synchronouslyGetLimitlessRoutersWithRetry(context);
            } else {
                LOGGER.finest(Messages.get("LimitlessRouterServiceImpl.usingProvidedConnectUrl"));
                if (context.getConnection() == null || context.getConnection().isClosed()) {
                    context.setConnection(context.getConnectFunc().call());
                }
                return;
            }
        }
        if (context.getLimitlessRouters().contains(context.getHostSpec())) {
            LOGGER.finest(Messages.get("LimitlessRouterServiceImpl.connectWithHost", new Object[]{context.getHostSpec().getHost()}));
            if (context.getConnection() == null || context.getConnection().isClosed()) {
                try {
                    context.setConnection(context.getConnectFunc().call());
                }
                catch (SQLException e) {
                    this.retryConnectWithLeastLoadedRouters(context);
                }
            }
            return;
        }
        RoundRobinHostSelector.setRoundRobinHostWeightPairsProperty(context.getProps(), context.getLimitlessRouters());
        try {
            selectedHostSpec = this.pluginService.getHostSpecByStrategy(context.getLimitlessRouters(), HostRole.WRITER, "roundRobin");
            LOGGER.fine(Messages.get("LimitlessRouterServiceImpl.selectedHost", new Object[]{selectedHostSpec != null ? selectedHostSpec.getHost() : "null"}));
        }
        catch (SQLException e) {
            this.retryConnectWithLeastLoadedRouters(context);
            return;
        }
        if (selectedHostSpec == null) {
            this.retryConnectWithLeastLoadedRouters(context);
            return;
        }
        try {
            context.setConnection(this.pluginService.connect(selectedHostSpec, context.getProps()));
        }
        catch (SQLException e) {
            if (selectedHostSpec != null) {
                LOGGER.fine(Messages.get("LimitlessRouterServiceImpl.failedToConnectToHost", new Object[]{selectedHostSpec.getHost()}));
                selectedHostSpec.setAvailability(HostAvailability.NOT_AVAILABLE);
            }
            this.retryConnectWithLeastLoadedRouters(context);
        }
    }

    protected List<HostSpec> getLimitlessRouters(String clusterId, Properties props) throws SQLException {
        long cacheExpirationNano = TimeUnit.MILLISECONDS.toNanos(MONITOR_DISPOSAL_TIME_MS.getLong(props));
        return (List)limitlessRouterCache.get(clusterId, cacheExpirationNano);
    }

    private void retryConnectWithLeastLoadedRouters(LimitlessConnectionContext context) throws SQLException {
        int retryCount = 0;
        int maxRetries = LimitlessConnectionPlugin.MAX_RETRIES.getInteger(context.getProps());
        while (retryCount++ < maxRetries) {
            HostSpec selectedHostSpec;
            if (Utils.isNullOrEmpty(context.getLimitlessRouters()) || context.getLimitlessRouters().stream().noneMatch(h -> h.getAvailability().equals((Object)HostAvailability.AVAILABLE))) {
                this.synchronouslyGetLimitlessRoutersWithRetry(context);
                if (Utils.isNullOrEmpty(context.getLimitlessRouters()) || context.getLimitlessRouters().stream().noneMatch(h -> h.getAvailability().equals((Object)HostAvailability.AVAILABLE))) {
                    LOGGER.warning(Messages.get("LimitlessRouterServiceImpl.noRoutersAvailableForRetry"));
                    if (context.getConnection() != null && !context.getConnection().isClosed()) {
                        return;
                    }
                    try {
                        context.setConnection(context.getConnectFunc().call());
                        return;
                    }
                    catch (SQLException e) {
                        throw new SQLException(Messages.get("LimitlessRouterServiceImpl.noRoutersAvailable"));
                    }
                }
            }
            try {
                selectedHostSpec = this.pluginService.getHostSpecByStrategy(context.getLimitlessRouters(), HostRole.WRITER, "highestWeight");
                LOGGER.finest(Messages.get("LimitlessRouterServiceImpl.selectedHostForRetry", new Object[]{selectedHostSpec != null ? selectedHostSpec.getHost() : "null"}));
                if (selectedHostSpec == null) {
                    continue;
                }
            }
            catch (UnsupportedOperationException e) {
                LOGGER.severe(Messages.get("LimitlessRouterServiceImpl.incorrectConfiguration"));
                throw e;
            }
            catch (SQLException e) {
                continue;
            }
            try {
                context.setConnection(this.pluginService.connect(selectedHostSpec, context.getProps()));
                if (context.getConnection() == null) continue;
                return;
            }
            catch (SQLException e) {
                selectedHostSpec.setAvailability(HostAvailability.NOT_AVAILABLE);
                LOGGER.finest(Messages.get("LimitlessRouterServiceImpl.failedToConnectToHost", new Object[]{selectedHostSpec.getHost()}));
            }
        }
        throw new SQLException(Messages.get("LimitlessRouterServiceImpl.maxRetriesExceeded"));
    }

    protected void synchronouslyGetLimitlessRoutersWithRetry(LimitlessConnectionContext context) throws SQLException {
        LOGGER.finest(Messages.get("LimitlessRouterServiceImpl.synchronouslyGetLimitlessRouters"));
        int retryCount = -1;
        int maxRetries = LimitlessConnectionPlugin.GET_ROUTER_MAX_RETRIES.getInteger(context.getProps());
        int retryIntervalMs = LimitlessConnectionPlugin.GET_ROUTER_RETRY_INTERVAL_MILLIS.getInteger(context.getProps());
        do {
            try {
                this.synchronouslyGetLimitlessRouters(context);
                if (!Utils.isNullOrEmpty(context.getLimitlessRouters())) {
                    return;
                }
                Thread.sleep(retryIntervalMs);
            }
            catch (SQLException e) {
                LOGGER.finest(Messages.get("LimitlessRouterServiceImpl.getLimitlessRoutersException", new Object[]{e}));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLException(Messages.get("LimitlessRouterServiceImpl.interruptedSynchronousGetRouter"), e);
            }
            finally {
                ++retryCount;
            }
        } while (retryCount < maxRetries);
        throw new SQLException(Messages.get("LimitlessRouterServiceImpl.noRoutersAvailable"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronouslyGetLimitlessRouters(LimitlessConnectionContext context) throws SQLException {
        block7: {
            long cacheExpirationNano = TimeUnit.MILLISECONDS.toNanos(MONITOR_DISPOSAL_TIME_MS.getLong(context.getProps()));
            ReentrantLock lock = forceGetLimitlessRoutersLockMap.computeIfAbsent(this.pluginService.getHostListProvider().getClusterId(), key -> new ReentrantLock());
            lock.lock();
            try {
                List<HostSpec> newLimitlessRouters;
                List limitlessRouters = (List)limitlessRouterCache.get(this.pluginService.getHostListProvider().getClusterId(), cacheExpirationNano);
                if (!Utils.isNullOrEmpty(limitlessRouters)) {
                    context.setLimitlessRouters(limitlessRouters);
                    return;
                }
                if (context.getConnection() == null || context.getConnection().isClosed()) {
                    context.setConnection(context.getConnectFunc().call());
                }
                if (!Utils.isNullOrEmpty(newLimitlessRouters = this.queryHelper.queryForLimitlessRouters(context.getConnection(), context.getHostSpec().getPort()))) {
                    context.setLimitlessRouters(newLimitlessRouters);
                    limitlessRouterCache.put(this.pluginService.getHostListProvider().getClusterId(), newLimitlessRouters, TimeUnit.MILLISECONDS.toNanos(MONITOR_DISPOSAL_TIME_MS.getLong(context.getProps())));
                    break block7;
                }
                throw new SQLException(Messages.get("LimitlessRouterServiceImpl.fetchedEmptyRouterList"));
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void startMonitoring(@NonNull HostSpec hostSpec, @NonNull Properties props, int intervalMs) {
        try {
            String limitlessRouterMonitorKey = this.pluginService.getHostListProvider().getClusterId();
            long cacheExpirationNano = TimeUnit.MILLISECONDS.toNanos(MONITOR_DISPOSAL_TIME_MS.getLong(props));
            limitlessRouterMonitors.computeIfAbsent(limitlessRouterMonitorKey, key -> this.limitlessRouterMonitorInitializer.createLimitlessRouterMonitor(hostSpec, limitlessRouterCache, limitlessRouterMonitorKey, props, intervalMs), cacheExpirationNano);
        }
        catch (SQLException e) {
            LOGGER.warning(Messages.get("LimitlessRouterServiceImpl.errorStartingMonitor", new Object[]{e}));
            throw new RuntimeException(e);
        }
    }
}

