/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.limitless;

import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterMonitor;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterMonitorInitializer;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterService;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.SlidingExpirationCacheWithCleanupThread;

public class LimitlessRouterServiceImpl
implements LimitlessRouterService {
    public static final AwsWrapperProperty MONITOR_DISPOSAL_TIME_MS = new AwsWrapperProperty("limitlessTransactionRouterMonitorDisposalTimeMs", "600000", "Interval in milliseconds for an Limitless router monitor to be considered inactive and to be disposed.");
    protected static final long CACHE_CLEANUP_NANO = TimeUnit.MINUTES.toNanos(1L);
    protected static final ReentrantLock forceGetLimitlessRoutersLock = new ReentrantLock();
    private final LimitlessRouterMonitorInitializer limitlessRouterMonitorInitializer;
    private static final SlidingExpirationCacheWithCleanupThread<String, LimitlessRouterMonitor> limitlessRouterMonitors = new SlidingExpirationCacheWithCleanupThread(limitlessRouterMonitor -> true, limitlessRouterMonitor -> {
        try {
            limitlessRouterMonitor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }, CACHE_CLEANUP_NANO);

    public LimitlessRouterServiceImpl() {
        this(LimitlessRouterMonitor::new);
    }

    public LimitlessRouterServiceImpl(LimitlessRouterMonitorInitializer limitlessRouterMonitorInitializer) {
        this.limitlessRouterMonitorInitializer = limitlessRouterMonitorInitializer;
    }

    @Override
    public List<HostSpec> getLimitlessRouters(String clusterId, Properties props) throws SQLException {
        long cacheExpirationNano = TimeUnit.MILLISECONDS.toNanos(MONITOR_DISPOSAL_TIME_MS.getLong(props));
        LimitlessRouterMonitor limitlessRouterMonitor = (LimitlessRouterMonitor)limitlessRouterMonitors.get(clusterId, cacheExpirationNano);
        if (limitlessRouterMonitor == null) {
            throw new SQLException(Messages.get("LimitlessRouterServiceImpl.nulLimitlessRouterMonitor", new Object[]{clusterId}));
        }
        return limitlessRouterMonitor.getLimitlessRouters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HostSpec> forceGetLimitlessRouters(String clusterId, Properties props) throws SQLException {
        long cacheExpirationNano = TimeUnit.MILLISECONDS.toNanos(MONITOR_DISPOSAL_TIME_MS.getLong(props));
        LimitlessRouterMonitor limitlessRouterMonitor = (LimitlessRouterMonitor)limitlessRouterMonitors.get(clusterId, cacheExpirationNano);
        if (limitlessRouterMonitor == null) {
            throw new SQLException(Messages.get("LimitlessRouterServiceImpl.nulLimitlessRouterMonitor", new Object[]{clusterId}));
        }
        forceGetLimitlessRoutersLock.lock();
        try {
            List<HostSpec> limitlessRouterList = limitlessRouterMonitor.getLimitlessRouters();
            if (limitlessRouterList != null && !limitlessRouterList.isEmpty()) {
                List<HostSpec> list = limitlessRouterList;
                return list;
            }
            List<HostSpec> list = limitlessRouterMonitor.forceGetLimitlessRouters();
            return list;
        }
        finally {
            forceGetLimitlessRoutersLock.unlock();
        }
    }

    @Override
    public void startMonitoring(@NonNull PluginService pluginService, @NonNull HostSpec hostSpec, @NonNull Properties props, int intervalMs) {
        String limitlessRouterMonitorKey = pluginService.getHostListProvider().getClusterId();
        long cacheExpirationNano = TimeUnit.MILLISECONDS.toNanos(MONITOR_DISPOSAL_TIME_MS.getLong(props));
        limitlessRouterMonitors.computeIfAbsent(limitlessRouterMonitorKey, key -> this.limitlessRouterMonitorInitializer.createLimitlessRouterMonitor(pluginService, hostSpec, props, intervalMs), cacheExpirationNano);
    }
}

