/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.util.WrapperUtils;

public class DatabaseMetaDataWrapper
implements DatabaseMetaData {
    protected DatabaseMetaData databaseMetaData;
    protected ConnectionPluginManager pluginManager;

    public DatabaseMetaDataWrapper(@NonNull DatabaseMetaData databaseMetaData, @NonNull ConnectionPluginManager pluginManager) {
        this.databaseMetaData = databaseMetaData;
        this.pluginManager = pluginManager;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.allProceduresAreCallable", () -> this.databaseMetaData.allProceduresAreCallable(), new Object[0]);
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.allTablesAreSelectable", () -> this.databaseMetaData.allTablesAreSelectable(), new Object[0]);
    }

    @Override
    public String getURL() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getURL", () -> this.databaseMetaData.getURL(), new Object[0]);
    }

    @Override
    public String getUserName() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getUserName", () -> this.databaseMetaData.getUserName(), new Object[0]);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.isReadOnly", () -> this.databaseMetaData.isReadOnly(), new Object[0]);
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.nullsAreSortedHigh", () -> this.databaseMetaData.nullsAreSortedHigh(), new Object[0]);
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.nullsAreSortedLow", () -> this.databaseMetaData.nullsAreSortedLow(), new Object[0]);
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.nullsAreSortedAtStart", () -> this.databaseMetaData.nullsAreSortedAtStart(), new Object[0]);
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.nullsAreSortedAtEnd", () -> this.databaseMetaData.nullsAreSortedAtEnd(), new Object[0]);
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getDatabaseProductName", () -> this.databaseMetaData.getDatabaseProductName(), new Object[0]);
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getDatabaseProductVersion", () -> this.databaseMetaData.getDatabaseProductVersion(), new Object[0]);
    }

    @Override
    public String getDriverName() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getDriverName", () -> "Amazon Web Services (AWS) Advanced JDBC Wrapper", new Object[0]);
    }

    @Override
    public String getDriverVersion() throws SQLException {
        StringJoiner joiner = new StringJoiner(" ");
        joiner.add("Amazon Web Services (AWS) Advanced JDBC Wrapper").add("2.3.9").add("( Revision:").add("714166b4589a9f729cff1513295c86f00578b475").add(")");
        return joiner.toString();
    }

    @Override
    public int getDriverMajorVersion() {
        return 2;
    }

    @Override
    public int getDriverMinorVersion() {
        return 3;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.usesLocalFiles", () -> this.databaseMetaData.usesLocalFiles(), new Object[0]);
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.usesLocalFilePerTable", () -> this.databaseMetaData.usesLocalFilePerTable(), new Object[0]);
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsMixedCaseIdentifiers", () -> this.databaseMetaData.supportsMixedCaseIdentifiers(), new Object[0]);
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.storesUpperCaseIdentifiers", () -> this.databaseMetaData.storesUpperCaseIdentifiers(), new Object[0]);
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.storesLowerCaseIdentifiers", () -> this.databaseMetaData.storesLowerCaseIdentifiers(), new Object[0]);
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.storesMixedCaseIdentifiers", () -> this.databaseMetaData.storesMixedCaseIdentifiers(), new Object[0]);
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsMixedCaseQuotedIdentifiers", () -> this.databaseMetaData.supportsMixedCaseQuotedIdentifiers(), new Object[0]);
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.storesUpperCaseQuotedIdentifiers", () -> this.databaseMetaData.storesUpperCaseQuotedIdentifiers(), new Object[0]);
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.storesLowerCaseQuotedIdentifiers", () -> this.databaseMetaData.storesLowerCaseQuotedIdentifiers(), new Object[0]);
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.storesMixedCaseQuotedIdentifiers", () -> this.databaseMetaData.storesMixedCaseQuotedIdentifiers(), new Object[0]);
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getIdentifierQuoteString", () -> this.databaseMetaData.getIdentifierQuoteString(), new Object[0]);
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getSQLKeywords", () -> this.databaseMetaData.getSQLKeywords(), new Object[0]);
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getNumericFunctions", () -> this.databaseMetaData.getNumericFunctions(), new Object[0]);
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getStringFunctions", () -> this.databaseMetaData.getStringFunctions(), new Object[0]);
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getSystemFunctions", () -> this.databaseMetaData.getSystemFunctions(), new Object[0]);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getTimeDateFunctions", () -> this.databaseMetaData.getTimeDateFunctions(), new Object[0]);
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getSearchStringEscape", () -> this.databaseMetaData.getSearchStringEscape(), new Object[0]);
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getExtraNameCharacters", () -> this.databaseMetaData.getExtraNameCharacters(), new Object[0]);
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsAlterTableWithAddColumn", () -> this.databaseMetaData.supportsAlterTableWithAddColumn(), new Object[0]);
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsAlterTableWithDropColumn", () -> this.databaseMetaData.supportsAlterTableWithDropColumn(), new Object[0]);
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsColumnAliasing", () -> this.databaseMetaData.supportsColumnAliasing(), new Object[0]);
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.nullPlusNonNullIsNull", () -> this.databaseMetaData.nullPlusNonNullIsNull(), new Object[0]);
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsConvert", () -> this.databaseMetaData.supportsConvert(), new Object[0]);
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsConvert", () -> this.databaseMetaData.supportsConvert(fromType, toType), fromType, toType);
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsTableCorrelationNames", () -> this.databaseMetaData.supportsTableCorrelationNames(), new Object[0]);
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsDifferentTableCorrelationNames", () -> this.databaseMetaData.supportsDifferentTableCorrelationNames(), new Object[0]);
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsExpressionsInOrderBy", () -> this.databaseMetaData.supportsExpressionsInOrderBy(), new Object[0]);
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsOrderByUnrelated", () -> this.databaseMetaData.supportsOrderByUnrelated(), new Object[0]);
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsGroupBy", () -> this.databaseMetaData.supportsGroupBy(), new Object[0]);
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsGroupByUnrelated", () -> this.databaseMetaData.supportsGroupByUnrelated(), new Object[0]);
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsGroupByBeyondSelect", () -> this.databaseMetaData.supportsGroupByBeyondSelect(), new Object[0]);
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsLikeEscapeClause", () -> this.databaseMetaData.supportsLikeEscapeClause(), new Object[0]);
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsMultipleResultSets", () -> this.databaseMetaData.supportsMultipleResultSets(), new Object[0]);
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsMultipleTransactions", () -> this.databaseMetaData.supportsMultipleTransactions(), new Object[0]);
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsNonNullableColumns", () -> this.databaseMetaData.supportsNonNullableColumns(), new Object[0]);
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsMinimumSQLGrammar", () -> this.databaseMetaData.supportsMinimumSQLGrammar(), new Object[0]);
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsCoreSQLGrammar", () -> this.databaseMetaData.supportsCoreSQLGrammar(), new Object[0]);
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsExtendedSQLGrammar", () -> this.databaseMetaData.supportsExtendedSQLGrammar(), new Object[0]);
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsANSI92EntryLevelSQL", () -> this.databaseMetaData.supportsANSI92EntryLevelSQL(), new Object[0]);
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsANSI92IntermediateSQL", () -> this.databaseMetaData.supportsANSI92IntermediateSQL(), new Object[0]);
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsANSI92FullSQL", () -> this.databaseMetaData.supportsANSI92FullSQL(), new Object[0]);
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsIntegrityEnhancementFacility", () -> this.databaseMetaData.supportsIntegrityEnhancementFacility(), new Object[0]);
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsOuterJoins", () -> this.databaseMetaData.supportsOuterJoins(), new Object[0]);
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsFullOuterJoins", () -> this.databaseMetaData.supportsFullOuterJoins(), new Object[0]);
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsLimitedOuterJoins", () -> this.databaseMetaData.supportsLimitedOuterJoins(), new Object[0]);
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getSchemaTerm", () -> this.databaseMetaData.getSchemaTerm(), new Object[0]);
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getProcedureTerm", () -> this.databaseMetaData.getProcedureTerm(), new Object[0]);
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getCatalogTerm", () -> this.databaseMetaData.getCatalogTerm(), new Object[0]);
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.isCatalogAtStart", () -> this.databaseMetaData.isCatalogAtStart(), new Object[0]);
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getCatalogSeparator", () -> this.databaseMetaData.getCatalogSeparator(), new Object[0]);
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsSchemasInDataManipulation", () -> this.databaseMetaData.supportsSchemasInDataManipulation(), new Object[0]);
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsSchemasInProcedureCalls", () -> this.databaseMetaData.supportsSchemasInProcedureCalls(), new Object[0]);
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsSchemasInTableDefinitions", () -> this.databaseMetaData.supportsSchemasInTableDefinitions(), new Object[0]);
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsSchemasInIndexDefinitions", () -> this.databaseMetaData.supportsSchemasInIndexDefinitions(), new Object[0]);
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsSchemasInPrivilegeDefinitions", () -> this.databaseMetaData.supportsSchemasInPrivilegeDefinitions(), new Object[0]);
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsCatalogsInDataManipulation", () -> this.databaseMetaData.supportsCatalogsInDataManipulation(), new Object[0]);
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsCatalogsInProcedureCalls", () -> this.databaseMetaData.supportsCatalogsInProcedureCalls(), new Object[0]);
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsCatalogsInTableDefinitions", () -> this.databaseMetaData.supportsCatalogsInTableDefinitions(), new Object[0]);
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsCatalogsInIndexDefinitions", () -> this.databaseMetaData.supportsCatalogsInIndexDefinitions(), new Object[0]);
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsCatalogsInPrivilegeDefinitions", () -> this.databaseMetaData.supportsCatalogsInPrivilegeDefinitions(), new Object[0]);
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsPositionedDelete", () -> this.databaseMetaData.supportsPositionedDelete(), new Object[0]);
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsPositionedUpdate", () -> this.databaseMetaData.supportsPositionedUpdate(), new Object[0]);
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsSelectForUpdate", () -> this.databaseMetaData.supportsSelectForUpdate(), new Object[0]);
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsStoredProcedures", () -> this.databaseMetaData.supportsStoredProcedures(), new Object[0]);
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsSubqueriesInComparisons", () -> this.databaseMetaData.supportsSubqueriesInComparisons(), new Object[0]);
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsSubqueriesInExists", () -> this.databaseMetaData.supportsSubqueriesInExists(), new Object[0]);
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsSubqueriesInIns", () -> this.databaseMetaData.supportsSubqueriesInIns(), new Object[0]);
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsSubqueriesInQuantifieds", () -> this.databaseMetaData.supportsSubqueriesInQuantifieds(), new Object[0]);
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsCorrelatedSubqueries", () -> this.databaseMetaData.supportsCorrelatedSubqueries(), new Object[0]);
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsUnion", () -> this.databaseMetaData.supportsUnion(), new Object[0]);
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsUnionAll", () -> this.databaseMetaData.supportsUnionAll(), new Object[0]);
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsOpenCursorsAcrossCommit", () -> this.databaseMetaData.supportsOpenCursorsAcrossCommit(), new Object[0]);
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsOpenCursorsAcrossRollback", () -> this.databaseMetaData.supportsOpenCursorsAcrossRollback(), new Object[0]);
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsOpenStatementsAcrossCommit", () -> this.databaseMetaData.supportsOpenStatementsAcrossCommit(), new Object[0]);
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsOpenStatementsAcrossRollback", () -> this.databaseMetaData.supportsOpenStatementsAcrossRollback(), new Object[0]);
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxBinaryLiteralLength", () -> this.databaseMetaData.getMaxBinaryLiteralLength(), new Object[0]);
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxCharLiteralLength", () -> this.databaseMetaData.getMaxCharLiteralLength(), new Object[0]);
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxColumnNameLength", () -> this.databaseMetaData.getMaxColumnNameLength(), new Object[0]);
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxColumnsInGroupBy", () -> this.databaseMetaData.getMaxColumnsInGroupBy(), new Object[0]);
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxColumnsInIndex", () -> this.databaseMetaData.getMaxColumnsInIndex(), new Object[0]);
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxColumnsInOrderBy", () -> this.databaseMetaData.getMaxColumnsInOrderBy(), new Object[0]);
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxColumnsInSelect", () -> this.databaseMetaData.getMaxColumnsInSelect(), new Object[0]);
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxColumnsInTable", () -> this.databaseMetaData.getMaxColumnsInTable(), new Object[0]);
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxConnections", () -> this.databaseMetaData.getMaxConnections(), new Object[0]);
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxCursorNameLength", () -> this.databaseMetaData.getMaxCursorNameLength(), new Object[0]);
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxIndexLength", () -> this.databaseMetaData.getMaxIndexLength(), new Object[0]);
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxSchemaNameLength", () -> this.databaseMetaData.getMaxSchemaNameLength(), new Object[0]);
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxProcedureNameLength", () -> this.databaseMetaData.getMaxProcedureNameLength(), new Object[0]);
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxCatalogNameLength", () -> this.databaseMetaData.getMaxCatalogNameLength(), new Object[0]);
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxRowSize", () -> this.databaseMetaData.getMaxRowSize(), new Object[0]);
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.doesMaxRowSizeIncludeBlobs", () -> this.databaseMetaData.doesMaxRowSizeIncludeBlobs(), new Object[0]);
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxStatementLength", () -> this.databaseMetaData.getMaxStatementLength(), new Object[0]);
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxStatements", () -> this.databaseMetaData.getMaxStatements(), new Object[0]);
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxTableNameLength", () -> this.databaseMetaData.getMaxTableNameLength(), new Object[0]);
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxTablesInSelect", () -> this.databaseMetaData.getMaxTablesInSelect(), new Object[0]);
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxUserNameLength", () -> this.databaseMetaData.getMaxUserNameLength(), new Object[0]);
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getDefaultTransactionIsolation", () -> this.databaseMetaData.getDefaultTransactionIsolation(), new Object[0]);
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsTransactions", () -> this.databaseMetaData.supportsTransactions(), new Object[0]);
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsTransactionIsolationLevel", () -> this.databaseMetaData.supportsTransactionIsolationLevel(level), level);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions", () -> this.databaseMetaData.supportsDataDefinitionAndDataManipulationTransactions(), new Object[0]);
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsDataManipulationTransactionsOnly", () -> this.databaseMetaData.supportsDataManipulationTransactionsOnly(), new Object[0]);
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.dataDefinitionCausesTransactionCommit", () -> this.databaseMetaData.dataDefinitionCausesTransactionCommit(), new Object[0]);
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.dataDefinitionIgnoredInTransactions", () -> this.databaseMetaData.dataDefinitionIgnoredInTransactions(), new Object[0]);
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getProcedures", () -> this.databaseMetaData.getProcedures(catalog, schemaPattern, procedureNamePattern), catalog, schemaPattern, procedureNamePattern);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getProcedureColumns", () -> this.databaseMetaData.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern), catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getTables", () -> this.databaseMetaData.getTables(catalog, schemaPattern, tableNamePattern, types), catalog, schemaPattern, tableNamePattern, types);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getSchemas", () -> this.databaseMetaData.getSchemas(), new Object[0]);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getSchemas", () -> this.databaseMetaData.getSchemas(catalog, schemaPattern), catalog, schemaPattern);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getCatalogs", () -> this.databaseMetaData.getCatalogs(), new Object[0]);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getTableTypes", () -> this.databaseMetaData.getTableTypes(), new Object[0]);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getColumns", () -> this.databaseMetaData.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern), catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getColumnPrivileges", () -> this.databaseMetaData.getColumnPrivileges(catalog, schema, table, columnNamePattern), catalog, schema, table, columnNamePattern);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getTablePrivileges", () -> this.databaseMetaData.getTablePrivileges(catalog, schemaPattern, tableNamePattern), catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getBestRowIdentifier", () -> this.databaseMetaData.getBestRowIdentifier(catalog, schema, table, scope, nullable), catalog, schema, table, scope, nullable);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getVersionColumns", () -> this.databaseMetaData.getVersionColumns(catalog, schema, table), catalog, schema, table);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getPrimaryKeys", () -> this.databaseMetaData.getPrimaryKeys(catalog, schema, table), catalog, schema, table);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getImportedKeys", () -> this.databaseMetaData.getImportedKeys(catalog, schema, table), catalog, schema, table);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getExportedKeys", () -> this.databaseMetaData.getExportedKeys(catalog, schema, table), catalog, schema, table);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getCrossReference", () -> this.databaseMetaData.getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable), parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getTypeInfo", () -> this.databaseMetaData.getTypeInfo(), new Object[0]);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getIndexInfo", () -> this.databaseMetaData.getIndexInfo(catalog, schema, table, unique, approximate), catalog, schema, table, unique, approximate);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsResultSetType", () -> this.databaseMetaData.supportsResultSetType(type), type);
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsResultSetConcurrency", () -> this.databaseMetaData.supportsResultSetConcurrency(type, concurrency), type, concurrency);
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.ownUpdatesAreVisible", () -> this.databaseMetaData.ownUpdatesAreVisible(type), type);
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.ownDeletesAreVisible", () -> this.databaseMetaData.ownDeletesAreVisible(type), type);
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.ownInsertsAreVisible", () -> this.databaseMetaData.ownInsertsAreVisible(type), type);
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.othersUpdatesAreVisible", () -> this.databaseMetaData.othersUpdatesAreVisible(type), type);
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.othersDeletesAreVisible", () -> this.databaseMetaData.othersDeletesAreVisible(type), type);
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.othersInsertsAreVisible", () -> this.databaseMetaData.othersInsertsAreVisible(type), type);
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.updatesAreDetected", () -> this.databaseMetaData.updatesAreDetected(type), type);
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.deletesAreDetected", () -> this.databaseMetaData.deletesAreDetected(type), type);
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.insertsAreDetected", () -> this.databaseMetaData.insertsAreDetected(type), type);
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsBatchUpdates", () -> this.databaseMetaData.supportsBatchUpdates(), new Object[0]);
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getUDTs", () -> this.databaseMetaData.getUDTs(catalog, schemaPattern, typeNamePattern, types), catalog, schemaPattern, typeNamePattern, types);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return WrapperUtils.executeWithPlugins(Connection.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getConnection", () -> this.pluginManager.getConnectionWrapper(), new Object[0]);
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsSavepoints", () -> this.databaseMetaData.supportsSavepoints(), new Object[0]);
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsNamedParameters", () -> this.databaseMetaData.supportsNamedParameters(), new Object[0]);
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsMultipleOpenResults", () -> this.databaseMetaData.supportsMultipleOpenResults(), new Object[0]);
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsGetGeneratedKeys", () -> this.databaseMetaData.supportsGetGeneratedKeys(), new Object[0]);
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getSuperTypes", () -> this.databaseMetaData.getSuperTypes(catalog, schemaPattern, typeNamePattern), catalog, schemaPattern, typeNamePattern);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getSuperTables", () -> this.databaseMetaData.getSuperTables(catalog, schemaPattern, tableNamePattern), catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getAttributes", () -> this.databaseMetaData.getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern), catalog, schemaPattern, typeNamePattern, attributeNamePattern);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsResultSetHoldability", () -> this.databaseMetaData.supportsResultSetHoldability(holdability), holdability);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getResultSetHoldability", () -> this.databaseMetaData.getResultSetHoldability(), new Object[0]);
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getDatabaseMajorVersion", () -> this.databaseMetaData.getDatabaseMajorVersion(), new Object[0]);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getDatabaseMinorVersion", () -> this.databaseMetaData.getDatabaseMinorVersion(), new Object[0]);
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getJDBCMajorVersion", () -> this.databaseMetaData.getJDBCMajorVersion(), new Object[0]);
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getJDBCMinorVersion", () -> this.databaseMetaData.getJDBCMinorVersion(), new Object[0]);
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getSQLStateType", () -> this.databaseMetaData.getSQLStateType(), new Object[0]);
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.locatorsUpdateCopy", () -> this.databaseMetaData.locatorsUpdateCopy(), new Object[0]);
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsStatementPooling", () -> this.databaseMetaData.supportsStatementPooling(), new Object[0]);
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return WrapperUtils.executeWithPlugins(RowIdLifetime.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getRowIdLifetime", () -> this.databaseMetaData.getRowIdLifetime(), new Object[0]);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsStoredFunctionsUsingCallSyntax", () -> this.databaseMetaData.supportsStoredFunctionsUsingCallSyntax(), new Object[0]);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.autoCommitFailureClosesAllResultSets", () -> this.databaseMetaData.autoCommitFailureClosesAllResultSets(), new Object[0]);
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getClientInfoProperties", () -> this.databaseMetaData.getClientInfoProperties(), new Object[0]);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getFunctions", () -> this.databaseMetaData.getFunctions(catalog, schemaPattern, functionNamePattern), catalog, schemaPattern, functionNamePattern);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getFunctionColumns", () -> this.databaseMetaData.getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern), catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getPseudoColumns", () -> this.databaseMetaData.getPseudoColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern), catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.generatedKeyAlwaysReturned", () -> this.databaseMetaData.generatedKeyAlwaysReturned(), new Object[0]);
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        return WrapperUtils.executeWithPlugins(Long.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.getMaxLogicalLobSize", () -> this.databaseMetaData.getMaxLogicalLobSize(), new Object[0]);
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.databaseMetaData, "DatabaseMetaData.supportsRefCursors", () -> this.databaseMetaData.supportsRefCursors(), new Object[0]);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.databaseMetaData.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.databaseMetaData.isWrapperFor(iface);
    }

    public String toString() {
        return super.toString() + " - " + this.databaseMetaData;
    }
}

