/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.federatedauth;

import java.security.GeneralSecurityException;
import java.util.Properties;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.ConnectionPluginFactory;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.federatedauth.AdfsCredentialsProviderFactory;
import software.amazon.jdbc.plugin.federatedauth.CredentialsProviderFactory;
import software.amazon.jdbc.plugin.federatedauth.FederatedAuthPlugin;
import software.amazon.jdbc.plugin.federatedauth.HttpClientFactory;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.StringUtils;

public class FederatedAuthPluginFactory
implements ConnectionPluginFactory {
    @Override
    public ConnectionPlugin getInstance(PluginService pluginService, Properties props) {
        return new FederatedAuthPlugin(pluginService, this.getCredentialsProviderFactory(pluginService, props));
    }

    private CredentialsProviderFactory getCredentialsProviderFactory(PluginService pluginService, Properties props) {
        String idpName = FederatedAuthPlugin.IDP_NAME.getString(props);
        if (StringUtils.isNullOrEmpty(idpName) || "adfs".equalsIgnoreCase(idpName)) {
            return new AdfsCredentialsProviderFactory(pluginService, () -> {
                try {
                    return new HttpClientFactory().getCloseableHttpClient(FederatedAuthPlugin.HTTP_CLIENT_SOCKET_TIMEOUT.getInteger(props), FederatedAuthPlugin.HTTP_CLIENT_CONNECT_TIMEOUT.getInteger(props), FederatedAuthPlugin.SSL_INSECURE.getBoolean(props));
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException(Messages.get("FederatedAuthPluginFactory.failedToInitializeHttpClient"), e);
                }
            });
        }
        throw new IllegalArgumentException(Messages.get("FederatedAuthPluginFactory.unsupportedIdp", new Object[]{idpName}));
    }
}

