/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.targetdriverdialect.ConnectInfo;
import software.amazon.jdbc.targetdriverdialect.GenericTargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.MariadbDriverHelper;

public class MariadbTargetDriverDialect
extends GenericTargetDriverDialect {
    private static final String PERMIT_MYSQL_SCHEME = "permitMysqlScheme";
    private static final String DRIVER_CLASS_NAME = "org.mariadb.jdbc.Driver";
    private static final String DS_CLASS_NAME = "org.mariadb.jdbc.MariaDbDataSource";
    private static final String CP_DS_CLASS_NAME = "org.mariadb.jdbc.MariaDbPoolDataSource";

    @Override
    public boolean isDialect(Driver driver) {
        return DRIVER_CLASS_NAME.equals(driver.getClass().getName());
    }

    @Override
    public boolean isDialect(String dataSourceClass) {
        return DS_CLASS_NAME.equals(dataSourceClass) || CP_DS_CLASS_NAME.equals(dataSourceClass);
    }

    @Override
    public ConnectInfo prepareConnectInfo(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        String databaseName = PropertyDefinition.DATABASE.getString(props) != null ? PropertyDefinition.DATABASE.getString(props) : "";
        boolean permitMysqlSchemeFlag = props.containsKey(PERMIT_MYSQL_SCHEME);
        props.remove(PERMIT_MYSQL_SCHEME);
        PropertyDefinition.removeAllExcept(props, PropertyDefinition.USER.name, PropertyDefinition.PASSWORD.name, PropertyDefinition.TCP_KEEP_ALIVE.name, PropertyDefinition.CONNECT_TIMEOUT.name, PropertyDefinition.SOCKET_TIMEOUT.name);
        String urlBuilder = protocol + hostSpec.getUrl() + databaseName + (permitMysqlSchemeFlag ? "?permitMysqlScheme" : "");
        return new ConnectInfo(urlBuilder, props);
    }

    @Override
    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        MariadbDriverHelper helper = new MariadbDriverHelper();
        helper.prepareDataSource(dataSource, protocol, hostSpec, props);
    }

    @Override
    public boolean isDriverRegistered() throws SQLException {
        MariadbDriverHelper helper = new MariadbDriverHelper();
        return helper.isDriverRegistered();
    }

    @Override
    public void registerDriver() throws SQLException {
        MariadbDriverHelper helper = new MariadbDriverHelper();
        helper.registerDriver();
    }
}

