/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import software.amazon.jdbc.dialect.PgDialect;

public class RdsPgDialect
extends PgDialect {
    private static final Logger LOGGER = Logger.getLogger(RdsPgDialect.class.getName());
    private static final List<String> dialectUpdateCandidates = Collections.singletonList("aurora-pg");
    private static final String extensionsSql = "SELECT (setting LIKE '%rds_tools%') AS rds_tools, (setting LIKE '%aurora_stat_utils%') AS aurora_stat_utils FROM pg_settings WHERE name='rds.extensions'";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDialect(Connection connection) {
        if (!super.isDialect(connection)) {
            return false;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(extensionsSql);
            while (true) {
                if (rs.next()) {
                    boolean rdsTools = rs.getBoolean("rds_tools");
                    boolean auroraUtils = rs.getBoolean("aurora_stat_utils");
                    LOGGER.finest(() -> String.format("rdsTools: %b, auroraUtils: %b", rdsTools, auroraUtils));
                    if (!rdsTools || auroraUtils) continue;
                    boolean bl = true;
                    return bl;
                    continue;
                }
                break;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    @Override
    public List<String> getDialectUpdateCandidates() {
        return dialectUpdateCandidates;
    }
}

