/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.failover;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.OldConnectionSuggestedAction;
import software.amazon.jdbc.PluginManagerService;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.failover.ClusterAwareReaderFailoverHandler;
import software.amazon.jdbc.plugin.failover.ClusterAwareWriterFailoverHandler;
import software.amazon.jdbc.plugin.failover.FailoverFailedSQLException;
import software.amazon.jdbc.plugin.failover.FailoverMode;
import software.amazon.jdbc.plugin.failover.FailoverSuccessSQLException;
import software.amazon.jdbc.plugin.failover.ReaderFailoverHandler;
import software.amazon.jdbc.plugin.failover.ReaderFailoverResult;
import software.amazon.jdbc.plugin.failover.TransactionStateUnknownSQLException;
import software.amazon.jdbc.plugin.failover.WriterFailoverHandler;
import software.amazon.jdbc.plugin.failover.WriterFailoverResult;
import software.amazon.jdbc.plugin.staledns.AuroraStaleDnsHelper;
import software.amazon.jdbc.states.RestoreSessionStateCallable;
import software.amazon.jdbc.states.SessionDirtyFlag;
import software.amazon.jdbc.states.SessionStateHelper;
import software.amazon.jdbc.states.SessionStateTransferCallable;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.SqlState;
import software.amazon.jdbc.util.SubscribedMethodHelper;
import software.amazon.jdbc.util.Utils;
import software.amazon.jdbc.util.WrapperUtils;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class FailoverConnectionPlugin
extends AbstractConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(FailoverConnectionPlugin.class.getName());
    private static final String TELEMETRY_WRITER_FAILOVER = "failover to writer node";
    private static final String TELEMETRY_READER_FAILOVER = "failover to replica";
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.addAll(SubscribedMethodHelper.NETWORK_BOUND_METHODS);
            this.add("initHostProvider");
            this.add("connect");
            this.add("forceConnect");
            this.add("notifyConnectionChanged");
            this.add("notifyNodeListChanged");
        }
    });
    private static final String METHOD_SET_READ_ONLY = "Connection.setReadOnly";
    private static final String METHOD_SET_AUTO_COMMIT = "Connection.setAutoCommit";
    private static final String METHOD_GET_AUTO_COMMIT = "Connection.getAutoCommit";
    private static final String METHOD_GET_CATALOG = "Connection.getCatalog";
    private static final String METHOD_GET_SCHEMA = "Connection.getSchema";
    private static final String METHOD_GET_TRANSACTION_ISOLATION = "Connection.getTransactionIsolation";
    static final String METHOD_ABORT = "Connection.abort";
    static final String METHOD_CLOSE = "Connection.close";
    static final String METHOD_IS_CLOSED = "Connection.isClosed";
    protected static SessionStateTransferCallable sessionStateTransferCallable;
    protected static RestoreSessionStateCallable restoreSessionStateCallable;
    private final PluginService pluginService;
    protected final Properties properties;
    protected boolean enableFailoverSetting;
    protected int failoverTimeoutMsSetting;
    protected int failoverClusterTopologyRefreshRateMsSetting;
    protected int failoverWriterReconnectIntervalMsSetting;
    protected int failoverReaderConnectTimeoutMsSetting;
    protected boolean keepSessionStateOnFailover;
    protected FailoverMode failoverMode;
    private boolean telemetryFailoverAdditionalTopTraceSetting;
    private boolean closedExplicitly = false;
    protected boolean isClosed = false;
    protected String closedReason = null;
    private final RdsUtils rdsHelper;
    protected WriterFailoverHandler writerFailoverHandler = null;
    protected ReaderFailoverHandler readerFailoverHandler = null;
    private Throwable lastExceptionDealtWith = null;
    private PluginManagerService pluginManagerService;
    private boolean isInTransaction = false;
    private RdsUrlType rdsUrlType;
    private HostListProviderService hostListProviderService;
    private final AuroraStaleDnsHelper staleDnsHelper;
    private Boolean savedReadOnlyStatus;
    private Boolean savedAutoCommitStatus;
    public static final AwsWrapperProperty FAILOVER_CLUSTER_TOPOLOGY_REFRESH_RATE_MS;
    public static final AwsWrapperProperty FAILOVER_TIMEOUT_MS;
    public static final AwsWrapperProperty FAILOVER_WRITER_RECONNECT_INTERVAL_MS;
    public static final AwsWrapperProperty FAILOVER_READER_CONNECT_TIMEOUT_MS;
    public static final AwsWrapperProperty ENABLE_CLUSTER_AWARE_FAILOVER;
    public static final AwsWrapperProperty FAILOVER_MODE;
    public static final AwsWrapperProperty KEEP_SESSION_STATE_ON_FAILOVER;
    public static final AwsWrapperProperty TELEMETRY_FAILOVER_ADDITIONAL_TOP_TRACE;
    private final TelemetryCounter failoverWriterTriggeredCounter;
    private final TelemetryCounter failoverWriterSuccessCounter;
    private final TelemetryCounter failoverWriterFailedCounter;
    private final TelemetryCounter failoverReaderTriggeredCounter;
    private final TelemetryCounter failoverReaderSuccessCounter;
    private final TelemetryCounter failoverReaderFailedCounter;

    public FailoverConnectionPlugin(PluginService pluginService, Properties properties) {
        this(pluginService, properties, new RdsUtils());
    }

    FailoverConnectionPlugin(PluginService pluginService, Properties properties, RdsUtils rdsHelper) {
        this.pluginService = pluginService;
        this.properties = properties;
        this.rdsHelper = rdsHelper;
        if (pluginService instanceof PluginManagerService) {
            this.pluginManagerService = (PluginManagerService)((Object)pluginService);
        }
        this.initSettings();
        this.staleDnsHelper = new AuroraStaleDnsHelper(this.pluginService);
        TelemetryFactory telemetryFactory = this.pluginService.getTelemetryFactory();
        this.failoverWriterTriggeredCounter = telemetryFactory.createCounter("writerFailover.triggered.count");
        this.failoverWriterSuccessCounter = telemetryFactory.createCounter("writerFailover.completed.success.count");
        this.failoverWriterFailedCounter = telemetryFactory.createCounter("writerFailover.completed.failed.count");
        this.failoverReaderTriggeredCounter = telemetryFactory.createCounter("readerFailover.triggered.count");
        this.failoverReaderSuccessCounter = telemetryFactory.createCounter("readerFailover.completed.success.count");
        this.failoverReaderFailedCounter = telemetryFactory.createCounter("readerFailover.completed.failed.count");
    }

    public static void setSessionStateTransferFunc(SessionStateTransferCallable callable) {
        sessionStateTransferCallable = callable;
    }

    public static void resetSessionStateTransferFunc() {
        sessionStateTransferCallable = null;
    }

    public static void setRestoreSessionStateFunc(RestoreSessionStateCallable callable) {
        restoreSessionStateCallable = callable;
    }

    public static void resetRestoreSessionStateFunc() {
        restoreSessionStateCallable = null;
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        if (!this.enableFailoverSetting || this.canDirectExecute(methodName)) {
            return jdbcMethodFunc.call();
        }
        if (this.isClosed && !this.allowedOnClosedConnection(methodName)) {
            try {
                this.invalidInvocationOnClosedConnection();
            }
            catch (SQLException ex) {
                throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, ex);
            }
        }
        if (methodName.equals(METHOD_SET_READ_ONLY) && jdbcMethodArgs != null && jdbcMethodArgs.length > 0) {
            this.savedReadOnlyStatus = (Boolean)jdbcMethodArgs[0];
        }
        if (methodName.equals(METHOD_SET_AUTO_COMMIT) && jdbcMethodArgs != null && jdbcMethodArgs.length > 0) {
            this.savedAutoCommitStatus = (Boolean)jdbcMethodArgs[0];
        }
        T result = null;
        try {
            if (this.canUpdateTopology(methodName)) {
                this.updateTopology(false);
            }
            result = jdbcMethodFunc.call();
        }
        catch (IllegalStateException e) {
            this.dealWithIllegalStateException(e, exceptionClass);
        }
        catch (Exception e) {
            this.dealWithOriginalException(e, null, exceptionClass);
        }
        return result;
    }

    @Override
    public void initHostProvider(String driverProtocol, String initialUrl, Properties properties, HostListProviderService hostListProviderService, JdbcCallable<Void, SQLException> initHostProviderFunc) throws SQLException {
        this.initHostProvider(initialUrl, hostListProviderService, initHostProviderFunc, () -> new ClusterAwareReaderFailoverHandler(this.pluginService, this.properties, this.failoverTimeoutMsSetting, this.failoverReaderConnectTimeoutMsSetting, this.failoverMode == FailoverMode.STRICT_READER), () -> new ClusterAwareWriterFailoverHandler(this.pluginService, this.readerFailoverHandler, this.properties, this.failoverTimeoutMsSetting, this.failoverClusterTopologyRefreshRateMsSetting, this.failoverWriterReconnectIntervalMsSetting));
    }

    void initHostProvider(String initialUrl, HostListProviderService hostListProviderService, JdbcCallable<Void, SQLException> initHostProviderFunc, Supplier<ClusterAwareReaderFailoverHandler> readerFailoverHandlerSupplier, Supplier<ClusterAwareWriterFailoverHandler> writerFailoverHandlerSupplier) throws SQLException {
        this.hostListProviderService = hostListProviderService;
        if (!this.enableFailoverSetting) {
            return;
        }
        this.readerFailoverHandler = readerFailoverHandlerSupplier.get();
        this.writerFailoverHandler = writerFailoverHandlerSupplier.get();
        initHostProviderFunc.call();
        this.failoverMode = FailoverMode.fromValue(FAILOVER_MODE.getString(this.properties));
        this.rdsUrlType = this.rdsHelper.identifyRdsType(initialUrl);
        if (this.failoverMode == null) {
            this.failoverMode = this.rdsUrlType.isRdsCluster() ? (this.rdsUrlType == RdsUrlType.RDS_READER_CLUSTER ? FailoverMode.READER_OR_WRITER : FailoverMode.STRICT_WRITER) : FailoverMode.STRICT_WRITER;
        }
        LOGGER.finer(() -> Messages.get("Failover.parameterValue", new Object[]{"failoverMode", this.failoverMode}));
    }

    @Override
    public OldConnectionSuggestedAction notifyConnectionChanged(EnumSet<NodeChangeOptions> changes) {
        return OldConnectionSuggestedAction.NO_OPINION;
    }

    @Override
    public void notifyNodeListChanged(Map<String, EnumSet<NodeChangeOptions>> changes) {
        HostSpec currentHost;
        String url;
        if (!this.enableFailoverSetting) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder("Changes:");
            for (Map.Entry<String, EnumSet<NodeChangeOptions>> change : changes.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(String.format("\tHost '%s': %s", change.getKey(), change.getValue()));
            }
            LOGGER.finest(sb.toString());
        }
        if (this.isNodeStillValid(url = (currentHost = this.pluginService.getCurrentHostSpec()).getUrl(), changes)) {
            return;
        }
        for (String alias : currentHost.getAliases()) {
            if (!this.isNodeStillValid(alias + "/", changes)) continue;
            return;
        }
        LOGGER.fine(() -> Messages.get("Failover.invalidNode", new Object[]{currentHost}));
    }

    private boolean isNodeStillValid(String node, Map<String, EnumSet<NodeChangeOptions>> changes) {
        if (changes.containsKey(node)) {
            EnumSet<NodeChangeOptions> options = changes.get(node);
            return !options.contains((Object)NodeChangeOptions.NODE_DELETED) && !options.contains((Object)NodeChangeOptions.WENT_DOWN);
        }
        return true;
    }

    void setRdsUrlType(RdsUrlType rdsUrlType) {
        this.rdsUrlType = rdsUrlType;
    }

    public boolean isFailoverEnabled() {
        return this.enableFailoverSetting && !RdsUrlType.RDS_PROXY.equals((Object)this.rdsUrlType) && !Utils.isNullOrEmpty(this.pluginService.getHosts());
    }

    private void initSettings() {
        this.enableFailoverSetting = ENABLE_CLUSTER_AWARE_FAILOVER.getBoolean(this.properties);
        this.failoverTimeoutMsSetting = FAILOVER_TIMEOUT_MS.getInteger(this.properties);
        this.failoverClusterTopologyRefreshRateMsSetting = FAILOVER_CLUSTER_TOPOLOGY_REFRESH_RATE_MS.getInteger(this.properties);
        this.failoverWriterReconnectIntervalMsSetting = FAILOVER_WRITER_RECONNECT_INTERVAL_MS.getInteger(this.properties);
        this.failoverReaderConnectTimeoutMsSetting = FAILOVER_READER_CONNECT_TIMEOUT_MS.getInteger(this.properties);
        this.keepSessionStateOnFailover = KEEP_SESSION_STATE_ON_FAILOVER.getBoolean(this.properties);
        this.telemetryFailoverAdditionalTopTraceSetting = TELEMETRY_FAILOVER_ADDITIONAL_TOP_TRACE.getBoolean(this.properties);
    }

    private void invalidInvocationOnClosedConnection() throws SQLException {
        if (!this.closedExplicitly) {
            this.isClosed = false;
            this.closedReason = null;
            this.pickNewConnection();
            LOGGER.info(Messages.get("Failover.connectionChangedError"));
            throw new FailoverSuccessSQLException();
        }
        String reason = Messages.get("Failover.noOperationsAfterConnectionClosed");
        if (this.closedReason != null) {
            reason = reason + " " + this.closedReason;
        }
        throw new SQLException(reason, SqlState.CONNECTION_NOT_OPEN.getState());
    }

    private HostSpec getCurrentWriter() throws SQLException {
        List<HostSpec> topology = this.pluginService.getHosts();
        if (topology == null) {
            return null;
        }
        return this.getWriter(topology);
    }

    private HostSpec getWriter(@NonNull List<HostSpec> hosts) {
        for (HostSpec hostSpec : hosts) {
            if (hostSpec.getRole() != HostRole.WRITER) continue;
            return hostSpec;
        }
        return null;
    }

    protected void updateTopology(boolean forceUpdate) throws SQLException {
        Connection connection = this.pluginService.getCurrentConnection();
        if (!this.isFailoverEnabled() || connection == null || connection.isClosed()) {
            return;
        }
        if (forceUpdate) {
            this.pluginService.forceRefreshHostList();
        } else {
            this.pluginService.refreshHostList();
        }
    }

    private boolean allowedOnClosedConnection(String methodName) {
        return methodName.equals(METHOD_GET_AUTO_COMMIT) || methodName.equals(METHOD_GET_CATALOG) || methodName.equals(METHOD_GET_SCHEMA) || methodName.equals(METHOD_GET_TRANSACTION_ISOLATION);
    }

    private boolean canUpdateTopology(String methodName) {
        return SubscribedMethodHelper.METHODS_REQUIRING_UPDATED_TOPOLOGY.contains(methodName);
    }

    private void connectTo(HostSpec host) throws SQLException {
        try {
            this.switchCurrentConnectionTo(host, this.createConnectionForHost(host));
            LOGGER.fine(() -> Messages.get("Failover.establishedConnection", new Object[]{host}));
        }
        catch (SQLException e) {
            if (this.pluginService.getCurrentConnection() != null) {
                String msg = "Connection to " + (this.isWriter(host) ? "writer" : "reader") + " host '" + host.getUrl() + "' failed";
                LOGGER.warning(() -> String.format("%s: %s", msg, e.getMessage()));
            }
            throw e;
        }
    }

    private boolean isWriter(HostSpec hostSpec) {
        return hostSpec.getRole() == HostRole.WRITER;
    }

    private void processFailoverFailure(String message) throws SQLException {
        LOGGER.severe(message);
        throw new FailoverFailedSQLException(message);
    }

    private boolean shouldAttemptReaderConnection() {
        List<HostSpec> topology = this.pluginService.getHosts();
        if (topology == null || this.failoverMode == FailoverMode.STRICT_WRITER) {
            return false;
        }
        for (HostSpec hostSpec : topology) {
            if (hostSpec.getRole() != HostRole.READER) continue;
            return true;
        }
        return false;
    }

    private void switchCurrentConnectionTo(HostSpec host, Connection connection) throws SQLException {
        Connection currentConnection = this.pluginService.getCurrentConnection();
        HostSpec currentHostSpec = this.pluginService.getCurrentHostSpec();
        if (currentConnection != connection) {
            this.transferSessionState(currentConnection, currentHostSpec, connection, host);
            this.invalidateCurrentConnection();
        }
        this.pluginService.setCurrentConnection(connection, host);
        if (this.pluginManagerService != null) {
            this.pluginManagerService.setInTransaction(false);
        }
    }

    protected void transferSessionState(Connection src, HostSpec srcHostSpec, Connection dest, HostSpec destHostSpec) throws SQLException {
        boolean isHandled;
        if (src == null || dest == null) {
            return;
        }
        EnumSet<SessionDirtyFlag> sessionState = this.pluginService.getCurrentConnectionState();
        SessionStateTransferCallable callableCopy = sessionStateTransferCallable;
        if (callableCopy != null && (isHandled = callableCopy.transferSessionState(sessionState, src, srcHostSpec, dest, destHostSpec))) {
            return;
        }
        sessionState = this.pluginService.getCurrentConnectionState();
        SessionStateHelper helper = new SessionStateHelper();
        helper.transferSessionState(sessionState, src, dest);
    }

    protected void restoreSessionState(Connection dest) throws SQLException {
        boolean isHandled;
        if (dest == null) {
            return;
        }
        RestoreSessionStateCallable callableCopy = restoreSessionStateCallable;
        if (callableCopy != null && (isHandled = callableCopy.restoreSessionState(this.pluginService.getCurrentConnectionState(), dest, this.savedReadOnlyStatus, this.savedAutoCommitStatus))) {
            return;
        }
        SessionStateHelper helper = new SessionStateHelper();
        helper.restoreSessionState(dest, this.savedReadOnlyStatus, this.savedAutoCommitStatus);
    }

    private <E extends Exception> void dealWithOriginalException(Throwable originalException, Throwable wrapperException, Class<E> exceptionClass) throws E {
        Throwable exceptionToThrow = wrapperException;
        if (originalException != null) {
            LOGGER.finer(() -> Messages.get("Failover.detectedException", new Object[]{originalException.getMessage()}));
            if (this.lastExceptionDealtWith != originalException && this.shouldExceptionTriggerConnectionSwitch(originalException)) {
                this.invalidateCurrentConnection();
                this.pluginService.setAvailability(this.pluginService.getCurrentHostSpec().getAliases(), HostAvailability.NOT_AVAILABLE);
                try {
                    this.pickNewConnection();
                }
                catch (SQLException e) {
                    throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, e);
                }
                this.lastExceptionDealtWith = originalException;
            }
            if (originalException instanceof Error) {
                throw (Error)originalException;
            }
            exceptionToThrow = originalException;
        }
        if (exceptionToThrow instanceof Error) {
            throw (Error)exceptionToThrow;
        }
        throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, exceptionToThrow);
    }

    protected Connection createConnectionForHost(HostSpec baseHostSpec) throws SQLException {
        return this.pluginService.connect(baseHostSpec, this.properties);
    }

    protected <E extends Exception> void dealWithIllegalStateException(IllegalStateException e, Class<E> exceptionClass) throws E {
        this.dealWithOriginalException(e.getCause(), e, exceptionClass);
    }

    protected synchronized void failover(HostSpec failedHost) throws SQLException {
        this.pluginService.setAvailability(failedHost.asAliases(), HostAvailability.NOT_AVAILABLE);
        if (this.failoverMode == FailoverMode.STRICT_WRITER) {
            this.failoverWriter();
        } else {
            this.failoverReader(failedHost);
        }
        if (this.isInTransaction || this.pluginService.isInTransaction()) {
            if (this.pluginManagerService != null) {
                this.pluginManagerService.setInTransaction(false);
            }
            String errorMessage = Messages.get("Failover.transactionResolutionUnknownError");
            LOGGER.info(errorMessage);
            throw new TransactionStateUnknownSQLException();
        }
        LOGGER.severe(() -> Messages.get("Failover.connectionChangedError"));
        throw new FailoverSuccessSQLException();
    }

    protected void failoverReader(HostSpec failedHostSpec) throws SQLException {
        TelemetryFactory telemetryFactory = this.pluginService.getTelemetryFactory();
        TelemetryContext telemetryContext = telemetryFactory.openTelemetryContext(TELEMETRY_READER_FAILOVER, TelemetryTraceLevel.NESTED);
        this.failoverReaderTriggeredCounter.inc();
        try {
            SQLException exception;
            ReaderFailoverResult result;
            LOGGER.fine(() -> Messages.get("Failover.startReaderFailover"));
            HostSpec failedHost = null;
            Set<String> oldAliases = this.pluginService.getCurrentHostSpec().getAliases();
            if (failedHostSpec != null && failedHostSpec.getRawAvailability() == HostAvailability.AVAILABLE) {
                failedHost = failedHostSpec;
            }
            if ((result = this.readerFailoverHandler.failover(this.pluginService.getHosts(), failedHost)) != null && (exception = result.getException()) != null) {
                throw exception;
            }
            if (result == null || !result.isConnected()) {
                this.processFailoverFailure(Messages.get("Failover.unableToConnectToReader"));
                this.failoverReaderFailedCounter.inc();
                return;
            }
            if (this.keepSessionStateOnFailover) {
                this.restoreSessionState(result.getConnection());
            }
            this.pluginService.setCurrentConnection(result.getConnection(), result.getHost());
            this.pluginService.getCurrentHostSpec().removeAlias(oldAliases.toArray(new String[0]));
            this.updateTopology(true);
            LOGGER.fine(() -> Messages.get("Failover.establishedConnection", new Object[]{this.pluginService.getCurrentHostSpec()}));
            this.failoverReaderSuccessCounter.inc();
        }
        catch (FailoverSuccessSQLException ex) {
            telemetryContext.setSuccess(true);
            telemetryContext.setException(ex);
            this.failoverReaderSuccessCounter.inc();
            throw ex;
        }
        catch (Exception ex) {
            telemetryContext.setSuccess(false);
            telemetryContext.setException(ex);
            this.failoverReaderFailedCounter.inc();
            throw ex;
        }
        finally {
            telemetryContext.closeContext();
            if (this.telemetryFailoverAdditionalTopTraceSetting) {
                telemetryFactory.postCopy(telemetryContext, TelemetryTraceLevel.FORCE_TOP_LEVEL);
            }
        }
    }

    protected void failoverWriter() throws SQLException {
        TelemetryFactory telemetryFactory = this.pluginService.getTelemetryFactory();
        TelemetryContext telemetryContext = telemetryFactory.openTelemetryContext(TELEMETRY_WRITER_FAILOVER, TelemetryTraceLevel.NESTED);
        this.failoverWriterTriggeredCounter.inc();
        try {
            SQLException exception;
            LOGGER.fine(() -> Messages.get("Failover.startWriterFailover"));
            WriterFailoverResult failoverResult = this.writerFailoverHandler.failover(this.pluginService.getHosts());
            if (failoverResult != null && (exception = failoverResult.getException()) != null) {
                throw exception;
            }
            if (failoverResult == null || !failoverResult.isConnected()) {
                this.processFailoverFailure(Messages.get("Failover.unableToConnectToWriter"));
                this.failoverWriterFailedCounter.inc();
                return;
            }
            HostSpec writerHostSpec = this.getWriter(failoverResult.getTopology());
            if (this.keepSessionStateOnFailover) {
                this.restoreSessionState(failoverResult.getNewConnection());
            }
            this.pluginService.setCurrentConnection(failoverResult.getNewConnection(), writerHostSpec);
            LOGGER.fine(() -> Messages.get("Failover.establishedConnection", new Object[]{this.pluginService.getCurrentHostSpec()}));
            this.pluginService.refreshHostList();
            this.failoverWriterSuccessCounter.inc();
        }
        catch (FailoverSuccessSQLException ex) {
            telemetryContext.setSuccess(true);
            telemetryContext.setException(ex);
            this.failoverWriterSuccessCounter.inc();
            throw ex;
        }
        catch (Exception ex) {
            telemetryContext.setSuccess(false);
            telemetryContext.setException(ex);
            this.failoverWriterFailedCounter.inc();
            throw ex;
        }
        finally {
            telemetryContext.closeContext();
            if (this.telemetryFailoverAdditionalTopTraceSetting) {
                telemetryFactory.postCopy(telemetryContext, TelemetryTraceLevel.FORCE_TOP_LEVEL);
            }
        }
    }

    protected void invalidateCurrentConnection() {
        Connection conn = this.pluginService.getCurrentConnection();
        if (conn == null) {
            return;
        }
        if (this.pluginService.isInTransaction()) {
            this.isInTransaction = this.pluginService.isInTransaction();
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            if (!conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected synchronized void pickNewConnection() throws SQLException {
        if (this.isClosed && this.closedExplicitly) {
            LOGGER.fine(() -> Messages.get("Failover.transactionResolutionUnknownError"));
            return;
        }
        if (this.pluginService.getCurrentConnection() == null && !this.shouldAttemptReaderConnection()) {
            try {
                this.connectTo(this.getCurrentWriter());
            }
            catch (SQLException e) {
                this.failover(this.getCurrentWriter());
            }
        } else {
            this.failover(this.pluginService.getCurrentHostSpec());
        }
    }

    protected boolean shouldExceptionTriggerConnectionSwitch(Throwable t) {
        if (!this.isFailoverEnabled()) {
            LOGGER.fine(() -> Messages.get("Failover.failoverDisabled"));
            return false;
        }
        String sqlState = null;
        if (t instanceof SQLException) {
            sqlState = ((SQLException)t).getSQLState();
        }
        if (sqlState == null) {
            return false;
        }
        return this.pluginService.isNetworkException(t);
    }

    private boolean canDirectExecute(String methodName) {
        return methodName.equals(METHOD_CLOSE) || methodName.equals(METHOD_IS_CLOSED) || methodName.equals(METHOD_ABORT);
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        return this.connectInternal(driverProtocol, hostSpec, props, isInitialConnection, connectFunc);
    }

    private Connection connectInternal(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        Connection conn = this.staleDnsHelper.getVerifiedConnection(isInitialConnection, this.hostListProviderService, driverProtocol, hostSpec, props, connectFunc);
        if (this.keepSessionStateOnFailover) {
            this.savedReadOnlyStatus = this.savedReadOnlyStatus == null ? conn.isReadOnly() : this.savedReadOnlyStatus.booleanValue();
            this.savedAutoCommitStatus = this.savedAutoCommitStatus == null ? conn.getAutoCommit() : this.savedAutoCommitStatus.booleanValue();
        }
        if (isInitialConnection) {
            this.pluginService.refreshHostList(conn);
        }
        return conn;
    }

    @Override
    public Connection forceConnect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> forceConnectFunc) throws SQLException {
        return this.connectInternal(driverProtocol, hostSpec, props, isInitialConnection, forceConnectFunc);
    }

    static {
        FAILOVER_CLUSTER_TOPOLOGY_REFRESH_RATE_MS = new AwsWrapperProperty("failoverClusterTopologyRefreshRateMs", "2000", "Cluster topology refresh rate in millis during a writer failover process. During the writer failover process, cluster topology may be refreshed at a faster pace than normal to speed up discovery of the newly promoted writer.");
        FAILOVER_TIMEOUT_MS = new AwsWrapperProperty("failoverTimeoutMs", "300000", "Maximum allowed time for the failover process.");
        FAILOVER_WRITER_RECONNECT_INTERVAL_MS = new AwsWrapperProperty("failoverWriterReconnectIntervalMs", "2000", "Interval of time to wait between attempts to reconnect to a failed writer during a writer failover process.");
        FAILOVER_READER_CONNECT_TIMEOUT_MS = new AwsWrapperProperty("failoverReaderConnectTimeoutMs", "30000", "Reader connection attempt timeout during a reader failover process.");
        ENABLE_CLUSTER_AWARE_FAILOVER = new AwsWrapperProperty("enableClusterAwareFailover", "true", "Enable/disable cluster-aware failover logic");
        FAILOVER_MODE = new AwsWrapperProperty("failoverMode", null, "Set node role to follow during failover.");
        KEEP_SESSION_STATE_ON_FAILOVER = new AwsWrapperProperty("keepSessionStateOnFailover", "false", "Allow connections to retain a partial previous session state after failover occurs.");
        TELEMETRY_FAILOVER_ADDITIONAL_TOP_TRACE = new AwsWrapperProperty("telemetryFailoverAdditionalTopTrace", "false", "Post an additional top-level trace for failover process.");
        PropertyDefinition.registerPluginProperties(FailoverConnectionPlugin.class);
    }
}

