/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.efm.Monitor;
import software.amazon.jdbc.plugin.efm.MonitorConnectionContext;
import software.amazon.jdbc.plugin.efm.MonitorThreadContainer;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryGauge;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class MonitorImpl
implements Monitor {
    private static final Logger LOGGER = Logger.getLogger(MonitorImpl.class.getName());
    private static final long THREAD_SLEEP_WHEN_INACTIVE_MILLIS = 100L;
    private static final long MIN_CONNECTION_CHECK_TIMEOUT_MILLIS = 3000L;
    private static final String MONITORING_PROPERTY_PREFIX = "monitoring-";
    private final Queue<MonitorConnectionContext> activeContexts = new ConcurrentLinkedQueue<MonitorConnectionContext>();
    private final Queue<MonitorConnectionContext> newContexts = new ConcurrentLinkedQueue<MonitorConnectionContext>();
    private final PluginService pluginService;
    private final TelemetryFactory telemetryFactory;
    private final Properties properties;
    private final HostSpec hostSpec;
    private final MonitorThreadContainer threadContainer;
    private final long monitorDisposalTimeMillis;
    private volatile long contextLastUsedTimestampNano;
    private volatile boolean stopped = false;
    private Connection monitoringConn = null;
    private long nodeCheckTimeoutMillis = 3000L;
    private final TelemetryGauge contextsSizeGauge;
    private final TelemetryCounter nodeInvalidCounter;
    private TelemetryContext telemetryContext;

    public MonitorImpl(@NonNull PluginService pluginService, @NonNull HostSpec hostSpec, @NonNull Properties properties, long monitorDisposalTimeMillis, @NonNull MonitorThreadContainer threadContainer) {
        this.pluginService = pluginService;
        this.telemetryFactory = pluginService.getTelemetryFactory();
        this.hostSpec = hostSpec;
        this.properties = properties;
        this.monitorDisposalTimeMillis = monitorDisposalTimeMillis;
        this.threadContainer = threadContainer;
        this.contextLastUsedTimestampNano = this.getCurrentTimeNano();
        this.contextsSizeGauge = this.telemetryFactory.createGauge("efm.activeContexts.queue.size", () -> this.activeContexts.size());
        String nodeId = StringUtils.isNullOrEmpty(this.hostSpec.getHostId()) ? this.hostSpec.getHost() : this.hostSpec.getHostId();
        this.nodeInvalidCounter = this.telemetryFactory.createCounter(String.format("efm.nodeUnhealthy.count.%s", nodeId));
    }

    @Override
    public void startMonitoring(MonitorConnectionContext context) {
        if (this.stopped) {
            LOGGER.warning(() -> Messages.get("MonitorImpl.monitorIsStopped", new Object[]{this.hostSpec.getHost()}));
        }
        long currentTimeNano = this.getCurrentTimeNano();
        context.setStartMonitorTimeNano(currentTimeNano);
        this.contextLastUsedTimestampNano = currentTimeNano;
        this.newContexts.add(context);
    }

    @Override
    public void stopMonitoring(MonitorConnectionContext context) {
        if (context == null) {
            LOGGER.warning(() -> Messages.get("MonitorImpl.contextNullWarning"));
            return;
        }
        context.setInactive();
        this.contextLastUsedTimestampNano = this.getCurrentTimeNano();
    }

    @Override
    public void clearContexts() {
        this.newContexts.clear();
        this.activeContexts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block40: {
            this.telemetryContext = this.telemetryFactory.openTelemetryContext("monitoring thread", TelemetryTraceLevel.TOP_LEVEL);
            this.telemetryContext.setAttribute("url", this.hostSpec.getUrl());
            try {
                this.stopped = false;
                while (true) {
                    try {
                        while (true) {
                            MonitorConnectionContext newMonitorContext;
                            MonitorConnectionContext firstAddedNewMonitorContext = null;
                            long currentTimeNano = this.getCurrentTimeNano();
                            while ((newMonitorContext = this.newContexts.poll()) != null) {
                                if (firstAddedNewMonitorContext == newMonitorContext) {
                                    this.newContexts.add(newMonitorContext);
                                    break;
                                }
                                if (!newMonitorContext.isActiveContext()) continue;
                                if (newMonitorContext.getExpectedActiveMonitoringStartTimeNano() > currentTimeNano) {
                                    this.newContexts.add(newMonitorContext);
                                    if (firstAddedNewMonitorContext != null) continue;
                                    firstAddedNewMonitorContext = newMonitorContext;
                                    continue;
                                }
                                this.activeContexts.add(newMonitorContext);
                            }
                            if (!this.activeContexts.isEmpty()) {
                                MonitorConnectionContext monitorContext;
                                long statusCheckStartTimeNano;
                                this.contextLastUsedTimestampNano = statusCheckStartTimeNano = this.getCurrentTimeNano();
                                ConnectionStatus status = this.checkConnectionStatus(this.nodeCheckTimeoutMillis);
                                long delayMillis = -1L;
                                MonitorConnectionContext firstAddedMonitorContext = null;
                                while ((monitorContext = this.activeContexts.poll()) != null) {
                                    MonitorConnectionContext monitorConnectionContext = monitorContext;
                                    synchronized (monitorConnectionContext) {
                                        if (!monitorContext.isActiveContext()) {
                                            continue;
                                        }
                                        if (firstAddedMonitorContext == monitorContext) {
                                            this.activeContexts.add(monitorContext);
                                            break;
                                        }
                                        monitorContext.updateConnectionStatus(this.hostSpec.getUrl(), statusCheckStartTimeNano, statusCheckStartTimeNano + status.elapsedTimeNano, status.isValid);
                                        if (monitorContext.isActiveContext() && !monitorContext.isNodeUnhealthy()) {
                                            this.activeContexts.add(monitorContext);
                                            if (firstAddedMonitorContext == null) {
                                                firstAddedMonitorContext = monitorContext;
                                            }
                                            if (delayMillis == -1L || delayMillis > monitorContext.getFailureDetectionIntervalMillis()) {
                                                delayMillis = monitorContext.getFailureDetectionIntervalMillis();
                                            }
                                        }
                                    }
                                }
                                if (delayMillis == -1L) {
                                    delayMillis = 100L;
                                } else {
                                    if ((delayMillis -= status.elapsedTimeNano) <= 0L) {
                                        delayMillis = 3000L;
                                    }
                                    this.nodeCheckTimeoutMillis = delayMillis;
                                }
                                TimeUnit.MILLISECONDS.sleep(delayMillis);
                                continue;
                            }
                            if (this.getCurrentTimeNano() - this.contextLastUsedTimestampNano >= TimeUnit.MILLISECONDS.toNanos(this.monitorDisposalTimeMillis)) {
                                this.threadContainer.releaseResource(this);
                                break block40;
                            }
                            TimeUnit.MILLISECONDS.sleep(100L);
                        }
                    }
                    catch (InterruptedException intEx) {
                        throw intEx;
                    }
                    catch (Exception ex) {
                        if (!LOGGER.isLoggable(Level.FINEST)) continue;
                        LOGGER.log(Level.FINEST, Messages.get("MonitorImpl.exceptionDuringMonitoringContinue", new Object[]{this.hostSpec.getHost()}), ex);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException intEx) {
                LOGGER.warning(() -> Messages.get("MonitorImpl.interruptedExceptionDuringMonitoring", new Object[]{this.hostSpec.getHost()}));
            }
            catch (Exception ex) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, Messages.get("MonitorImpl.exceptionDuringMonitoringStop", new Object[]{this.hostSpec.getHost()}), ex);
                }
            }
            finally {
                this.stopped = true;
                if (this.monitoringConn != null) {
                    try {
                        this.monitoringConn.close();
                    }
                    catch (SQLException intEx) {}
                }
                if (this.telemetryContext != null) {
                    this.telemetryContext.closeContext();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionStatus checkConnectionStatus(long shortestFailureDetectionIntervalMillis) {
        TelemetryContext connectContext = this.telemetryFactory.openTelemetryContext("connection status check", TelemetryTraceLevel.NESTED);
        long startNano = this.getCurrentTimeNano();
        try {
            if (this.monitoringConn == null || this.monitoringConn.isClosed()) {
                Properties monitoringConnProperties = PropertyUtils.copyProperties(this.properties);
                this.properties.stringPropertyNames().stream().filter(p -> p.startsWith(MONITORING_PROPERTY_PREFIX)).forEach(p -> {
                    monitoringConnProperties.put(p.substring(MONITORING_PROPERTY_PREFIX.length()), this.properties.getProperty((String)p));
                    monitoringConnProperties.remove(p);
                });
                LOGGER.finest(() -> "Opening a monitoring connection to " + this.hostSpec.getUrl());
                startNano = this.getCurrentTimeNano();
                this.monitoringConn = this.pluginService.forceConnect(this.hostSpec, monitoringConnProperties);
                LOGGER.finest(() -> "Opened monitoring connection: " + this.monitoringConn);
                ConnectionStatus connectionStatus = new ConnectionStatus(true, this.getCurrentTimeNano() - startNano);
                return connectionStatus;
            }
            startNano = this.getCurrentTimeNano();
            boolean isValid = this.monitoringConn.isValid((int)TimeUnit.MILLISECONDS.toSeconds(shortestFailureDetectionIntervalMillis));
            if (!isValid) {
                this.nodeInvalidCounter.inc();
            }
            ConnectionStatus connectionStatus = new ConnectionStatus(isValid, this.getCurrentTimeNano() - startNano);
            return connectionStatus;
        }
        catch (SQLException sqlEx) {
            this.nodeInvalidCounter.inc();
            ConnectionStatus connectionStatus = new ConnectionStatus(false, this.getCurrentTimeNano() - startNano);
            return connectionStatus;
        }
        finally {
            connectContext.closeContext();
        }
    }

    long getCurrentTimeNano() {
        return System.nanoTime();
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    static class ConnectionStatus {
        boolean isValid;
        long elapsedTimeNano;

        ConnectionStatus(boolean isValid, long elapsedTimeNano) {
            this.isValid = isValid;
            this.elapsedTimeNano = elapsedTimeNano;
        }
    }
}

