/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.hostavailability.HostAvailabilityStrategy;

public class HostSpec {
    public static final int NO_PORT = -1;
    public static final long DEFAULT_WEIGHT = 100L;
    protected final String host;
    protected final int port;
    protected volatile HostAvailability availability;
    protected HostRole role;
    protected Set<String> aliases = ConcurrentHashMap.newKeySet();
    protected Set<String> allAliases = ConcurrentHashMap.newKeySet();
    protected long weight;
    protected String hostId;
    protected Timestamp lastUpdateTime;
    protected HostAvailabilityStrategy hostAvailabilityStrategy;

    private HostSpec(String host, int port, String hostId, HostRole role, HostAvailability availability, HostAvailabilityStrategy hostAvailabilityStrategy) {
        this(host, port, hostId, role, availability, 100L, Timestamp.from(Instant.now()), hostAvailabilityStrategy);
    }

    HostSpec(String host, int port, String hostId, HostRole role, HostAvailability availability, long weight, Timestamp lastUpdateTime, HostAvailabilityStrategy hostAvailabilityStrategy) {
        this.host = host;
        this.port = port;
        this.hostId = hostId;
        this.availability = availability;
        this.role = role;
        this.allAliases.add(this.asAlias());
        this.weight = weight;
        this.lastUpdateTime = lastUpdateTime;
        this.hostAvailabilityStrategy = hostAvailabilityStrategy;
    }

    public HostSpec(HostSpec copyHost, HostRole role) {
        this(copyHost.getHost(), copyHost.getPort(), copyHost.getHostId(), role, copyHost.getAvailability(), copyHost.getHostAvailabilityStrategy());
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isPortSpecified() {
        return this.port != -1;
    }

    public HostRole getRole() {
        return this.role;
    }

    public HostAvailability getAvailability() {
        if (this.hostAvailabilityStrategy != null) {
            return this.hostAvailabilityStrategy.getHostAvailability(this.availability);
        }
        return this.availability;
    }

    public HostAvailability getRawAvailability() {
        return this.availability;
    }

    public void setAvailability(HostAvailability availability) {
        this.availability = availability;
        if (this.hostAvailabilityStrategy != null) {
            this.hostAvailabilityStrategy.setHostAvailability(availability);
        }
    }

    public HostAvailabilityStrategy getHostAvailabilityStrategy() {
        return this.hostAvailabilityStrategy;
    }

    public void setHostAvailabilityStrategy(HostAvailabilityStrategy hostAvailabilityStrategy) {
        this.hostAvailabilityStrategy = hostAvailabilityStrategy;
    }

    public Timestamp getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Set<String> getAliases() {
        return Collections.unmodifiableSet(this.aliases);
    }

    public long getWeight() {
        return this.weight;
    }

    public void addAlias(String ... alias) {
        if (alias == null || alias.length < 1) {
            return;
        }
        Arrays.asList(alias).forEach(x -> {
            this.aliases.add((String)x);
            this.allAliases.add((String)x);
        });
    }

    public void removeAlias(String ... alias) {
        if (alias == null || alias.length < 1) {
            return;
        }
        Arrays.asList(alias).forEach(x -> {
            this.aliases.remove(x);
            this.allAliases.remove(x);
        });
    }

    public void resetAliases() {
        this.aliases.clear();
        this.allAliases.clear();
        this.allAliases.add(this.asAlias());
    }

    public String getUrl() {
        String url;
        String string = url = this.isPortSpecified() ? this.host + ":" + this.port : this.host;
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public String asAlias() {
        return this.isPortSpecified() ? this.host + ":" + this.port : this.host;
    }

    public Set<String> asAliases() {
        return Collections.unmodifiableSet(this.allAliases);
    }

    public String toString() {
        return String.format("HostSpec[host=%s, port=%d, %s, %s, weight=%d, %s]", new Object[]{this.host, this.port, this.role, this.availability, this.weight, this.lastUpdateTime});
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.port, this.availability, this.role, this.weight, this.lastUpdateTime});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HostSpec)) {
            return false;
        }
        HostSpec spec = (HostSpec)obj;
        return Objects.equals(this.host, spec.host) && this.port == spec.port && this.availability == spec.availability && this.role == spec.role && this.weight == spec.weight;
    }
}

