/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.AwsWrapperProperty;

public class PropertyDefinition {
    public static final AwsWrapperProperty LOG_UNCLOSED_CONNECTIONS = new AwsWrapperProperty("wrapperLogUnclosedConnections", "false", "Allows the driver to track a point in the code where connection has been opened and never closed after");
    public static final AwsWrapperProperty LOGGER_LEVEL = new AwsWrapperProperty("wrapperLoggerLevel", null, "Logger level of the driver", false, new String[]{"OFF", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST", "ALL"});
    public static final AwsWrapperProperty PLUGINS = new AwsWrapperProperty("wrapperPlugins", null, "Comma separated list of connection plugin codes");
    public static final AwsWrapperProperty AUTO_SORT_PLUGIN_ORDER = new AwsWrapperProperty("autoSortWrapperPluginOrder", "true", "This flag is enabled by default, meaning that the plugins order will be automatically adjusted. Disable it at your own risk or if you really need plugins to be executed in a particular order.");
    public static final AwsWrapperProperty PROFILE_NAME = new AwsWrapperProperty("wrapperProfileName", null, "Driver configuration profile name");
    public static final AwsWrapperProperty USER = new AwsWrapperProperty("user", null, "Driver user name");
    public static final AwsWrapperProperty PASSWORD = new AwsWrapperProperty("password", null, "Driver password");
    public static final AwsWrapperProperty DATABASE = new AwsWrapperProperty("database", null, "Driver database name");
    public static final AwsWrapperProperty ENABLE_TELEMETRY = new AwsWrapperProperty("enableTelemetry", "false", "Enables telemetry and observability of the driver");
    public static final AwsWrapperProperty TELEMETRY_SUBMIT_TOPLEVEL = new AwsWrapperProperty("telemetrySubmitToplevel", "false", "Force submitting traces related to JDBC calls as top level traces.");
    public static final AwsWrapperProperty TELEMETRY_TRACES_BACKEND = new AwsWrapperProperty("telemetryTracesBackend", null, "Method to export telemetry traces of the driver", false, new String[]{"XRAY", "OTLP", "NONE"});
    public static final AwsWrapperProperty TELEMETRY_METRICS_BACKEND = new AwsWrapperProperty("telemetryMetricsBackend", null, "Method to export telemetry metrics of the driver", false, new String[]{"OTLP", "NONE"});
    private static final Map<String, AwsWrapperProperty> PROPS_BY_NAME = new ConcurrentHashMap<String, AwsWrapperProperty>();
    private static final Set<String> KNOWN_PROPS_BY_PREFIX = ConcurrentHashMap.newKeySet();

    public static @Nullable AwsWrapperProperty byName(String name) {
        return PROPS_BY_NAME.get(name);
    }

    public static Collection<AwsWrapperProperty> allProperties() {
        return PROPS_BY_NAME.values();
    }

    public static void registerPluginProperties(Class<?> pluginClass) {
        PropertyDefinition.registerProperties(pluginClass);
    }

    public static void registerPluginProperties(@NonNull String propertyNamePrefix) {
        KNOWN_PROPS_BY_PREFIX.add(propertyNamePrefix);
    }

    public static void removeAll(Properties props) {
        PROPS_BY_NAME.keySet().forEach(props::remove);
        props.stringPropertyNames().stream().filter(propertyName -> KNOWN_PROPS_BY_PREFIX.stream().anyMatch(propertyName::startsWith)).forEach(props::remove);
    }

    public static void removeAllExcept(Properties props, String ... propNames) {
        HashSet<String> propsToDelete = new HashSet<String>(PROPS_BY_NAME.keySet());
        Arrays.asList(propNames).forEach(propsToDelete::remove);
        propsToDelete.forEach(props::remove);
        props.stringPropertyNames().stream().filter(propertyName -> KNOWN_PROPS_BY_PREFIX.stream().anyMatch(propertyName::startsWith)).forEach(props::remove);
    }

    public static void removeAllExceptCredentials(Properties props) {
        String user = props.getProperty(PropertyDefinition.USER.name, null);
        String password = props.getProperty(PropertyDefinition.PASSWORD.name, null);
        PropertyDefinition.removeAll(props);
        if (user != null) {
            props.setProperty(PropertyDefinition.USER.name, user);
        }
        if (password != null) {
            props.setProperty(PropertyDefinition.PASSWORD.name, password);
        }
    }

    private static void registerProperties(Class<?> ownerClass) {
        Arrays.stream(ownerClass.getDeclaredFields()).filter(f -> f.getType() == AwsWrapperProperty.class && Modifier.isPublic(f.getModifiers()) && Modifier.isStatic(f.getModifiers())).forEach(f -> {
            AwsWrapperProperty prop = null;
            try {
                prop = (AwsWrapperProperty)f.get(AwsWrapperProperty.class);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
            if (prop != null) {
                PROPS_BY_NAME.put(prop.name, prop);
            }
        });
    }

    static {
        PropertyDefinition.registerProperties(PropertyDefinition.class);
    }
}

