/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSelector;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.RandomHostSelector;
import software.amazon.jdbc.RoundRobinHostSelector;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.exceptions.SQLLoginException;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.SqlState;
import software.amazon.jdbc.util.WrapperUtils;

public class DataSourceConnectionProvider
implements ConnectionProvider {
    private static final Logger LOGGER = Logger.getLogger(DataSourceConnectionProvider.class.getName());
    private static final Map<String, HostSelector> acceptedStrategies = Collections.unmodifiableMap(new HashMap<String, HostSelector>(){
        {
            this.put("random", new RandomHostSelector());
            this.put("roundRobin", new RoundRobinHostSelector());
        }
    });
    private final @NonNull DataSource dataSource;
    private final @NonNull String dataSourceClassName;
    private final @NonNull TargetDriverDialect targetDriverDialect;
    private final ReentrantLock lock = new ReentrantLock();

    public DataSourceConnectionProvider(@NonNull DataSource dataSource, @NonNull TargetDriverDialect targetDriverDialect) {
        this.dataSource = dataSource;
        this.targetDriverDialect = targetDriverDialect;
        this.dataSourceClassName = dataSource.getClass().getName();
    }

    @Override
    public boolean acceptsUrl(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) {
        return true;
    }

    @Override
    public boolean acceptsStrategy(@NonNull HostRole role, @NonNull String strategy) {
        return acceptedStrategies.containsKey(strategy);
    }

    @Override
    public HostSpec getHostSpecByStrategy(@NonNull List<HostSpec> hosts, @NonNull HostRole role, @NonNull String strategy, @Nullable Properties props) throws SQLException {
        if (!acceptedStrategies.containsKey(strategy)) {
            throw new UnsupportedOperationException(Messages.get("ConnectionProvider.unsupportedHostSpecSelectorStrategy", new Object[]{strategy, DataSourceConnectionProvider.class}));
        }
        return acceptedStrategies.get(strategy).getHost(hosts, role, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(@NonNull String protocol, @NonNull Dialect dialect, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        Connection conn;
        Properties copy = PropertyUtils.copyProperties(props);
        dialect.prepareConnectProperties(copy, protocol, hostSpec);
        if (this.lock.isLocked()) {
            LOGGER.finest(() -> "Use a separate DataSource object to create a connection.");
            DataSource ds = this.createDataSource();
            this.targetDriverDialect.prepareDataSource(ds, protocol, hostSpec, copy);
            conn = ds.getConnection();
        } else {
            this.lock.lock();
            LOGGER.finest(() -> "Use main DataSource object to create a connection.");
            try {
                this.targetDriverDialect.prepareDataSource(this.dataSource, protocol, hostSpec, copy);
                conn = this.dataSource.getConnection();
            }
            finally {
                this.lock.unlock();
            }
        }
        if (conn == null) {
            throw new SQLLoginException(Messages.get("ConnectionProvider.noConnection"));
        }
        return conn;
    }

    @Override
    @Deprecated
    public Connection connect(@NonNull String url, @NonNull Properties props) throws SQLException {
        Properties copy = PropertyUtils.copyProperties(props);
        copy.setProperty("url", url);
        PropertyDefinition.removeAllExceptCredentials(copy);
        PropertyUtils.applyProperties(this.dataSource, copy);
        return this.dataSource.getConnection();
    }

    private DataSource createDataSource() throws SQLException {
        try {
            return WrapperUtils.createInstance(this.dataSource.getClass(), DataSource.class, null, new Object[0]);
        }
        catch (InstantiationException instEx) {
            throw new SQLException(instEx.getMessage(), SqlState.UNKNOWN_STATE.getState(), instEx);
        }
    }

    @Override
    public String getTargetName() {
        return this.dataSourceClassName;
    }
}

