/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import software.amazon.jdbc.dialect.PgDialect;

public class RdsPgDialect
extends PgDialect {
    private static final Logger LOGGER = Logger.getLogger(RdsPgDialect.class.getName());
    private static final List<String> dialectUpdateCandidates = Collections.singletonList("aurora-pg");
    private static final String extensionsSql = "SELECT (setting LIKE '%rds_tools%') AS rds_tools, (setting LIKE '%aurora_stat_utils%') AS aurora_stat_utils FROM pg_settings WHERE name='rds.extensions'";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDialect(Connection connection) {
        if (!super.isDialect(connection)) {
            return false;
        }
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(extensionsSql);){
            boolean auroraUtils;
            boolean rdsTools;
            do {
                if (!rs.next()) return false;
                rdsTools = rs.getBoolean("rds_tools");
                auroraUtils = rs.getBoolean("aurora_stat_utils");
                LOGGER.finest(() -> String.format("rdsTools: %b, auroraUtils: %b", rdsTools, auroraUtils));
            } while (!rdsTools || auroraUtils);
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public List<String> getDialectUpdateCandidates() {
        return dialectUpdateCandidates;
    }
}

