/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.SQLException;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSelector;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.util.Messages;

public class RandomHostSelector
implements HostSelector {
    @Override
    public HostSpec getHost(List<HostSpec> hosts, HostRole role) throws SQLException {
        List eligibleHosts = hosts.stream().filter(hostSpec -> role.equals((Object)hostSpec.getRole())).collect(Collectors.toList());
        if (eligibleHosts.size() == 0) {
            throw new SQLException(Messages.get("RandomHostSelector.noHostsMatchingRole", new Object[]{role}));
        }
        int randomIndex = new Random().nextInt(eligibleHosts.size());
        return (HostSpec)eligibleHosts.get(randomIndex);
    }
}

