/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSelector;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.RandomHostSelector;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;

public class DriverConnectionProvider
implements ConnectionProvider {
    private static final Logger LOGGER = Logger.getLogger(DriverConnectionProvider.class.getName());
    private static final Map<String, HostSelector> acceptedStrategies = Collections.unmodifiableMap(new HashMap<String, HostSelector>(){
        {
            this.put("random", new RandomHostSelector());
        }
    });
    private final Driver driver;

    public DriverConnectionProvider(Driver driver) {
        this.driver = driver;
    }

    @Override
    public boolean acceptsUrl(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) {
        return true;
    }

    @Override
    public boolean acceptsStrategy(@NonNull HostRole role, @NonNull String strategy) {
        return acceptedStrategies.containsKey(strategy);
    }

    @Override
    public HostSpec getHostSpecByStrategy(@NonNull List<HostSpec> hosts, @NonNull HostRole role, @NonNull String strategy) throws SQLException {
        if (!acceptedStrategies.containsKey(strategy)) {
            throw new UnsupportedOperationException(Messages.get("ConnectionProvider.unsupportedHostSpecSelectorStrategy", new Object[]{strategy, DriverConnectionProvider.class}));
        }
        return acceptedStrategies.get(strategy).getHost(hosts, role);
    }

    @Override
    public Connection connect(@NonNull String protocol, @NonNull Dialect dialect, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        String databaseName = PropertyDefinition.DATABASE.getString(props) != null ? PropertyDefinition.DATABASE.getString(props) : "";
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(protocol).append(hostSpec.getUrl()).append(databaseName);
        Set<String> propertiesToUrl = dialect.appendPropertiesToUrl();
        if (propertiesToUrl != null) {
            boolean isFirstParameter = true;
            for (String propertyName : propertiesToUrl) {
                if (!props.stringPropertyNames().contains(propertyName)) continue;
                if (isFirstParameter) {
                    urlBuilder.append("?").append(propertyName);
                    isFirstParameter = false;
                    continue;
                }
                urlBuilder.append("&").append(propertyName);
            }
        }
        LOGGER.finest(() -> "Connecting to " + urlBuilder);
        LOGGER.finest(() -> PropertyUtils.logProperties(props, "Connecting with properties: \n"));
        return this.driver.connect(urlBuilder.toString(), props);
    }

    @Override
    public Connection connect(@NonNull String url, @NonNull Properties props) throws SQLException {
        LOGGER.finest(() -> "Connecting to " + url);
        return this.driver.connect(url, props);
    }
}

