/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.jdbc.util.StringUtils;

public class SqlMethodAnalyzer {
    public boolean doesOpenTransaction(Connection conn, String methodName, Object[] args) {
        boolean autocommit;
        if (!methodName.contains("execute") || args == null || args.length < 1) {
            return false;
        }
        String statement = this.getFirstSqlStatement(String.valueOf(args[0]));
        if (this.isStatementStartingTransaction(statement)) {
            return true;
        }
        try {
            autocommit = conn.getAutoCommit();
        }
        catch (SQLException e) {
            return false;
        }
        return !autocommit && this.isStatementDml(statement);
    }

    private String getFirstSqlStatement(String sql) {
        String statement = this.parseMultiStatementQueries(sql).get(0);
        statement = statement.toUpperCase();
        statement = statement.replaceAll("\\s*/\\*(.*?)\\*/\\s*", " ").trim();
        return statement;
    }

    private List<String> parseMultiStatementQueries(String query) {
        if (StringUtils.isNullOrEmpty(query)) {
            return new ArrayList<String>();
        }
        if ((query = query.replaceAll("\\s+", " ")).trim().isEmpty()) {
            return new ArrayList<String>();
        }
        return Arrays.stream(query.split(";")).collect(Collectors.toList());
    }

    public boolean doesCloseTransaction(Connection conn, String methodName, Object[] args) {
        if (methodName.equals("Connection.commit") || methodName.equals("Connection.rollback") || methodName.equals("Connection.close") || methodName.equals("Connection.abort")) {
            return true;
        }
        if (this.doesSwitchAutoCommitFalseTrue(conn, methodName, args)) {
            return true;
        }
        if (!methodName.contains("execute") || args == null || args.length < 1) {
            return false;
        }
        String statement = this.getFirstSqlStatement(String.valueOf(args[0]));
        return this.isStatementClosingTransaction(statement);
    }

    public boolean isExecuteDml(String methodName, Object[] args) {
        if (!methodName.contains("execute") || args == null || args.length < 1) {
            return false;
        }
        String statement = this.getFirstSqlStatement(String.valueOf(args[0]));
        return this.isStatementDml(statement);
    }

    public boolean isStatementDml(String statement) {
        return !this.isStatementStartingTransaction(statement) && !this.isStatementClosingTransaction(statement) && !statement.startsWith("SET ") && !statement.startsWith("USE ") && !statement.startsWith("SHOW ");
    }

    public boolean isStatementStartingTransaction(String statement) {
        return statement.startsWith("BEGIN") || statement.startsWith("START TRANSACTION");
    }

    public boolean isStatementClosingTransaction(String statement) {
        return statement.startsWith("COMMIT") || statement.startsWith("ROLLBACK") || statement.startsWith("END") || statement.startsWith("ABORT");
    }

    public boolean isStatementSettingAutoCommit(String methodName, Object[] args) {
        if (!methodName.contains("execute") || args == null || args.length < 1) {
            return false;
        }
        String statement = this.getFirstSqlStatement(String.valueOf(args[0]));
        return statement.startsWith("SET AUTOCOMMIT");
    }

    public boolean doesSwitchAutoCommitFalseTrue(Connection conn, String methodName, Object[] jdbcMethodArgs) {
        boolean oldAutoCommitVal;
        boolean isStatementSettingAutoCommit = this.isStatementSettingAutoCommit(methodName, jdbcMethodArgs);
        if (!methodName.contains("setAutoCommit") && !isStatementSettingAutoCommit) {
            return false;
        }
        Boolean newAutoCommitVal = null;
        try {
            oldAutoCommitVal = conn.getAutoCommit();
        }
        catch (SQLException e) {
            return false;
        }
        if (methodName.contains("setAutoCommit") && jdbcMethodArgs.length > 0) {
            newAutoCommitVal = (Boolean)jdbcMethodArgs[0];
        } else if (isStatementSettingAutoCommit) {
            newAutoCommitVal = this.getAutoCommitValueFromSqlStatement(jdbcMethodArgs);
        }
        return !oldAutoCommitVal && Boolean.TRUE.equals(newAutoCommitVal);
    }

    public Boolean getAutoCommitValueFromSqlStatement(Object[] args) {
        int valueIndex;
        if (args == null || args.length < 1) {
            return null;
        }
        String sql = this.getFirstSqlStatement(String.valueOf(args[0]));
        int separatorIndex = sql.indexOf("=");
        if (separatorIndex != -1) {
            valueIndex = separatorIndex + 1;
        } else {
            separatorIndex = sql.indexOf(" TO ");
            if (separatorIndex == -1) {
                return null;
            }
            valueIndex = separatorIndex + 3;
        }
        sql = sql.substring(valueIndex);
        if (sql.contains(";")) {
            sql = sql.substring(0, sql.indexOf(";"));
        }
        if ("FALSE".equals(sql = sql.trim()) || "0".equals(sql) || "OFF".equals(sql)) {
            return false;
        }
        if ("TRUE".equals(sql) || "1".equals(sql) || "ON".equals(sql)) {
            return true;
        }
        return null;
    }

    public boolean isMethodClosingSqlObject(String methodName) {
        return methodName.endsWith(".close") || methodName.endsWith(".abort");
    }
}

