/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.efm.Monitor;
import software.amazon.jdbc.plugin.efm.MonitorConnectionContext;
import software.amazon.jdbc.plugin.efm.MonitorService;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;

public class MonitorImpl
implements Monitor {
    static final long DEFAULT_CONNECTION_CHECK_INTERVAL_MILLIS = 100L;
    static final long DEFAULT_CONNECTION_CHECK_TIMEOUT_MILLIS = 3000L;
    private static final Logger LOGGER = Logger.getLogger(MonitorImpl.class.getName());
    private static final long THREAD_SLEEP_WHEN_INACTIVE_MILLIS = 100L;
    private static final String MONITORING_PROPERTY_PREFIX = "monitoring-";
    private final long monitorDisposalTimeMillis;
    private final Queue<MonitorConnectionContext> contexts = new ConcurrentLinkedQueue<MonitorConnectionContext>();
    private final PluginService pluginService;
    private final Properties properties;
    private final HostSpec hostSpec;
    private final AtomicLong contextLastUsedTimestampNano = new AtomicLong();
    private final MonitorService monitorService;
    private final AtomicBoolean stopped = new AtomicBoolean(true);
    private final AtomicLong connectionCheckIntervalMillis = new AtomicLong(100L);
    private final AtomicBoolean isConnectionCheckIntervalInitialized = new AtomicBoolean(false);
    private Connection monitoringConn = null;

    public MonitorImpl(@NonNull PluginService pluginService, @NonNull HostSpec hostSpec, @NonNull Properties properties, long monitorDisposalTimeMillis, @NonNull MonitorService monitorService) {
        this.pluginService = pluginService;
        this.hostSpec = hostSpec;
        this.properties = properties;
        this.monitorDisposalTimeMillis = monitorDisposalTimeMillis;
        this.monitorService = monitorService;
        this.contextLastUsedTimestampNano.set(this.getCurrentTimeNano());
    }

    @Override
    public void startMonitoring(MonitorConnectionContext context) {
        if (!this.isConnectionCheckIntervalInitialized.get()) {
            this.connectionCheckIntervalMillis.set(context.getFailureDetectionIntervalMillis());
            this.isConnectionCheckIntervalInitialized.set(true);
        } else {
            this.connectionCheckIntervalMillis.set(Math.min(this.connectionCheckIntervalMillis.get(), context.getFailureDetectionIntervalMillis()));
        }
        long currentTimeNano = this.getCurrentTimeNano();
        context.setStartMonitorTimeNano(currentTimeNano);
        this.contextLastUsedTimestampNano.set(currentTimeNano);
        this.contexts.add(context);
    }

    @Override
    public void stopMonitoring(MonitorConnectionContext context) {
        if (context == null) {
            LOGGER.warning(() -> Messages.get("MonitorImpl.contextNullWarning"));
            return;
        }
        context.invalidate();
        this.contexts.remove(context);
        this.connectionCheckIntervalMillis.set(this.findShortestIntervalMillis());
        this.isConnectionCheckIntervalInitialized.set(true);
    }

    @Override
    public void clearContexts() {
        this.contexts.clear();
        this.connectionCheckIntervalMillis.set(this.findShortestIntervalMillis());
        this.isConnectionCheckIntervalInitialized.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.stopped.set(false);
            while (true) {
                if (!this.contexts.isEmpty()) {
                    long statusCheckStartTimeNano = this.getCurrentTimeNano();
                    this.contextLastUsedTimestampNano.set(statusCheckStartTimeNano);
                    ConnectionStatus status = this.checkConnectionStatus(this.getConnectionCheckTimeoutMillis());
                    for (MonitorConnectionContext monitorContext : this.contexts) {
                        monitorContext.updateConnectionStatus(statusCheckStartTimeNano, statusCheckStartTimeNano + status.elapsedTimeNano, status.isValid);
                    }
                    TimeUnit.MILLISECONDS.sleep(Math.max(0L, this.getConnectionCheckIntervalMillis() - TimeUnit.NANOSECONDS.toMillis(status.elapsedTimeNano)));
                    continue;
                }
                if (this.getCurrentTimeNano() - this.contextLastUsedTimestampNano.get() >= TimeUnit.MILLISECONDS.toNanos(this.monitorDisposalTimeMillis)) {
                    this.monitorService.notifyUnused(this);
                    break;
                }
                TimeUnit.MILLISECONDS.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (this.monitoringConn != null) {
                try {
                    this.monitoringConn.close();
                }
                catch (SQLException sQLException) {}
            }
            this.stopped.set(true);
        }
    }

    ConnectionStatus checkConnectionStatus(long shortestFailureDetectionIntervalMillis) {
        long startNano = this.getCurrentTimeNano();
        try {
            if (this.monitoringConn == null || this.monitoringConn.isClosed()) {
                Properties monitoringConnProperties = PropertyUtils.copyProperties(this.properties);
                this.properties.stringPropertyNames().stream().filter(p -> p.startsWith(MONITORING_PROPERTY_PREFIX)).forEach(p -> {
                    monitoringConnProperties.put(p.substring(MONITORING_PROPERTY_PREFIX.length()), this.properties.getProperty((String)p));
                    monitoringConnProperties.remove(p);
                });
                startNano = this.getCurrentTimeNano();
                this.monitoringConn = this.pluginService.connect(this.hostSpec, monitoringConnProperties);
                return new ConnectionStatus(true, this.getCurrentTimeNano() - startNano);
            }
            startNano = this.getCurrentTimeNano();
            boolean isValid = this.monitoringConn.isValid((int)TimeUnit.MILLISECONDS.toSeconds(shortestFailureDetectionIntervalMillis));
            return new ConnectionStatus(isValid, this.getCurrentTimeNano() - startNano);
        }
        catch (SQLException sqlEx) {
            return new ConnectionStatus(false, this.getCurrentTimeNano() - startNano);
        }
    }

    long getCurrentTimeNano() {
        return System.nanoTime();
    }

    long getConnectionCheckTimeoutMillis() {
        return this.connectionCheckIntervalMillis.get() == 0L ? 3000L : this.connectionCheckIntervalMillis.get();
    }

    long getConnectionCheckIntervalMillis() {
        return this.connectionCheckIntervalMillis.get() == 0L ? 100L : this.connectionCheckIntervalMillis.get();
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }

    private long findShortestIntervalMillis() {
        long currentMin = Long.MAX_VALUE;
        for (MonitorConnectionContext context : this.contexts) {
            currentMin = Math.min(currentMin, context.getFailureDetectionIntervalMillis());
        }
        return currentMin == Long.MAX_VALUE ? 100L : currentMin;
    }

    static class ConnectionStatus {
        boolean isValid;
        long elapsedTimeNano;

        ConnectionStatus(boolean isValid, long elapsedTimeNano) {
            this.isValid = isValid;
            this.elapsedTimeNano = elapsedTimeNano;
        }
    }
}

