/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import software.amazon.jdbc.util.Messages;

public class MonitorConnectionContext {
    private static final Logger LOGGER = Logger.getLogger(MonitorConnectionContext.class.getName());
    private final long failureDetectionIntervalMillis;
    private final long failureDetectionTimeMillis;
    private final long failureDetectionCount;
    private final Set<String> hostAliases;
    private final Connection connectionToAbort;
    private final AtomicBoolean activeContext = new AtomicBoolean(true);
    private final AtomicBoolean nodeUnhealthy = new AtomicBoolean();
    private final AtomicLong startMonitorTimeNano = new AtomicLong();
    private long invalidNodeStartTimeNano;
    private long failureCount;

    public MonitorConnectionContext(Connection connectionToAbort, Set<String> hostAliases, long failureDetectionTimeMillis, long failureDetectionIntervalMillis, long failureDetectionCount) {
        this.connectionToAbort = connectionToAbort;
        this.hostAliases = new HashSet<String>(hostAliases);
        this.failureDetectionTimeMillis = failureDetectionTimeMillis;
        this.failureDetectionIntervalMillis = failureDetectionIntervalMillis;
        this.failureDetectionCount = failureDetectionCount;
    }

    void setStartMonitorTimeNano(long startMonitorTimeNano) {
        this.startMonitorTimeNano.set(startMonitorTimeNano);
    }

    Set<String> getHostAliases() {
        return Collections.unmodifiableSet(this.hostAliases);
    }

    public long getFailureDetectionTimeMillis() {
        return this.failureDetectionTimeMillis;
    }

    public long getFailureDetectionIntervalMillis() {
        return this.failureDetectionIntervalMillis;
    }

    public long getFailureDetectionCount() {
        return this.failureDetectionCount;
    }

    public long getFailureCount() {
        return this.failureCount;
    }

    void setFailureCount(long failureCount) {
        this.failureCount = failureCount;
    }

    void setInvalidNodeStartTimeNano(long invalidNodeStartTimeNano) {
        this.invalidNodeStartTimeNano = invalidNodeStartTimeNano;
    }

    void resetInvalidNodeStartTime() {
        this.invalidNodeStartTimeNano = 0L;
    }

    boolean isInvalidNodeStartTimeDefined() {
        return this.invalidNodeStartTimeNano > 0L;
    }

    public long getInvalidNodeStartTimeNano() {
        return this.invalidNodeStartTimeNano;
    }

    public boolean isNodeUnhealthy() {
        return this.nodeUnhealthy.get();
    }

    void setNodeUnhealthy(boolean nodeUnhealthy) {
        this.nodeUnhealthy.set(nodeUnhealthy);
    }

    public boolean isActiveContext() {
        return this.activeContext.get();
    }

    public void invalidate() {
        this.activeContext.set(false);
    }

    synchronized void abortConnection() {
        if (this.connectionToAbort == null || !this.activeContext.get()) {
            return;
        }
        try {
            this.connectionToAbort.close();
        }
        catch (SQLException sqlEx) {
            LOGGER.finest(() -> Messages.get("MonitorConnectionContext.exceptionAbortingConnection", new Object[]{sqlEx.getMessage()}));
        }
    }

    public void updateConnectionStatus(long statusCheckStartTimeNano, long statusCheckEndTimeNano, boolean isValid) {
        if (!this.activeContext.get()) {
            return;
        }
        long totalElapsedTimeNano = statusCheckEndTimeNano - this.startMonitorTimeNano.get();
        if (totalElapsedTimeNano > TimeUnit.MILLISECONDS.toNanos(this.failureDetectionTimeMillis)) {
            this.setConnectionValid(isValid, statusCheckStartTimeNano, statusCheckEndTimeNano);
        }
    }

    void setConnectionValid(boolean connectionValid, long statusCheckStartNano, long statusCheckEndNano) {
        if (!connectionValid) {
            long maxInvalidNodeDurationMillis;
            long invalidNodeDurationNano;
            ++this.failureCount;
            if (!this.isInvalidNodeStartTimeDefined()) {
                this.setInvalidNodeStartTimeNano(statusCheckStartNano);
            }
            if ((invalidNodeDurationNano = statusCheckEndNano - this.getInvalidNodeStartTimeNano()) >= TimeUnit.MILLISECONDS.toNanos(maxInvalidNodeDurationMillis = this.getFailureDetectionIntervalMillis() * Math.max(0L, this.getFailureDetectionCount()))) {
                LOGGER.fine(() -> Messages.get("MonitorConnectionContext.hostDead", new Object[]{this.hostAliases}));
                this.setNodeUnhealthy(true);
                this.abortConnection();
                return;
            }
            LOGGER.finest(() -> Messages.get("MonitorConnectionContext.hostNotResponding", new Object[]{this.hostAliases, this.getFailureCount()}));
            return;
        }
        this.setFailureCount(0L);
        this.resetInvalidNodeStartTime();
        this.setNodeUnhealthy(false);
        LOGGER.finest(() -> Messages.get("MonitorConnectionContext.hostAlive", new Object[]{this.hostAliases}));
    }
}

