/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;
import software.amazon.awssdk.utils.Pair;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.StringUtils;

public class AwsSecretsManagerConnectionPlugin
extends AbstractConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(AwsSecretsManagerConnectionPlugin.class.getName());
    protected static final AwsWrapperProperty SECRET_ID_PROPERTY = new AwsWrapperProperty("secretsManagerSecretId", null, "The name or the ARN of the secret to retrieve.");
    protected static final AwsWrapperProperty REGION_PROPERTY = new AwsWrapperProperty("secretsManagerRegion", "us-east-1", "The region of the secret to retrieve.");
    static final List<String> SQLSTATE_ACCESS_ERROR = Arrays.asList("28000", "28P01");
    protected static final Map<Pair<String, Region>, Secret> SECRET_CACHE = new ConcurrentHashMap<Pair<String, Region>, Secret>();
    private final SecretsManagerClient secretsManagerClient;
    private final GetSecretValueRequest getSecretValueRequest;
    private final Pair<String, Region> secretKey;
    private Secret secret;

    public AwsSecretsManagerConnectionPlugin(Properties props) {
        this(props, null, null);
    }

    AwsSecretsManagerConnectionPlugin(Properties props, SecretsManagerClient secretsManagerClient, GetSecretValueRequest getSecretValueRequest) {
        try {
            Class.forName("software.amazon.awssdk.services.secretsmanager.SecretsManagerClient");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(Messages.get("AwsSecretsManagerConnectionPlugin.javaSdkNotInClasspath"));
        }
        try {
            Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(Messages.get("AwsSecretsManagerConnectionPlugin.jacksonDatabindNotInClasspath"));
        }
        String secretId = SECRET_ID_PROPERTY.getString(props);
        if (StringUtils.isNullOrEmpty(secretId)) {
            throw new RuntimeException(Messages.get("AwsSecretsManagerConnectionPlugin.missingRequiredConfigParameter", new Object[]{AwsSecretsManagerConnectionPlugin.SECRET_ID_PROPERTY.name}));
        }
        String regionString = REGION_PROPERTY.getString(props);
        if (StringUtils.isNullOrEmpty(regionString)) {
            throw new RuntimeException(Messages.get("AwsSecretsManagerConnectionPlugin.missingRequiredConfigParameter", new Object[]{AwsSecretsManagerConnectionPlugin.REGION_PROPERTY.name}));
        }
        Region region = Region.of((String)regionString);
        if (!Region.regions().contains(region)) {
            throw new RuntimeException(Messages.get("AwsSecretsManagerConnectionPlugin.unsupportedRegion", new Object[]{regionString}));
        }
        this.secretKey = Pair.of((Object)secretId, (Object)region);
        if (secretsManagerClient != null && getSecretValueRequest != null) {
            this.secretsManagerClient = secretsManagerClient;
            this.getSecretValueRequest = getSecretValueRequest;
        } else {
            this.secretsManagerClient = (SecretsManagerClient)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(region)).build();
            this.getSecretValueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretId).build();
        }
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return new HashSet<String>(Collections.singletonList("connect"));
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        boolean secretWasFetched = this.updateSecret(false);
        try {
            this.applySecretToProperties(props);
            return connectFunc.call();
        }
        catch (SQLException exception) {
            if (this.isLoginUnsuccessful(exception) && !secretWasFetched && (secretWasFetched = this.updateSecret(true))) {
                this.applySecretToProperties(props);
                return connectFunc.call();
            }
            throw exception;
        }
        catch (Exception exception) {
            LOGGER.warning(() -> Messages.get("AwsSecretsManagerConnectionPlugin.unhandledException", new Object[]{exception}));
            throw new SQLException(exception);
        }
    }

    private boolean updateSecret(boolean forceReFetch) throws SQLException {
        boolean fetched = false;
        this.secret = SECRET_CACHE.get(this.secretKey);
        if (this.secret == null || forceReFetch) {
            try {
                this.secret = this.fetchLatestCredentials();
                if (this.secret != null) {
                    fetched = true;
                    SECRET_CACHE.put(this.secretKey, this.secret);
                }
            }
            catch (JsonProcessingException | SecretsManagerException exception) {
                LOGGER.log(Level.WARNING, exception, () -> Messages.get("AwsSecretsManagerConnectionPlugin.failedToFetchDbCredentials"));
                throw new SQLException(Messages.get("AwsSecretsManagerConnectionPlugin.failedToFetchDbCredentials"), exception);
            }
        }
        return fetched;
    }

    Secret fetchLatestCredentials() throws SecretsManagerException, JsonProcessingException {
        GetSecretValueResponse valueResponse = this.secretsManagerClient.getSecretValue(this.getSecretValueRequest);
        ObjectMapper mapper = new ObjectMapper();
        return (Secret)mapper.readValue(valueResponse.secretString(), Secret.class);
    }

    private void applySecretToProperties(Properties properties) {
        if (this.secret != null) {
            PropertyDefinition.USER.set(properties, this.secret.getUsername());
            PropertyDefinition.PASSWORD.set(properties, this.secret.getPassword());
        }
    }

    private boolean isLoginUnsuccessful(SQLException exception) {
        LOGGER.log(Level.WARNING, exception, () -> Messages.get("AwsSecretsManagerConnectionPlugin.failedLogin", new Object[]{exception.getSQLState()}));
        return SQLSTATE_ACCESS_ERROR.contains(exception.getSQLState());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Secret {
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="password")
        private String password;

        Secret() {
        }

        Secret(String username, String password) {
            this.username = username;
            this.password = password;
        }

        String getUsername() {
            return this.username;
        }

        String getPassword() {
            return this.password;
        }
    }
}

