/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.hostlistprovider;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostListProvider;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.hostlistprovider.DynamicHostListProvider;
import software.amazon.jdbc.util.ConnectionUrlParser;
import software.amazon.jdbc.util.ExpiringCache;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.Utils;

public class AuroraHostListProvider
implements HostListProvider,
DynamicHostListProvider {
    public static final AwsWrapperProperty CLUSTER_TOPOLOGY_REFRESH_RATE_MS = new AwsWrapperProperty("clusterTopologyRefreshRateMs", "30000", "Cluster topology refresh rate in millis. The cached topology for the cluster will be invalidated after the specified time, after which it will be updated during the next interaction with the connection.");
    public static final AwsWrapperProperty CLUSTER_ID = new AwsWrapperProperty("clusterId", "", "A unique identifier for the cluster. Connections with the same cluster id share a cluster topology cache. If unspecified, a cluster id is automatically created for AWS RDS clusters.");
    public static final AwsWrapperProperty CLUSTER_INSTANCE_HOST_PATTERN = new AwsWrapperProperty("clusterInstanceHostPattern", null, "The cluster instance DNS pattern that will be used to build a complete instance endpoint. A \"?\" character in this pattern should be used as a placeholder for cluster instance names. This pattern is required to be specified for IP address or custom domain connections to AWS RDS clusters. Otherwise, if unspecified, the pattern will be automatically created for AWS RDS clusters.");
    static final String PG_RETRIEVE_TOPOLOGY_SQL = "SELECT SERVER_ID, SESSION_ID FROM aurora_replica_status() WHERE EXTRACT(EPOCH FROM(NOW() - LAST_UPDATE_TIMESTAMP)) <= 300 OR SESSION_ID = 'MASTER_SESSION_ID' ORDER BY LAST_UPDATE_TIMESTAMP";
    static final String MYSQL_RETRIEVE_TOPOLOGY_SQL = "SELECT SERVER_ID, SESSION_ID, LAST_UPDATE_TIMESTAMP, REPLICA_LAG_IN_MILLISECONDS FROM information_schema.replica_host_status WHERE time_to_sec(timediff(now(), LAST_UPDATE_TIMESTAMP)) <= 300 ORDER BY LAST_UPDATE_TIMESTAMP";
    static final int DEFAULT_CACHE_EXPIRE_MS = 300000;
    static final String MYSQL_GET_INSTANCE_NAME_SQL = "SELECT @@aurora_server_id";
    static final String MYSQL_GET_INSTANCE_NAME_COL = "@@aurora_server_id";
    static final String PG_GET_INSTANCE_NAME_SQL = "SELECT aurora_db_instance_identifier()";
    static final String PG_INSTANCE_NAME_COL = "aurora_db_instance_identifier";
    static final String WRITER_SESSION_ID = "MASTER_SESSION_ID";
    static final String FIELD_SERVER_ID = "SERVER_ID";
    static final String FIELD_SESSION_ID = "SESSION_ID";
    private final HostListProviderService hostListProviderService;
    private final String originalUrl;
    private RdsUrlType rdsUrlType;
    private final RdsUtils rdsHelper;
    private int refreshRateInMilliseconds;
    private List<HostSpec> hostList;
    private List<HostSpec> lastReturnedHostList;
    private List<HostSpec> initialHostList;
    private HostSpec initialHostSpec;
    protected static final ExpiringCache<String, ClusterTopologyInfo> topologyCache = new ExpiringCache(300000L, AuroraHostListProvider.getOnEvict());
    private static final Object cacheLock = new Object();
    private static final String PG_DRIVER_PROTOCOL = "postgresql";
    private final String retrieveTopologyQuery;
    private final String retrieveInstanceQuery;
    private final String instanceNameCol;
    protected String clusterId;
    protected HostSpec clusterInstanceTemplate;
    protected ConnectionUrlParser connectionUrlParser;
    protected boolean isPrimaryClusterId;
    protected boolean isInitialized;
    private static final Logger LOGGER = Logger.getLogger(AuroraHostListProvider.class.getName());
    Properties properties;

    public AuroraHostListProvider(String driverProtocol, HostListProviderService hostListProviderService, Properties properties, String originalUrl) {
        this(driverProtocol, hostListProviderService, properties, originalUrl, new ConnectionUrlParser());
    }

    public AuroraHostListProvider(String driverProtocol, HostListProviderService hostListProviderService, Properties properties, String originalUrl, ConnectionUrlParser connectionUrlParser) {
        this.refreshRateInMilliseconds = Integer.parseInt(AuroraHostListProvider.CLUSTER_TOPOLOGY_REFRESH_RATE_MS.defaultValue != null ? AuroraHostListProvider.CLUSTER_TOPOLOGY_REFRESH_RATE_MS.defaultValue : "30000");
        this.hostList = new ArrayList<HostSpec>();
        this.initialHostList = new ArrayList<HostSpec>();
        this.isInitialized = false;
        this.rdsHelper = new RdsUtils();
        this.hostListProviderService = hostListProviderService;
        this.properties = properties;
        this.originalUrl = originalUrl;
        this.connectionUrlParser = connectionUrlParser;
        if (driverProtocol.contains(PG_DRIVER_PROTOCOL)) {
            this.retrieveTopologyQuery = PG_RETRIEVE_TOPOLOGY_SQL;
            this.retrieveInstanceQuery = PG_GET_INSTANCE_NAME_SQL;
            this.instanceNameCol = PG_INSTANCE_NAME_COL;
        } else {
            this.retrieveTopologyQuery = MYSQL_RETRIEVE_TOPOLOGY_SQL;
            this.retrieveInstanceQuery = MYSQL_GET_INSTANCE_NAME_SQL;
            this.instanceNameCol = MYSQL_GET_INSTANCE_NAME_COL;
        }
    }

    private static ExpiringCache.OnEvictRunnable<ClusterTopologyInfo> getOnEvict() {
        return evictedEntry -> LOGGER.finest(() -> "Entry with clusterId '" + evictedEntry.clusterId + "' has been evicted from the topology cache.");
    }

    protected void init() throws SQLException {
        if (this.isInitialized) {
            return;
        }
        this.initialHostList = this.connectionUrlParser.getHostsFromConnectionUrl(this.originalUrl);
        if (this.initialHostList == null || this.initialHostList.isEmpty()) {
            throw new SQLException(Messages.get("AuroraHostListProvider.parsedListEmpty", new Object[]{this.originalUrl}));
        }
        this.initialHostSpec = this.initialHostList.get(0);
        this.hostListProviderService.setInitialConnectionHostSpec(this.initialHostSpec);
        this.clusterId = UUID.randomUUID().toString();
        this.isPrimaryClusterId = false;
        this.refreshRateInMilliseconds = CLUSTER_TOPOLOGY_REFRESH_RATE_MS.getInteger(this.properties);
        this.clusterInstanceTemplate = CLUSTER_INSTANCE_HOST_PATTERN.getString(this.properties) == null ? new HostSpec(this.rdsHelper.getRdsInstanceHostPattern(this.originalUrl)) : new HostSpec(CLUSTER_INSTANCE_HOST_PATTERN.getString(this.properties));
        this.validateHostPatternSetting(this.clusterInstanceTemplate.getHost());
        this.rdsUrlType = this.rdsHelper.identifyRdsType(this.originalUrl);
        String clusterIdSetting = CLUSTER_ID.getString(this.properties);
        if (!StringUtils.isNullOrEmpty(clusterIdSetting)) {
            this.clusterId = clusterIdSetting;
        } else if (this.rdsUrlType == RdsUrlType.RDS_PROXY) {
            this.clusterId = this.initialHostSpec.getUrl();
        } else if (this.rdsUrlType.isRds()) {
            ClusterSuggestedResult clusterSuggestedResult = this.getSuggestedClusterId(this.initialHostSpec.getUrl());
            if (clusterSuggestedResult != null && !StringUtils.isNullOrEmpty(clusterSuggestedResult.clusterId)) {
                this.clusterId = clusterSuggestedResult.clusterId;
                this.isPrimaryClusterId = clusterSuggestedResult.isPrimaryClusterId;
            } else {
                String clusterRdsHostUrl = this.rdsHelper.getRdsClusterHostUrl(this.initialHostSpec.getUrl());
                if (!StringUtils.isNullOrEmpty(clusterRdsHostUrl)) {
                    this.clusterId = this.clusterInstanceTemplate.isPortSpecified() ? String.format("%s:%s", clusterRdsHostUrl, this.clusterInstanceTemplate.getPort()) : clusterRdsHostUrl;
                    this.isPrimaryClusterId = true;
                }
            }
        }
        this.isInitialized = true;
    }

    public FetchTopologyResult getTopology(Connection conn, boolean forceUpdate) throws SQLException {
        boolean needToSuggest;
        ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
        if (clusterTopologyInfo != null && !StringUtils.isNullOrEmpty(clusterTopologyInfo.suggestedPrimaryClusterId) && !this.clusterId.equals(clusterTopologyInfo.suggestedPrimaryClusterId)) {
            this.clusterId = clusterTopologyInfo.suggestedPrimaryClusterId;
            this.isPrimaryClusterId = true;
            clusterTopologyInfo = topologyCache.get(this.clusterId);
        }
        boolean bl = needToSuggest = clusterTopologyInfo == null && this.isPrimaryClusterId;
        if (clusterTopologyInfo == null || clusterTopologyInfo.hosts.isEmpty() || forceUpdate || this.refreshNeeded(clusterTopologyInfo)) {
            if (conn == null) {
                return new FetchTopologyResult(false, this.initialHostList);
            }
            ClusterTopologyInfo latestTopologyInfo = this.queryForTopology(conn);
            if (latestTopologyInfo != null && !latestTopologyInfo.hosts.isEmpty()) {
                clusterTopologyInfo = this.updateCache(clusterTopologyInfo, latestTopologyInfo);
                if (needToSuggest) {
                    this.suggestPrimaryCluster(clusterTopologyInfo);
                }
                return new FetchTopologyResult(false, clusterTopologyInfo.hosts);
            }
            if (clusterTopologyInfo != null && !forceUpdate) {
                return new FetchTopologyResult(true, clusterTopologyInfo.hosts);
            }
            return new FetchTopologyResult(false, this.initialHostList);
        }
        return new FetchTopologyResult(true, clusterTopologyInfo.hosts);
    }

    private ClusterSuggestedResult getSuggestedClusterId(String url) {
        for (Map.Entry<String, ClusterTopologyInfo> entry : topologyCache.entrySet()) {
            String key = entry.getKey();
            ClusterTopologyInfo value = entry.getValue();
            if (key.equals(url)) {
                return new ClusterSuggestedResult(url, value.isPrimaryCluster);
            }
            if (value.hosts == null) continue;
            for (HostSpec host : value.hosts) {
                if (!host.getUrl().equals(url)) continue;
                LOGGER.finest(() -> Messages.get("AuroraHostListProvider.suggestedClusterId", new Object[]{key, url}));
                return new ClusterSuggestedResult(key, value.isPrimaryCluster);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suggestPrimaryCluster(@NonNull ClusterTopologyInfo primaryClusterTopologyInfo) {
        if (Utils.isNullOrEmpty(primaryClusterTopologyInfo.hosts)) {
            return;
        }
        HashSet<String> primaryClusterHostUrls = new HashSet<String>();
        for (HostSpec hostSpec : primaryClusterTopologyInfo.hosts) {
            primaryClusterHostUrls.add(hostSpec.getUrl());
        }
        block4: for (Map.Entry entry : topologyCache.entrySet()) {
            if (((ClusterTopologyInfo)entry.getValue()).isPrimaryCluster || !StringUtils.isNullOrEmpty(((ClusterTopologyInfo)entry.getValue()).suggestedPrimaryClusterId) || Utils.isNullOrEmpty(((ClusterTopologyInfo)entry.getValue()).hosts)) continue;
            for (HostSpec host : ((ClusterTopologyInfo)entry.getValue()).hosts) {
                if (!primaryClusterHostUrls.contains(host.getUrl())) continue;
                try {
                    topologyCache.getLock().lock();
                    ((ClusterTopologyInfo)entry.getValue()).suggestedPrimaryClusterId = primaryClusterTopologyInfo.clusterId;
                    continue block4;
                }
                finally {
                    topologyCache.getLock().unlock();
                    continue block4;
                }
            }
        }
    }

    private boolean refreshNeeded(ClusterTopologyInfo info) {
        Instant lastUpdateTime = info.lastUpdated;
        return info.hosts.isEmpty() || Duration.between(lastUpdateTime, Instant.now()).toMillis() > (long)this.refreshRateInMilliseconds;
    }

    /*
     * Exception decompiling
     */
    protected ClusterTopologyInfo queryForTopology(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ClusterTopologyInfo processQueryResults(ResultSet resultSet) throws SQLException {
        HashMap<String, HostSpec> hostMap = new HashMap<String, HostSpec>();
        while (resultSet.next()) {
            HostSpec host = this.createHost(resultSet);
            hostMap.put(host.getHost(), host);
        }
        int writerCount = 0;
        ArrayList<HostSpec> hosts = new ArrayList<HostSpec>();
        for (HostSpec host : hostMap.values()) {
            if (host.getRole() == HostRole.WRITER) {
                ++writerCount;
            }
            hosts.add(host);
        }
        if (writerCount == 0) {
            LOGGER.severe(() -> Messages.get("AuroraHostListProvider.invalidTopology"));
            hosts.clear();
        }
        return new ClusterTopologyInfo(this.clusterId, hosts, Instant.now(), writerCount > 1, this.isPrimaryClusterId);
    }

    private HostSpec createHost(ResultSet resultSet) throws SQLException {
        return this.createHost(resultSet, WRITER_SESSION_ID.equals(resultSet.getString(FIELD_SESSION_ID)));
    }

    private HostSpec createHost(ResultSet resultSet, boolean isWriter) throws SQLException {
        String hostName = resultSet.getString(FIELD_SERVER_ID);
        hostName = hostName == null ? "?" : hostName;
        String endpoint = this.getHostEndpoint(hostName);
        int port = this.clusterInstanceTemplate.isPortSpecified() ? this.clusterInstanceTemplate.getPort() : this.initialHostSpec.getPort();
        HostSpec hostSpec = new HostSpec(endpoint, port, isWriter ? HostRole.WRITER : HostRole.READER);
        hostSpec.addAlias(hostName);
        return hostSpec;
    }

    private String getHostEndpoint(String nodeName) {
        String host = this.clusterInstanceTemplate.getHost();
        return host.replace("?", nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterTopologyInfo updateCache(@Nullable ClusterTopologyInfo clusterTopologyInfo, ClusterTopologyInfo latestTopologyInfo) {
        if (clusterTopologyInfo == null) {
            topologyCache.put(latestTopologyInfo.clusterId, latestTopologyInfo);
            return latestTopologyInfo;
        }
        if (clusterTopologyInfo.clusterId.equals(latestTopologyInfo.clusterId)) {
            try {
                topologyCache.getLock().lock();
                clusterTopologyInfo.hosts = latestTopologyInfo.hosts;
                clusterTopologyInfo.lastUpdated = Instant.now();
                topologyCache.put(clusterTopologyInfo.clusterId, clusterTopologyInfo);
            }
            finally {
                topologyCache.getLock().unlock();
            }
            return clusterTopologyInfo;
        }
        ClusterTopologyInfo primaryClusterTopologyInfo = topologyCache.get(this.clusterId);
        if (primaryClusterTopologyInfo != null) {
            try {
                topologyCache.getLock().lock();
                primaryClusterTopologyInfo.hosts = latestTopologyInfo.hosts;
                primaryClusterTopologyInfo.lastUpdated = Instant.now();
                topologyCache.put(primaryClusterTopologyInfo.clusterId, primaryClusterTopologyInfo);
            }
            finally {
                topologyCache.getLock().unlock();
            }
            return primaryClusterTopologyInfo;
        }
        topologyCache.put(latestTopologyInfo.clusterId, latestTopologyInfo);
        return latestTopologyInfo;
    }

    public @Nullable List<HostSpec> getCachedTopology() {
        ClusterTopologyInfo info = topologyCache.get(this.clusterId);
        return info == null || this.refreshNeeded(info) ? null : info.hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMultiWriterCluster() {
        Object object = cacheLock;
        synchronized (object) {
            ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
            return clusterTopologyInfo != null && clusterTopologyInfo.isMultiWriterCluster;
        }
    }

    /*
     * Exception decompiling
     */
    public HostSpec getHostByName(Connection conn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HostSpec instanceNameToHost(String name, List<HostSpec> hosts) {
        if (name == null || hosts == null) {
            return null;
        }
        for (HostSpec host : hosts) {
            if (host == null) continue;
            if (!host.getAliases().stream().anyMatch(name::equalsIgnoreCase)) continue;
            return host;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Object object = cacheLock;
        synchronized (object) {
            topologyCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = cacheLock;
        synchronized (object) {
            topologyCache.remove(this.clusterId);
        }
    }

    @Override
    public List<HostSpec> refresh() throws SQLException {
        return this.refresh(null);
    }

    @Override
    public List<HostSpec> refresh(Connection connection) throws SQLException {
        this.init();
        Connection currentConnection = connection != null ? connection : this.hostListProviderService.getCurrentConnection();
        FetchTopologyResult results = this.getTopology(currentConnection, false);
        LOGGER.finest(() -> Utils.logTopology(results.hosts));
        if (results.isCachedData && this.lastReturnedHostList == results.hosts) {
            return null;
        }
        this.hostList = results.hosts;
        this.lastReturnedHostList = this.hostList;
        return Collections.unmodifiableList(this.hostList);
    }

    @Override
    public List<HostSpec> forceRefresh() throws SQLException {
        return this.forceRefresh(null);
    }

    @Override
    public List<HostSpec> forceRefresh(Connection connection) throws SQLException {
        this.init();
        Connection currentConnection = connection != null ? connection : this.hostListProviderService.getCurrentConnection();
        FetchTopologyResult results = this.getTopology(currentConnection, true);
        LOGGER.finest(() -> Utils.logTopology(results.hosts));
        this.hostList = results.hosts;
        this.lastReturnedHostList = this.hostList;
        return Collections.unmodifiableList(this.hostList);
    }

    public RdsUrlType getRdsUrlType() throws SQLException {
        this.init();
        return this.rdsUrlType;
    }

    private void validateHostPatternSetting(String hostPattern) {
        if (!this.rdsHelper.isDnsPatternValid(hostPattern)) {
            String message = Messages.get("AuroraHostListProvider.invalidPattern");
            LOGGER.severe(message);
            throw new RuntimeException(message);
        }
        RdsUrlType rdsUrlType = this.rdsHelper.identifyRdsType(hostPattern);
        if (rdsUrlType == RdsUrlType.RDS_PROXY) {
            String message = Messages.get("AuroraHostListProvider.clusterInstanceHostPatternNotSupportedForRDSProxy");
            LOGGER.severe(message);
            throw new RuntimeException(message);
        }
        if (rdsUrlType == RdsUrlType.RDS_CUSTOM_CLUSTER) {
            String message = Messages.get("AuroraHostListProvider.clusterInstanceHostPatternNotSupportedForRdsCustom");
            LOGGER.severe(message);
            throw new RuntimeException(message);
        }
    }

    public static void logCache() {
        LOGGER.finest(() -> {
            StringBuilder sb = new StringBuilder();
            Set<Map.Entry<String, ClusterTopologyInfo>> cacheEntries = topologyCache.entrySet();
            if (cacheEntries.isEmpty()) {
                sb.append("Cache is empty.");
                return sb.toString();
            }
            for (Map.Entry<String, ClusterTopologyInfo> entry : cacheEntries) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append("[").append(entry.getKey()).append("]:\n").append("\tlastUpdated: ").append(entry.getValue().lastUpdated).append("\n").append("\tisMultiWriterCluster: ").append(entry.getValue().isMultiWriterCluster).append("\n").append("\tisPrimaryCluster: ").append(entry.getValue().isPrimaryCluster).append("\n").append("\tsuggestedPrimaryCluster: ").append(entry.getValue().suggestedPrimaryClusterId).append("\n").append("\tHosts: ");
                if (entry.getValue().hosts == null) {
                    sb.append("<null>");
                    continue;
                }
                for (HostSpec h : entry.getValue().hosts) {
                    sb.append("\n\t").append(h);
                }
            }
            return sb.toString();
        });
    }

    static class ClusterSuggestedResult {
        public String clusterId;
        public boolean isPrimaryClusterId;

        public ClusterSuggestedResult(String clusterId, boolean isPrimaryClusterId) {
            this.clusterId = clusterId;
            this.isPrimaryClusterId = isPrimaryClusterId;
        }
    }

    static class ClusterTopologyInfo {
        public String clusterId;
        public List<HostSpec> hosts;
        public Instant lastUpdated;
        public boolean isMultiWriterCluster;
        public boolean isPrimaryCluster;
        public String suggestedPrimaryClusterId;

        ClusterTopologyInfo(String clusterId, List<HostSpec> hosts, Instant lastUpdated, boolean isMultiWriterCluster, boolean isPrimaryCluster) {
            this.clusterId = clusterId;
            this.hosts = hosts;
            this.lastUpdated = lastUpdated;
            this.isMultiWriterCluster = isMultiWriterCluster;
            this.isPrimaryCluster = isPrimaryCluster;
        }
    }

    static class FetchTopologyResult {
        public List<HostSpec> hosts;
        public boolean isCachedData;

        public FetchTopologyResult(boolean isCachedData, List<HostSpec> hosts) {
            this.isCachedData = isCachedData;
            this.hosts = hosts;
        }
    }
}

