/*
 * Copyright 2007-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package software.amazon.ion;

/**
 * An error caused by a symbol not containing at least one character for
 * its text.
 *
 * @deprecated this exception is not used as empty symbols are valid. In cases where null is used as the symbol value it was
 * replaced by {@link NullPointerException}
 */
@Deprecated
public class EmptySymbolException
    extends IonException
{
    private static final long serialVersionUID = -7801632953459636349L;

    public EmptySymbolException()
    {
        super("Symbols must contain at least one character.");
    }
}
