/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.util.IonTextUtils;

public final class Timestamp
implements Comparable<Timestamp>,
Cloneable {
    private static final boolean APPLY_OFFSET_YES = true;
    private static final boolean APPLY_OFFSET_NO = false;
    private static final int NO_MONTH = 0;
    private static final int NO_DAY = 0;
    private static final int NO_HOURS = 0;
    private static final int NO_MINUTES = 0;
    private static final int NO_SECONDS = 0;
    private static final BigDecimal NO_FRACTIONAL_SECONDS = null;
    public static final Integer UNKNOWN_OFFSET = null;
    public static final Integer UTC_OFFSET = 0;
    private static final int FLAG_YEAR = 1;
    private static final int FLAG_MONTH = 2;
    private static final int FLAG_DAY = 4;
    private static final int FLAG_MINUTE = 8;
    private static final int FLAG_SECOND = 16;
    private static final int HASH_SIGNATURE = "INTERNAL TIMESTAMP".hashCode();
    private Precision _precision;
    private final Calendar _calendar;
    private BigDecimal _fraction;
    private Integer _offset;
    private int _calendarCompensationOffsetMs;
    private static final long MINIMUM_TIMESTAMP_IN_MILLIS = Timestamp.valueOf("0001-01-01T00:00:00.000Z").getMillis();
    static final BigDecimal MINIMUM_TIMESTAMP_IN_MILLIS_DECIMAL = new BigDecimal(MINIMUM_TIMESTAMP_IN_MILLIS);
    private static final long UPPER_BOUND_TIMESTAMP_IN_MILLIS = Timestamp.valueOf("9999-12-31T23:59:59.999-00:00").getMillis() + 1L;
    static final BigDecimal UPPER_BOUND_TIMESTAMP_IN_MILLIS_DECIMAL = new BigDecimal(UPPER_BOUND_TIMESTAMP_IN_MILLIS);
    static final String NULL_TIMESTAMP_IMAGE = "null.timestamp";
    static final int LEN_OF_NULL_IMAGE = "null.timestamp".length();
    static final int END_OF_YEAR = 4;
    static final int END_OF_MONTH = 7;
    static final int END_OF_DAY = 10;
    static final int END_OF_MINUTES = 16;
    static final int END_OF_SECONDS = 19;

    private void apply_offset(int offset) {
        if (offset == 0) {
            return;
        }
        if (offset < -1440 || offset > 1440) {
            throw new IllegalArgumentException("bad offset " + offset);
        }
        offset = -offset;
        int hour_offset = offset / 60;
        int min_offset = offset - hour_offset * 60;
        if (this._calendar.isSet(15) || this._calendar.isSet(16)) {
            this._calendarCompensationOffsetMs = -offset * 60 * 1000;
        }
        this._calendar.clear(15);
        this._calendar.clear(16);
        this._calendar.add(11, hour_offset);
        this._calendar.add(12, min_offset);
    }

    private static Calendar calendarFromMillis(long millis, Integer localOffset) {
        GregorianCalendar calendar = new GregorianCalendar(PrivateUtils.UTC);
        calendar.clear();
        calendar.setTimeInMillis(millis);
        if (localOffset != null) {
            calendar.set(15, localOffset * 60 * 1000);
        }
        return calendar;
    }

    private void setFieldsFromCalendar(Precision precision, boolean setLocalOffset, boolean applyLocalOffset) {
        this._precision = precision;
        this._offset = UNKNOWN_OFFSET;
        boolean calendarHasMilliseconds = this._calendar.isSet(14);
        switch (this._precision) {
            case SECOND: {
                if (calendarHasMilliseconds) {
                    BigDecimal millis = BigDecimal.valueOf(this._calendar.get(14));
                    this._fraction = millis.movePointLeft(3);
                    Timestamp.checkFraction(precision, this._fraction);
                }
            }
            case MINUTE: {
                int offset = this._calendar.get(15);
                if (!setLocalOffset) break;
                if (this._calendar.isSet(16)) {
                    offset += this._calendar.get(16);
                }
                this._offset = offset / 60000;
            }
        }
        if (this._offset != UNKNOWN_OFFSET && applyLocalOffset) {
            this.apply_offset(this._offset);
        }
        this._calendar.clear(14);
        Timestamp.checkCalendarYear(this._calendar);
    }

    private Timestamp(int zyear) {
        this(Precision.YEAR, zyear, 0, 0, 0, 0, 0, NO_FRACTIONAL_SECONDS, UNKNOWN_OFFSET, false);
    }

    private Timestamp(int zyear, int zmonth) {
        this(Precision.MONTH, zyear, zmonth, 0, 0, 0, 0, NO_FRACTIONAL_SECONDS, UNKNOWN_OFFSET, false);
    }

    @Deprecated
    private Timestamp(int zyear, int zmonth, int zday) {
        this(Precision.DAY, zyear, zmonth, zday, 0, 0, 0, NO_FRACTIONAL_SECONDS, UNKNOWN_OFFSET, false);
    }

    @Deprecated
    private Timestamp(int year, int month, int day, int hour, int minute, Integer offset) {
        this(Precision.MINUTE, year, month, day, hour, minute, 0, NO_FRACTIONAL_SECONDS, offset, true);
    }

    @Deprecated
    private Timestamp(int year, int month, int day, int hour, int minute, int second, Integer offset) {
        this(Precision.SECOND, year, month, day, hour, minute, second, NO_FRACTIONAL_SECONDS, offset, true);
    }

    private Timestamp(Precision p, int zyear, int zmonth, int zday, int zhour, int zminute, int zsecond, BigDecimal frac, Integer offset, boolean shouldApplyOffset) {
        this._calendar = new GregorianCalendar(PrivateUtils.UTC);
        this._calendar.clear();
        boolean dayPrecision = false;
        switch (p) {
            default: {
                throw new IllegalArgumentException("invalid Precision passed to constructor");
            }
            case SECOND: {
                this._fraction = frac == null || frac.equals(BigDecimal.ZERO) ? null : frac.abs();
                this._calendar.set(13, Timestamp.checkAndCastSecond(zsecond));
            }
            case MINUTE: {
                this._calendar.set(12, Timestamp.checkAndCastMinute(zminute));
                this._calendar.set(11, Timestamp.checkAndCastHour(zhour));
                this._offset = offset;
            }
            case DAY: {
                dayPrecision = true;
            }
            case MONTH: {
                this._calendar.set(2, Timestamp.checkAndCastMonth(zmonth) - 1);
            }
            case YEAR: 
        }
        this._calendar.set(1, Timestamp.checkAndCastYear(zyear));
        if (dayPrecision) {
            this.checkCalendarDay(zday);
            this._calendar.set(5, zday);
        }
        this._precision = Timestamp.checkFraction(p, this._fraction);
        if (shouldApplyOffset && offset != null) {
            this.apply_offset(offset);
        }
    }

    @Deprecated
    public static Timestamp createFromUtcFields(Precision p, int zyear, int zmonth, int zday, int zhour, int zminute, int zsecond, BigDecimal frac, Integer offset) {
        return new Timestamp(p, zyear, zmonth, zday, zhour, zminute, zsecond, frac, offset, false);
    }

    @Deprecated
    private Timestamp(Calendar cal) {
        Precision precision;
        if (cal.isSet(14) || cal.isSet(13)) {
            precision = Precision.SECOND;
        } else if (cal.isSet(11) || cal.isSet(12)) {
            precision = Precision.MINUTE;
        } else if (cal.isSet(5)) {
            precision = Precision.DAY;
        } else if (cal.isSet(2)) {
            precision = Precision.MONTH;
        } else if (cal.isSet(1)) {
            precision = Precision.YEAR;
        } else {
            throw new IllegalArgumentException("Calendar has no fields set");
        }
        this._calendar = (Calendar)cal.clone();
        this.setFieldsFromCalendar(precision, true, true);
    }

    private Timestamp(Calendar cal, Precision precision, BigDecimal fraction, Integer offset) {
        this._calendar = cal;
        this.setFieldsFromCalendar(precision, false, false);
        this._fraction = fraction;
        if (offset != null) {
            this._offset = offset;
        }
    }

    private static void throwTimestampOutOfRangeError(Number millis) {
        throw new IllegalArgumentException("millis: " + millis + " is outside of valid the range: from " + MINIMUM_TIMESTAMP_IN_MILLIS_DECIMAL + " (0001T), inclusive, to " + UPPER_BOUND_TIMESTAMP_IN_MILLIS_DECIMAL + " (10000T) , exclusive");
    }

    private Timestamp(BigDecimal millis, Precision precision, Integer localOffset) {
        if (millis == null) {
            throw new NullPointerException("millis is null");
        }
        if (millis.compareTo(MINIMUM_TIMESTAMP_IN_MILLIS_DECIMAL) < 0 || UPPER_BOUND_TIMESTAMP_IN_MILLIS_DECIMAL.compareTo(millis) <= 0) {
            Timestamp.throwTimestampOutOfRangeError(millis);
        }
        long ms = this.isIntegralZero(millis) ? 0L : millis.longValue();
        this._calendar = Timestamp.calendarFromMillis(ms, localOffset);
        this.setFieldsFromCalendar(precision, localOffset != null, false);
        if (precision.includes(Precision.SECOND) && millis.scale() > -3) {
            BigDecimal secs = millis.movePointLeft(3);
            BigDecimal secsDown = this.fastRoundZeroFloor(secs);
            this._fraction = secs.subtract(secsDown);
        } else {
            this._fraction = null;
        }
        Timestamp.checkFraction(precision, this._fraction);
    }

    @Deprecated
    private Timestamp(BigDecimal millis, Integer localOffset) {
        this(millis, Precision.SECOND, localOffset);
    }

    private BigDecimal fastRoundZeroFloor(BigDecimal decimal) {
        BigDecimal fastValue = decimal.signum() < 0 ? BigDecimal.ONE.negate() : BigDecimal.ZERO;
        return this.isIntegralZero(decimal) ? fastValue : decimal.setScale(0, RoundingMode.FLOOR);
    }

    private boolean isIntegralZero(BigDecimal decimal) {
        return decimal.signum() == 0 || decimal.scale() < -63 || decimal.precision() - decimal.scale() <= 0;
    }

    @Deprecated
    private Timestamp(long millis, Integer localOffset) {
        if (millis < MINIMUM_TIMESTAMP_IN_MILLIS || millis >= UPPER_BOUND_TIMESTAMP_IN_MILLIS) {
            Timestamp.throwTimestampOutOfRangeError(millis);
        }
        this._calendar = Timestamp.calendarFromMillis(millis, localOffset);
        this.setFieldsFromCalendar(Precision.SECOND, localOffset != null, false);
    }

    private static IllegalArgumentException fail(CharSequence input, String reason) {
        input = IonTextUtils.printString(input);
        return new IllegalArgumentException("invalid timestamp: " + reason + ": " + input);
    }

    private static IllegalArgumentException fail(CharSequence input) {
        input = IonTextUtils.printString(input);
        return new IllegalArgumentException("invalid timestamp: " + input);
    }

    public static Timestamp valueOf(CharSequence ionFormattedTimestamp) {
        Integer offset;
        int timezone_start;
        CharSequence in = ionFormattedTimestamp;
        int length = in.length();
        if (length == 0) {
            throw Timestamp.fail(in);
        }
        if (in.charAt(0) == 'n') {
            if (length >= LEN_OF_NULL_IMAGE && NULL_TIMESTAMP_IMAGE.contentEquals(in.subSequence(0, LEN_OF_NULL_IMAGE))) {
                if (length > LEN_OF_NULL_IMAGE && !Timestamp.isValidFollowChar(in.charAt(LEN_OF_NULL_IMAGE))) {
                    throw Timestamp.fail(in);
                }
                return null;
            }
            throw Timestamp.fail(in);
        }
        int year = 1;
        int month = 1;
        int day = 1;
        int hour = 0;
        int minute = 0;
        int seconds = 0;
        BigDecimal fraction = null;
        if (length < 5) {
            throw Timestamp.fail(in, "year is too short (must be at least yyyyT)");
        }
        int pos = 4;
        Precision precision = Precision.YEAR;
        year = Timestamp.read_digits(in, 0, 4, -1, "year");
        char c = in.charAt(4);
        if (c != 'T') {
            if (c != '-') {
                throw Timestamp.fail(in, "expected \"-\" between year and month, found " + IonTextUtils.printCodePointAsString(c));
            }
            if (length < 8) {
                throw Timestamp.fail(in, "month is too short (must be yyyy-mmT)");
            }
            pos = 7;
            precision = Precision.MONTH;
            month = Timestamp.read_digits(in, 5, 2, -1, "month");
            c = in.charAt(7);
            if (c != 'T') {
                if (c != '-') {
                    throw Timestamp.fail(in, "expected \"-\" between month and day, found " + IonTextUtils.printCodePointAsString(c));
                }
                if (length < 10) {
                    throw Timestamp.fail(in, "too short for yyyy-mm-dd");
                }
                pos = 10;
                precision = Precision.DAY;
                day = Timestamp.read_digits(in, 8, 2, -1, "day");
                if (length != 10) {
                    c = in.charAt(10);
                    if (c != 'T') {
                        throw Timestamp.fail(in, "expected \"T\" after day, found " + IonTextUtils.printCodePointAsString(c));
                    }
                    if (length != 11) {
                        if (length < 16) {
                            throw Timestamp.fail(in, "too short for yyyy-mm-ddThh:mm");
                        }
                        hour = Timestamp.read_digits(in, 11, 2, 58, "hour");
                        minute = Timestamp.read_digits(in, 14, 2, -1, "minutes");
                        pos = 16;
                        precision = Precision.MINUTE;
                        if (length > 16 && in.charAt(16) == ':') {
                            if (length < 19) {
                                throw Timestamp.fail(in, "too short for yyyy-mm-ddThh:mm:ss");
                            }
                            seconds = Timestamp.read_digits(in, 17, 2, -1, "seconds");
                            pos = 19;
                            precision = Precision.SECOND;
                            if (length > 19 && in.charAt(19) == '.') {
                                precision = Precision.SECOND;
                                for (pos = 20; length > pos && Character.isDigit(in.charAt(pos)); ++pos) {
                                }
                                if (pos <= 20) {
                                    throw Timestamp.fail(in, "must have at least one digit after decimal point");
                                }
                                fraction = new BigDecimal(in.subSequence(19, pos).toString());
                            }
                        }
                    }
                }
            }
        }
        int n = timezone_start = pos < length ? (int)in.charAt(pos) : 10;
        if (timezone_start == 90) {
            offset = 0;
            ++pos;
        } else if (timezone_start == 43 || timezone_start == 45) {
            int tzdHours;
            if (length < pos + 5) {
                throw Timestamp.fail(in, "local offset too short");
            }
            if ((tzdHours = Timestamp.read_digits(in, ++pos, 2, 58, "local offset hours")) < 0 || tzdHours > 23) {
                throw Timestamp.fail(in, "local offset hours must be between 0 and 23 inclusive");
            }
            int tzdMinutes = Timestamp.read_digits(in, pos += 3, 2, -1, "local offset minutes");
            if (tzdMinutes > 59) {
                throw Timestamp.fail(in, "local offset minutes must be between 0 and 59 inclusive");
            }
            pos += 2;
            int temp = tzdHours * 60 + tzdMinutes;
            if (timezone_start == 45) {
                temp = -temp;
            }
            offset = temp == 0 && timezone_start == 45 ? null : Integer.valueOf(temp);
        } else {
            switch (precision) {
                case DAY: 
                case MONTH: 
                case YEAR: {
                    break;
                }
                default: {
                    throw Timestamp.fail(in, "missing local offset");
                }
            }
            offset = null;
        }
        if (length > pos + 1 && !Timestamp.isValidFollowChar(in.charAt(pos + 1))) {
            throw Timestamp.fail(in, "invalid excess characters");
        }
        Timestamp ts = new Timestamp(precision, year, month, day, hour, minute, seconds, fraction, offset, true);
        return ts;
    }

    private static int read_digits(CharSequence in, int start, int length, int terminator, String field) {
        int ii;
        int value = 0;
        int end = start + length;
        if (in.length() < end) {
            throw Timestamp.fail(in, field + " requires " + length + " digits");
        }
        for (ii = start; ii < end; ++ii) {
            char c = in.charAt(ii);
            if (!Character.isDigit(c)) {
                throw Timestamp.fail(in, field + " has non-digit character " + IonTextUtils.printCodePointAsString(c));
            }
            value *= 10;
            value += c - 48;
        }
        if (terminator != -1) {
            if (ii >= in.length() || in.charAt(ii) != terminator) {
                throw Timestamp.fail(in, field + " should end with " + IonTextUtils.printCodePointAsString(terminator));
            }
        } else if (ii < in.length() && Character.isDigit(in.charAt(ii))) {
            throw Timestamp.fail(in, field + " requires " + length + " digits but has more");
        }
        return value;
    }

    private static boolean isValidFollowChar(char c) {
        switch (c) {
            default: {
                return false;
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case '\"': 
            case '\'': 
            case '(': 
            case ')': 
            case ',': 
            case '[': 
            case '\\': 
            case ']': 
            case '{': 
            case '}': 
        }
        return true;
    }

    public Timestamp clone() {
        return new Timestamp((Calendar)this._calendar.clone(), this._precision, this._fraction, this._offset);
    }

    private Timestamp make_localtime() {
        int offset = this._offset != null ? this._offset : 0;
        Timestamp localtime = this.clone();
        localtime.apply_offset(-offset);
        assert (localtime._offset == this._offset);
        return localtime;
    }

    public static Timestamp forYear(int yearZ) {
        return new Timestamp(yearZ);
    }

    public static Timestamp forMonth(int yearZ, int monthZ) {
        return new Timestamp(yearZ, monthZ);
    }

    public static Timestamp forDay(int yearZ, int monthZ, int dayZ) {
        return new Timestamp(yearZ, monthZ, dayZ);
    }

    public static Timestamp forMinute(int year, int month, int day, int hour, int minute, Integer offset) {
        return new Timestamp(year, month, day, hour, minute, offset);
    }

    public static Timestamp forSecond(int year, int month, int day, int hour, int minute, int second, Integer offset) {
        return new Timestamp(year, month, day, hour, minute, second, offset);
    }

    public static Timestamp forSecond(int year, int month, int day, int hour, int minute, BigDecimal second, Integer offset) {
        int s = second.intValue();
        BigDecimal frac = second.subtract(BigDecimal.valueOf(s));
        return new Timestamp(Precision.SECOND, year, month, day, hour, minute, s, frac, offset, true);
    }

    public static Timestamp forMillis(long millis, Integer localOffset) {
        return new Timestamp(millis, localOffset);
    }

    public static Timestamp forMillis(BigDecimal millis, Integer localOffset) {
        return new Timestamp(millis, localOffset);
    }

    public static Timestamp forCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return new Timestamp(calendar);
    }

    public static Timestamp forDateZ(Date date) {
        if (date == null) {
            return null;
        }
        long millis = date.getTime();
        return new Timestamp(millis, UTC_OFFSET);
    }

    public static Timestamp forSqlTimestampZ(java.sql.Timestamp sqlTimestamp) {
        BigDecimal frac;
        if (sqlTimestamp == null) {
            return null;
        }
        long millis = sqlTimestamp.getTime();
        Timestamp ts = new Timestamp(millis, UTC_OFFSET);
        int nanos = sqlTimestamp.getNanos();
        ts._fraction = frac = BigDecimal.valueOf(nanos).movePointLeft(9);
        return ts;
    }

    public static Timestamp now() {
        long millis = System.currentTimeMillis();
        return new Timestamp(millis, UNKNOWN_OFFSET);
    }

    public static Timestamp nowZ() {
        long millis = System.currentTimeMillis();
        return new Timestamp(millis, UTC_OFFSET);
    }

    public Date dateValue() {
        long millis = this.getMillis();
        return new Date(millis);
    }

    public Calendar calendarValue() {
        Calendar cal = (Calendar)this._calendar.clone();
        if (this._precision.includes(Precision.SECOND) && this._fraction != null) {
            int fractionalMillis = this._fraction.movePointRight(3).intValue();
            cal.set(14, fractionalMillis);
        }
        if (this._precision.includes(Precision.MINUTE) && this._offset != null && this._offset != 0) {
            int offsetMillis = this._offset * 60 * 1000;
            cal.add(14, offsetMillis);
            cal.set(15, offsetMillis);
        }
        if (!this._precision.includes(Precision.SECOND)) {
            cal.clear(13);
        }
        if (this._fraction == null) {
            cal.clear(14);
        }
        return cal;
    }

    public long getMillis() {
        long millis = this._calendar.getTimeInMillis();
        if (this._fraction != null) {
            BigDecimal fracAsDecimal = this._fraction.movePointRight(3);
            int frac = this.isIntegralZero(fracAsDecimal) ? 0 : fracAsDecimal.intValue();
            millis += (long)frac;
        }
        return millis + (long)this._calendarCompensationOffsetMs;
    }

    public BigDecimal getDecimalMillis() {
        switch (this._precision) {
            case SECOND: 
            case MINUTE: 
            case DAY: 
            case MONTH: 
            case YEAR: {
                long millis = this._calendar.getTimeInMillis() + (long)this._calendarCompensationOffsetMs;
                BigDecimal dec = BigDecimal.valueOf(millis);
                if (this._fraction != null) {
                    dec = dec.add(this._fraction.movePointRight(3));
                }
                return dec;
            }
        }
        throw new IllegalArgumentException();
    }

    public Precision getPrecision() {
        return this._precision;
    }

    public Integer getLocalOffset() {
        return this._offset;
    }

    public int getYear() {
        Timestamp adjusted = this;
        if (this._offset != null && this._offset != 0) {
            adjusted = this.make_localtime();
        }
        return adjusted.getZYear();
    }

    public int getMonth() {
        Timestamp adjusted = this;
        if (this._offset != null && this._offset != 0) {
            adjusted = this.make_localtime();
        }
        return adjusted.getZMonth();
    }

    public int getDay() {
        Timestamp adjusted = this;
        if (this._offset != null && this._offset != 0) {
            adjusted = this.make_localtime();
        }
        return adjusted.getZDay();
    }

    public int getHour() {
        Timestamp adjusted = this;
        if (this._offset != null && this._offset != 0) {
            adjusted = this.make_localtime();
        }
        return adjusted.getZHour();
    }

    public int getMinute() {
        Timestamp adjusted = this;
        if (this._offset != null && this._offset != 0) {
            adjusted = this.make_localtime();
        }
        return adjusted.getZMinute();
    }

    public int getSecond() {
        return this.getZSecond();
    }

    public BigDecimal getDecimalSecond() {
        BigDecimal sec = BigDecimal.valueOf(this.getSecond());
        if (this._fraction != null) {
            sec = sec.add(this._fraction);
        }
        return sec;
    }

    public int getZYear() {
        return this._calendar.get(1);
    }

    public int getZMonth() {
        return this._calendar.get(2) + 1;
    }

    public int getZDay() {
        return this._calendar.get(5);
    }

    public int getZHour() {
        return this._calendar.get(11);
    }

    public int getZMinute() {
        return this._calendar.get(12);
    }

    public int getZSecond() {
        return this._calendar.get(13);
    }

    public BigDecimal getZDecimalSecond() {
        return this.getDecimalSecond();
    }

    @Deprecated
    public BigDecimal getZFractionalSecond() {
        return this._fraction;
    }

    public Timestamp withLocalOffset(Integer offset) {
        Precision precision = this.getPrecision();
        if (precision.alwaysUnknownOffset() || PrivateUtils.safeEquals(offset, this.getLocalOffset())) {
            return this;
        }
        return new Timestamp((Calendar)this._calendar.clone(), precision, this._fraction, offset);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(32);
        try {
            this.print(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception printing to StringBuilder", e);
        }
        return buffer.toString();
    }

    public String toZString() {
        StringBuilder buffer = new StringBuilder(32);
        try {
            this.printZ(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception printing to StringBuilder", e);
        }
        return buffer.toString();
    }

    public void print(Appendable out) throws IOException {
        Timestamp adjusted = this;
        if (this._offset != null && this._offset != 0) {
            adjusted = this.make_localtime();
        }
        Timestamp.print(out, adjusted);
    }

    public void printZ(Appendable out) throws IOException {
        switch (this._precision) {
            case DAY: 
            case MONTH: 
            case YEAR: {
                assert (this._offset == UNKNOWN_OFFSET);
                this.print(out);
                break;
            }
            case SECOND: 
            case MINUTE: {
                Timestamp ztime = this.clone();
                ztime._offset = UTC_OFFSET;
                ztime.print(out);
                break;
            }
        }
    }

    private static void print(Appendable out, Timestamp adjusted) throws IOException {
        if (adjusted == null) {
            out.append(NULL_TIMESTAMP_IMAGE);
            return;
        }
        Timestamp.print_digits(out, adjusted.getZYear(), 4);
        if (adjusted._precision == Precision.YEAR) {
            assert (adjusted._offset == UNKNOWN_OFFSET);
            out.append("T");
            return;
        }
        out.append("-");
        Timestamp.print_digits(out, adjusted.getZMonth(), 2);
        if (adjusted._precision == Precision.MONTH) {
            assert (adjusted._offset == UNKNOWN_OFFSET);
            out.append("T");
            return;
        }
        out.append("-");
        Timestamp.print_digits(out, adjusted.getZDay(), 2);
        if (adjusted._precision == Precision.DAY) {
            assert (adjusted._offset == UNKNOWN_OFFSET);
            return;
        }
        out.append("T");
        Timestamp.print_digits(out, adjusted.getZHour(), 2);
        out.append(":");
        Timestamp.print_digits(out, adjusted.getZMinute(), 2);
        if (adjusted._precision.includes(Precision.SECOND)) {
            out.append(":");
            Timestamp.print_digits(out, adjusted.getZSecond(), 2);
            if (adjusted._fraction != null) {
                Timestamp.print_fractional_digits(out, adjusted._fraction);
            }
        }
        if (adjusted._offset != UNKNOWN_OFFSET) {
            int min = adjusted._offset;
            if (min == 0) {
                out.append('Z');
            } else {
                if (min < 0) {
                    min = -min;
                    out.append('-');
                } else {
                    out.append('+');
                }
                int hour = min / 60;
                Timestamp.print_digits(out, hour, 2);
                out.append(":");
                Timestamp.print_digits(out, min -= hour * 60, 2);
            }
        } else {
            out.append("-00:00");
        }
    }

    private static void print_digits(Appendable out, int value, int length) throws IOException {
        char[] temp = new char[length];
        while (length > 0) {
            int next = value / 10;
            temp[--length] = (char)(48 + (value - next * 10));
            value = next;
        }
        while (length > 0) {
            temp[--length] = 48;
        }
        for (char c : temp) {
            out.append(c);
        }
    }

    private static void print_fractional_digits(Appendable out, BigDecimal value) throws IOException {
        String temp = value.toPlainString();
        if (temp.charAt(0) == '0') {
            temp = temp.substring(1);
        }
        out.append(temp);
    }

    public final Timestamp adjustMillis(long amount) {
        if (amount == 0L) {
            return this;
        }
        Timestamp ts = this.addMillis(amount);
        ts._precision = this._precision;
        ts.clearUnusedPrecision();
        if (this._precision.includes(Precision.SECOND)) {
            if (this._fraction == null) {
                ts._fraction = null;
            } else if (ts._fraction.scale() > this._fraction.scale()) {
                ts._fraction = ts._fraction.setScale(this._fraction.scale(), RoundingMode.FLOOR);
            }
        }
        return ts;
    }

    public final Timestamp addMillis(long amount) {
        BigDecimal newFraction;
        if (amount == 0L && this._precision.includes(Precision.SECOND) && this._fraction != null && this._fraction.scale() >= 3) {
            return this;
        }
        long seconds = amount / 1000L;
        BigDecimal millis = BigDecimal.valueOf(amount % 1000L).movePointLeft(3);
        if (this._fraction != null) {
            millis = this._fraction.add(millis);
        }
        if (BigDecimal.ONE.compareTo(millis) <= 0) {
            newFraction = millis.subtract(BigDecimal.ONE);
            ++seconds;
        } else if (BigDecimal.ZERO.compareTo(millis) > 0) {
            newFraction = BigDecimal.ONE.add(millis);
            --seconds;
        } else {
            newFraction = millis;
        }
        Timestamp ts = this.addSecond(seconds);
        if (ts == this) {
            ts = this.clone();
        }
        ts._fraction = newFraction;
        return ts;
    }

    private Timestamp calendarAdd(int field, int amount, Precision precision) {
        if (amount == 0 && this._precision == precision) {
            return this;
        }
        Timestamp timestamp = this.make_localtime();
        timestamp._calendar.add(field, amount);
        Timestamp.checkCalendarYear(timestamp._calendar);
        if (this._offset != null) {
            timestamp.apply_offset(this._offset);
            timestamp._offset = this._offset;
        }
        timestamp._precision = this._precision.includes(precision) ? timestamp._precision : precision;
        return timestamp;
    }

    private void clearUnusedPrecision() {
        switch (this._precision) {
            case YEAR: {
                this._calendar.set(2, 0);
            }
            case MONTH: {
                this._calendar.set(5, 1);
            }
            case DAY: {
                this._calendar.set(11, 0);
                this._calendar.set(12, 0);
            }
            case MINUTE: {
                this._calendar.set(13, 0);
                this._fraction = null;
            }
        }
    }

    private Timestamp calendarAdjust(int field, int amount) {
        if (amount == 0) {
            return this;
        }
        Timestamp ts = this.calendarAdd(field, amount, this._precision);
        ts.clearUnusedPrecision();
        return ts;
    }

    private Timestamp addSecond(long seconds) {
        int incrementalSeconds;
        Timestamp ts = this;
        do {
            incrementalSeconds = seconds > Integer.MAX_VALUE ? Integer.MAX_VALUE : (seconds < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)seconds);
            ts = ts.addSecond(incrementalSeconds);
        } while ((seconds -= (long)incrementalSeconds) != 0L);
        return ts;
    }

    public final Timestamp adjustSecond(int amount) {
        return this.calendarAdjust(13, amount);
    }

    public final Timestamp addSecond(int amount) {
        return this.calendarAdd(13, amount, Precision.SECOND);
    }

    public final Timestamp adjustMinute(int amount) {
        return this.calendarAdjust(12, amount);
    }

    public final Timestamp addMinute(int amount) {
        return this.calendarAdd(12, amount, Precision.MINUTE);
    }

    public final Timestamp adjustHour(int amount) {
        return this.calendarAdjust(11, amount);
    }

    public final Timestamp addHour(int amount) {
        return this.calendarAdd(11, amount, Precision.MINUTE);
    }

    public final Timestamp adjustDay(int amount) {
        return this.calendarAdjust(5, amount);
    }

    public final Timestamp addDay(int amount) {
        return this.calendarAdd(5, amount, Precision.DAY);
    }

    public final Timestamp adjustMonth(int amount) {
        return this.calendarAdjust(2, amount);
    }

    public final Timestamp addMonth(int amount) {
        return this.calendarAdd(2, amount, Precision.MONTH);
    }

    public final Timestamp adjustYear(int amount) {
        return this.addYear(amount);
    }

    public final Timestamp addYear(int amount) {
        return this.calendarAdd(1, amount, Precision.YEAR);
    }

    public int hashCode() {
        int prime = 8191;
        int result = HASH_SIGNATURE;
        result = 8191 * result + (this._fraction != null ? this._fraction.hashCode() : 0);
        result ^= result << 19 ^ result >> 13;
        result = 8191 * result + this.getZYear();
        result = 8191 * result + this.getZMonth();
        result = 8191 * result + this.getZDay();
        result = 8191 * result + this.getZHour();
        result = 8191 * result + this.getZMinute();
        result = 8191 * result + this.getZSecond();
        result ^= result << 19 ^ result >> 13;
        result = 8191 * result + this._precision.toString().hashCode();
        result ^= result << 19 ^ result >> 13;
        result = 8191 * result + (this._offset == null ? 0 : this._offset.hashCode());
        result ^= result << 19 ^ result >> 13;
        return result;
    }

    @Override
    public int compareTo(Timestamp t) {
        long arg_millis;
        long this_millis = this.getMillis();
        if (this_millis != (arg_millis = t.getMillis())) {
            return this_millis < arg_millis ? -1 : 1;
        }
        BigDecimal this_fraction = this._fraction == null ? BigDecimal.ZERO : this._fraction;
        BigDecimal arg_fraction = t._fraction == null ? BigDecimal.ZERO : t._fraction;
        return this_fraction.compareTo(arg_fraction);
    }

    public boolean equals(Object t) {
        if (!(t instanceof Timestamp)) {
            return false;
        }
        return this.equals((Timestamp)t);
    }

    public boolean equals(Timestamp t) {
        if (this == t) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (this._precision != t._precision) {
            return false;
        }
        if (this._offset == null ? t._offset != null : t._offset == null) {
            return false;
        }
        if (this.getZYear() != t.getZYear()) {
            return false;
        }
        if (this.getZMonth() != t.getZMonth()) {
            return false;
        }
        if (this.getZDay() != t.getZDay()) {
            return false;
        }
        if (this.getZHour() != t.getZHour()) {
            return false;
        }
        if (this.getZMinute() != t.getZMinute()) {
            return false;
        }
        if (this.getZSecond() != t.getZSecond()) {
            return false;
        }
        if (this._offset != null && this._offset.intValue() != t._offset.intValue()) {
            return false;
        }
        if (this._fraction != null && t._fraction == null || this._fraction == null && t._fraction != null) {
            return false;
        }
        if (this._fraction == null && t._fraction == null) {
            return true;
        }
        return this._fraction.equals(t._fraction);
    }

    private static void checkCalendarYear(Calendar calendar) {
        int year = calendar.get(1);
        if (calendar.get(0) == 0) {
            year *= -1;
        }
        Timestamp.checkAndCastYear(year);
    }

    private static short checkAndCastYear(int year) {
        if (year < 1 || year > 9999) {
            throw new IllegalArgumentException(String.format("Year %s must be between 1 and 9999 inclusive", year));
        }
        return (short)year;
    }

    private static byte checkAndCastMonth(int month) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException(String.format("Month %s must be between 1 and 12 inclusive", month));
        }
        return (byte)month;
    }

    private void checkCalendarDay(int day) {
        int lastDayInMonth = this._calendar.getActualMaximum(5);
        if (day > lastDayInMonth || day < this._calendar.getActualMinimum(5)) {
            throw new IllegalArgumentException(String.format("Day %s for year %s and month %s must be between 1 and %s inclusive", day, this.getZYear(), this.getZMonth(), lastDayInMonth));
        }
    }

    private static byte checkAndCastHour(int hour) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException(String.format("Hour %s must be between 0 and 23 inclusive", hour));
        }
        return (byte)hour;
    }

    private static byte checkAndCastMinute(int minute) {
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException(String.format("Minute %s must be between between 0 and 59 inclusive", minute));
        }
        return (byte)minute;
    }

    private static byte checkAndCastSecond(int second) {
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException(String.format("Second %s must be between between 0 and 59 inclusive", second));
        }
        return (byte)second;
    }

    private static Precision checkFraction(Precision precision, BigDecimal fraction) {
        if (precision.includes(Precision.SECOND)) {
            if (fraction != null && (fraction.signum() == -1 || BigDecimal.ONE.compareTo(fraction) != 1)) {
                throw new IllegalArgumentException(String.format("Fractional seconds %s must be greater than or equal to 0 and less than 1", fraction));
            }
        } else if (fraction != null) {
            throw new IllegalArgumentException("Fraction must be null for non-second precision: " + fraction);
        }
        return precision;
    }

    public static enum Precision {
        YEAR(1),
        MONTH(3),
        DAY(7),
        MINUTE(15),
        SECOND(31);

        private final int flags;

        private Precision(int flags) {
            this.flags = flags;
        }

        private boolean alwaysUnknownOffset() {
            return this.ordinal() <= DAY.ordinal();
        }

        public boolean includes(Precision isIncluded) {
            switch (isIncluded) {
                case SECOND: {
                    return (this.flags & 0x10) != 0;
                }
                case MINUTE: {
                    return (this.flags & 8) != 0;
                }
                case DAY: {
                    return (this.flags & 4) != 0;
                }
                case MONTH: {
                    return (this.flags & 2) != 0;
                }
                case YEAR: {
                    return (this.flags & 1) != 0;
                }
            }
            throw new IllegalStateException("unrecognized precision" + (Object)((Object)isIncluded));
        }
    }
}

