/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ionpathextraction;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import software.amazon.ion.IonReader;
import software.amazon.ionpathextraction.PathComponentParser;
import software.amazon.ionpathextraction.PathExtractor;
import software.amazon.ionpathextraction.PathExtractorConfig;
import software.amazon.ionpathextraction.PathExtractorImpl;
import software.amazon.ionpathextraction.SearchPath;
import software.amazon.ionpathextraction.pathcomponents.PathComponent;
import software.amazon.ionpathextraction.utils.Preconditions;

public final class PathExtractorBuilder {
    private static final boolean DEFAULT_MATCH_RELATIVE_PATHS = false;
    private static final boolean DEFAULT_CASE_INSENSITIVE = false;
    private final List<SearchPath> searchPaths = new ArrayList<SearchPath>();
    private boolean matchRelativePaths;
    private boolean matchCaseInsensitive;

    private PathExtractorBuilder() {
    }

    public static PathExtractorBuilder standard() {
        PathExtractorBuilder builder = new PathExtractorBuilder();
        builder.matchCaseInsensitive = false;
        builder.matchRelativePaths = false;
        return builder;
    }

    public PathExtractor build() {
        return new PathExtractorImpl(this.searchPaths, new PathExtractorConfig(this.matchRelativePaths, this.matchCaseInsensitive));
    }

    public PathExtractorBuilder withMatchRelativePaths(boolean matchRelativePaths) {
        this.matchRelativePaths = matchRelativePaths;
        return this;
    }

    public PathExtractorBuilder withMatchCaseInsensitive(boolean matchCaseInsensitive) {
        this.matchCaseInsensitive = matchCaseInsensitive;
        return this;
    }

    public PathExtractorBuilder withSearchPath(String searchPathAsIon, Function<IonReader, Integer> callback) {
        Preconditions.checkArgument(searchPathAsIon != null, "searchPathAsIon cannot be null");
        List<PathComponent> pathComponents = PathComponentParser.parse(searchPathAsIon);
        this.withSearchPath(pathComponents, callback);
        return this;
    }

    public PathExtractorBuilder withSearchPath(List<PathComponent> pathComponents, Function<IonReader, Integer> callback) {
        Preconditions.checkArgument(pathComponents != null, "pathComponents cannot be null");
        Preconditions.checkArgument(callback != null, "callback cannot be null");
        this.searchPaths.add(new SearchPath(pathComponents, callback));
        return this;
    }
}

