/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.utils;

import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import lombok.Generated;
import lombok.NonNull;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AVROUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AVROUtils.class);

    private AVROUtils() {
    }

    public static synchronized AVROUtils getInstance() {
        return UtilsHelper.INSTANCE;
    }

    public String getSchemaDefinition(@NonNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object is marked @NonNull but is null");
        }
        Schema schema = this.getSchema(object);
        if (null == schema) {
            String message = "Unsupported Type of Record received";
            log.error(message);
            throw new AWSSchemaRegistryException(message);
        }
        return schema.toString();
    }

    public Schema getSchema(@NonNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object is marked @NonNull but is null");
        }
        if (object instanceof GenericContainer) {
            return ((GenericContainer)object).getSchema();
        }
        log.error("Unsupported Avro Data Formats");
        return null;
    }

    private static class UtilsHelper {
        private static final AVROUtils INSTANCE = new AVROUtils();

        private UtilsHelper() {
        }
    }
}

