/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers.avro;

import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryClient;
import com.amazonaws.services.schemaregistry.common.AWSSerializerInput;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.serializers.GlueSchemaRegistrySerializationFacade;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.glue.model.DataFormat;

public class AWSAvroSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AWSAvroSerializer.class);
    private GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade;

    public AWSAvroSerializer(@NonNull AwsCredentialsProvider credentialProvider, AWSSchemaRegistryClient schemaRegistryClient, Map<String, ?> configs, Properties properties) {
        GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration;
        if (credentialProvider == null) {
            throw new IllegalArgumentException("credentialProvider is marked @NonNull but is null");
        }
        if (configs != null) {
            glueSchemaRegistryConfiguration = new GlueSchemaRegistryConfiguration(configs);
        } else if (properties != null) {
            glueSchemaRegistryConfiguration = new GlueSchemaRegistryConfiguration(properties);
        } else {
            throw new AWSSchemaRegistryException("Configuration map and properties cannot be null");
        }
        this.glueSchemaRegistrySerializationFacade = new GlueSchemaRegistrySerializationFacade(credentialProvider, schemaRegistryClient, glueSchemaRegistryConfiguration);
    }

    public UUID registerSchema(@NonNull AWSSerializerInput serializerInput) {
        if (serializerInput == null) {
            throw new IllegalArgumentException("serializerInput is marked @NonNull but is null");
        }
        return this.glueSchemaRegistrySerializationFacade.getOrRegisterSchemaVersion(serializerInput);
    }

    public byte[] serialize(@NonNull Object data, @NonNull UUID schemaVersionId) {
        if (data == null) {
            throw new IllegalArgumentException("data is marked @NonNull but is null");
        }
        if (schemaVersionId == null) {
            throw new IllegalArgumentException("schemaVersionId is marked @NonNull but is null");
        }
        return this.glueSchemaRegistrySerializationFacade.serialize(DataFormat.AVRO, data, schemaVersionId);
    }

    @Generated
    public static AWSAvroSerializerBuilder builder() {
        return new AWSAvroSerializerBuilder();
    }

    @Generated
    public static class AWSAvroSerializerBuilder {
        @Generated
        private AwsCredentialsProvider credentialProvider;
        @Generated
        private AWSSchemaRegistryClient schemaRegistryClient;
        @Generated
        private Map<String, ?> configs;
        @Generated
        private Properties properties;

        @Generated
        AWSAvroSerializerBuilder() {
        }

        @Generated
        public AWSAvroSerializerBuilder credentialProvider(AwsCredentialsProvider credentialProvider) {
            this.credentialProvider = credentialProvider;
            return this;
        }

        @Generated
        public AWSAvroSerializerBuilder schemaRegistryClient(AWSSchemaRegistryClient schemaRegistryClient) {
            this.schemaRegistryClient = schemaRegistryClient;
            return this;
        }

        @Generated
        public AWSAvroSerializerBuilder configs(Map<String, ?> configs) {
            this.configs = configs;
            return this;
        }

        @Generated
        public AWSAvroSerializerBuilder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        @Generated
        public AWSAvroSerializer build() {
            return new AWSAvroSerializer(this.credentialProvider, this.schemaRegistryClient, this.configs, this.properties);
        }

        @Generated
        public String toString() {
            return "AWSAvroSerializer.AWSAvroSerializerBuilder(credentialProvider=" + this.credentialProvider + ", schemaRegistryClient=" + this.schemaRegistryClient + ", configs=" + this.configs + ", properties=" + this.properties + ")";
        }
    }
}

