/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.encryption.s3.S3EncryptionClient;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.internal.ApiNameVersion;
import software.amazon.encryption.s3.materials.DecryptDataKeyStrategy;
import software.amazon.encryption.s3.materials.DecryptionMaterials;
import software.amazon.encryption.s3.materials.EncryptDataKeyStrategy;
import software.amazon.encryption.s3.materials.GenerateDataKeyStrategy;
import software.amazon.encryption.s3.materials.S3Keyring;

public class KmsDiscoveryKeyring
extends S3Keyring {
    private static final ApiName API_NAME = ApiNameVersion.apiNameWithVersion();
    private static final String KEY_ID_CONTEXT_KEY = "kms_cmk_id";
    private final KmsClient _kmsClient;
    private final Map<String, DecryptDataKeyStrategy> decryptDataKeyStrategies = new HashMap<String, DecryptDataKeyStrategy>();
    private final DecryptDataKeyStrategy _kmsDiscoveryStrategy = new DecryptDataKeyStrategy(){
        private static final String KEY_PROVIDER_INFO = "kms";

        @Override
        public boolean isLegacy() {
            return true;
        }

        @Override
        public String keyProviderInfo() {
            return KEY_PROVIDER_INFO;
        }

        @Override
        public byte[] decryptDataKey(DecryptionMaterials materials, byte[] encryptedDataKey) {
            DecryptRequest request = (DecryptRequest)DecryptRequest.builder().encryptionContext(materials.encryptionContext()).ciphertextBlob(SdkBytes.fromByteArray((byte[])encryptedDataKey)).overrideConfiguration(builder -> builder.addApiName(API_NAME)).build();
            DecryptResponse response = KmsDiscoveryKeyring.this._kmsClient.decrypt(request);
            return response.plaintext().asByteArray();
        }
    };
    private final DecryptDataKeyStrategy _kmsContextDiscoveryStrategy = new DecryptDataKeyStrategy(){
        private static final String KEY_PROVIDER_INFO = "kms+context";
        private static final String ENCRYPTION_CONTEXT_ALGORITHM_KEY = "aws:x-amz-cek-alg";

        @Override
        public boolean isLegacy() {
            return false;
        }

        @Override
        public String keyProviderInfo() {
            return KEY_PROVIDER_INFO;
        }

        @Override
        public byte[] decryptDataKey(DecryptionMaterials materials, byte[] encryptedDataKey) {
            AwsRequestOverrideConfiguration overrideConfig;
            Optional optEncryptionContext;
            HashMap requestEncryptionContext = new HashMap();
            GetObjectRequest s3Request = materials.s3Request();
            if (s3Request.overrideConfiguration().isPresent() && (optEncryptionContext = (overrideConfig = (AwsRequestOverrideConfiguration)s3Request.overrideConfiguration().get()).executionAttributes().getOptionalAttribute(S3EncryptionClient.ENCRYPTION_CONTEXT)).isPresent()) {
                requestEncryptionContext = new HashMap((Map)optEncryptionContext.get());
            }
            HashMap<String, String> materialsEncryptionContextCopy = new HashMap<String, String>(materials.encryptionContext());
            materialsEncryptionContextCopy.remove(KmsDiscoveryKeyring.KEY_ID_CONTEXT_KEY);
            materialsEncryptionContextCopy.remove(ENCRYPTION_CONTEXT_ALGORITHM_KEY);
            if (!materialsEncryptionContextCopy.equals(requestEncryptionContext)) {
                throw new S3EncryptionClientException("Provided encryption context does not match information retrieved from S3");
            }
            DecryptRequest request = (DecryptRequest)DecryptRequest.builder().encryptionContext(materials.encryptionContext()).ciphertextBlob(SdkBytes.fromByteArray((byte[])encryptedDataKey)).overrideConfiguration(builder -> builder.addApiName(API_NAME)).build();
            DecryptResponse response = KmsDiscoveryKeyring.this._kmsClient.decrypt(request);
            return response.plaintext().asByteArray();
        }
    };

    public KmsDiscoveryKeyring(Builder builder) {
        super(builder);
        this._kmsClient = builder._kmsClient;
        this.decryptDataKeyStrategies.put(this._kmsDiscoveryStrategy.keyProviderInfo(), this._kmsDiscoveryStrategy);
        this.decryptDataKeyStrategies.put(this._kmsContextDiscoveryStrategy.keyProviderInfo(), this._kmsContextDiscoveryStrategy);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected GenerateDataKeyStrategy generateDataKeyStrategy() {
        throw new S3EncryptionClientException("KmsDiscoveryKeyring does not support GenerateDataKey");
    }

    @Override
    protected EncryptDataKeyStrategy encryptDataKeyStrategy() {
        throw new S3EncryptionClientException("KmsDiscoveryKeyring does not support EncryptDataKey");
    }

    @Override
    protected Map<String, DecryptDataKeyStrategy> decryptDataKeyStrategies() {
        return this.decryptDataKeyStrategies;
    }

    public static class Builder
    extends S3Keyring.Builder<KmsDiscoveryKeyring, Builder> {
        private KmsClient _kmsClient;

        private Builder() {
        }

        @Override
        protected Builder builder() {
            return this;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Pass mutability into wrapping client")
        public Builder kmsClient(KmsClient kmsClient) {
            this._kmsClient = kmsClient;
            return this;
        }

        @Override
        public KmsDiscoveryKeyring build() {
            if (this._kmsClient == null) {
                this._kmsClient = KmsClient.create();
            }
            return new KmsDiscoveryKeyring(this);
        }
    }
}

