/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.internal.ContentDecryptionStrategy;
import software.amazon.encryption.s3.internal.ContentMetadata;
import software.amazon.encryption.s3.internal.CryptoFactory;
import software.amazon.encryption.s3.materials.DecryptionMaterials;

public class BufferedAesGcmContentStrategy
implements ContentDecryptionStrategy {
    private static final long BUFFERED_MAX_CONTENT_LENGTH_MiB = 64L;
    private static final long BUFFERED_MAX_CONTENT_LENGTH_BYTES = 0x4000000L;

    private BufferedAesGcmContentStrategy(Builder builder) {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public InputStream decryptContent(ContentMetadata contentMetadata, DecryptionMaterials materials, InputStream ciphertextStream) {
        byte[] plaintext;
        byte[] ciphertext;
        if (materials.ciphertextLength() > 0x4000000L) {
            throw new S3EncryptionClientException(String.format("The object you are attempting to decrypt exceeds the maximum content length allowed in default mode. Please enable Delayed Authentication mode to decrypt objects largerthan %d", 64L));
        }
        try {
            ciphertext = IoUtils.toByteArray((InputStream)ciphertextStream);
        }
        catch (IOException e) {
            throw new S3EncryptionClientException("Unexpected exception while buffering ciphertext input stream!", e);
        }
        AlgorithmSuite algorithmSuite = contentMetadata.algorithmSuite();
        SecretKeySpec contentKey = new SecretKeySpec(materials.plaintextDataKey(), algorithmSuite.dataKeyAlgorithm());
        int tagLength = algorithmSuite.cipherTagLengthBits();
        byte[] iv = contentMetadata.contentIv();
        try {
            Cipher cipher = CryptoFactory.createCipher(algorithmSuite.cipherName(), materials.cryptoProvider());
            cipher.init(2, (Key)contentKey, new GCMParameterSpec(tagLength, iv));
            plaintext = cipher.doFinal(ciphertext);
        }
        catch (GeneralSecurityException e) {
            throw new S3EncryptionClientException("Unable to " + algorithmSuite.cipherName() + " content decrypt.", e);
        }
        return new ByteArrayInputStream(plaintext);
    }

    public static class Builder {
        private Builder() {
        }

        public BufferedAesGcmContentStrategy build() {
            return new BufferedAesGcmContentStrategy(this);
        }
    }
}

