/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.partiql.processor;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.ProjectionExpression;
import com.amazonaws.services.dynamodbv2.rr.ProjectionExpressionWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchStatementError;
import software.amazon.awssdk.services.dynamodb.model.BatchStatementResponse;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.exceptions.DynamoDBLocalServiceException;
import software.amazon.dynamodb.services.local.google.Sets;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.api.dp.BatchExecuteStatementFunction;
import software.amazon.dynamodb.services.local.shared.env.LocalPartiQLDbEnv;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.model.TableNameAndPrimaryKey;
import software.amazon.dynamodb.services.local.shared.partiql.ParsedPartiQLRequest;
import software.amazon.dynamodb.services.local.shared.partiql.model.TranslatedPartiQLOperation;
import software.amazon.dynamodb.services.local.shared.partiql.processor.BatchProcessor;
import software.amazon.dynamodb.services.local.shared.partiql.util.ObjectExceptionPair;

public class BatchGetProcessor
extends BatchProcessor {
    private static final String ITEM_UNPROCESSED = "Total returned items size limit exceeded (16777216 ). Request not processed.";

    public BatchGetProcessor(LocalDBAccess dbAccess, LocalPartiQLDbEnv localPartiQLDbEnv, BatchExecuteStatementFunction batchExecuteStatementFunction, DocumentFactory documentFactory) {
        super(dbAccess, localPartiQLDbEnv, batchExecuteStatementFunction, documentFactory);
    }

    @Override
    public BatchExecuteStatementResponse execute(List<ObjectExceptionPair<ParsedPartiQLRequest>> parsedPartiQLRequestsExceptionPairs) {
        List<ObjectExceptionPair<TranslatedPartiQLOperation>> translatedPartiQLOperationExceptionPairs = this.performTranslations(parsedPartiQLRequestsExceptionPairs);
        List<BatchStatementResponse> batchStatementResponses = this.partiqlBatchGet(translatedPartiQLOperationExceptionPairs);
        return (BatchExecuteStatementResponse)BatchExecuteStatementResponse.builder().responses(batchStatementResponses).build();
    }

    private List<BatchStatementResponse> partiqlBatchGet(List<ObjectExceptionPair<TranslatedPartiQLOperation>> translatedPartiQLOperationExceptionPairs) {
        long totalSize = 0L;
        ArrayList<BatchStatementResponse> batchStatementResponses = new ArrayList<BatchStatementResponse>();
        boolean returnLimitExceeded = false;
        Set<TableNameAndPrimaryKey> keysInvolved = Sets.newHashSet(new TableNameAndPrimaryKey[0]);
        for (ObjectExceptionPair<TranslatedPartiQLOperation> translatedPartiQLOperationExceptionPair : translatedPartiQLOperationExceptionPairs) {
            if (translatedPartiQLOperationExceptionPair.hasException()) {
                batchStatementResponses.add(BatchGetProcessor.convertInternalExceptionToBatchStatementResponse(translatedPartiQLOperationExceptionPair.getException(), null));
                continue;
            }
            TranslatedPartiQLOperation translatedPartiQLOperation = translatedPartiQLOperationExceptionPair.getObject();
            String tableName = translatedPartiQLOperation.getTableName();
            if (returnLimitExceeded) {
                batchStatementResponses.add((BatchStatementResponse)BatchStatementResponse.builder().tableName(tableName).error((BatchStatementError)BatchStatementError.builder().code(AmazonServiceExceptionType.REQUEST_TOO_LARGE.getErrorCode()).message(ITEM_UNPROCESSED).build()).build());
                continue;
            }
            try {
                Map<String, AttributeValue> key = translatedPartiQLOperation.getItem();
                this.partiQLStatementFunction.validateGetKey((Map)key, this.dbAccess.getTableInfo(tableName));
                Map<String, AttributeValue> record = this.dbAccess.getRecord(tableName, key);
                if ((totalSize += LocalDBUtils.getItemSizeBytes(record)) > 0x1000000L) {
                    returnLimitExceeded = true;
                    batchStatementResponses.add((BatchStatementResponse)BatchStatementResponse.builder().tableName(tableName).error((BatchStatementError)BatchStatementError.builder().code(AmazonServiceExceptionType.REQUEST_TOO_LARGE.getErrorCode()).message(ITEM_UNPROCESSED).build()).build());
                    continue;
                }
                ProjectionExpressionWrapper projectionExpressionWrapper = translatedPartiQLOperation.getProjectionExpressionWrapper();
                ProjectionExpression projectionExpression = projectionExpressionWrapper == null ? null : projectionExpressionWrapper.getProjection();
                Map<String, AttributeValue> projectedAttributes = LocalDBUtils.projectAttributes(record, projectionExpression);
                batchStatementResponses.add((BatchStatementResponse)BatchStatementResponse.builder().tableName(tableName).item(this.partiQLStatementFunction.localDBOutputConverter.internalToExternalAttributes(projectedAttributes)).build());
            }
            catch (DynamoDBLocalServiceException localServiceException) {
                batchStatementResponses.add(BatchGetProcessor.convertInternalExceptionToBatchStatementResponse(localServiceException, null));
            }
            if (keysInvolved.add(this.generateTableNameAndPrimaryKey(translatedPartiQLOperation))) continue;
            throw this.localPartiQLDbEnv.createValidationError(LocalDBClientExceptionMessage.DUPLICATE_ITEM_KEY.getMessage());
        }
        return batchStatementResponses;
    }
}

