/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.jobs;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBInputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.sqlite.TableSchemaInfo;
import software.amazon.dynamodb.services.local.shared.jobs.JobsRegister;
import software.amazon.dynamodb.services.local.shared.jobs.NamedJob;
import software.amazon.dynamodb.services.local.shared.jobs.TimeToLiveDeletionJob;

public class TimeToLiveDeletionJobScheduler
extends NamedJob {
    private final DynamoDbClient dynamoDbClient;
    private final LocalDBAccess dbAccess;
    private final AtomicBoolean shouldTerminate;
    private final LocalDBInputConverter inputConverter;

    public TimeToLiveDeletionJobScheduler(LocalDBAccess dbAccess, DynamoDbClient dynamoDbClient, LocalDBInputConverter inputConverter, JobsRegister jobs) {
        super(jobs);
        this.dynamoDbClient = dynamoDbClient;
        this.dbAccess = dbAccess;
        this.inputConverter = inputConverter;
        this.shouldTerminate = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob() {
        while (!this.shouldTerminate.get()) {
            LocalDBAccess localDBAccess = this.dbAccess;
            synchronized (localDBAccess) {
                for (Map.Entry<String, TableSchemaInfo> entry : this.dbAccess.fetchAllTablesWithTimeToLiveEnabled().entrySet()) {
                    TableSchemaInfo tableSchemaInfo;
                    String timeToLiveAttributeName;
                    String tableName = entry.getKey();
                    String timeToLiveJobName = TimeToLiveDeletionJob.jobName(tableName, timeToLiveAttributeName = (tableSchemaInfo = entry.getValue()).getTimeToLiveAttributeName());
                    if (this.jobs.isRunning(timeToLiveJobName)) continue;
                    TimeToLiveDeletionJob task = new TimeToLiveDeletionJob(tableName, tableSchemaInfo, timeToLiveAttributeName, this.dynamoDbClient, this.inputConverter, this.dbAccess, this.jobs);
                    this.jobs.schedule(task);
                }
            }
            this.sleepFor(LocalDBUtils.DELAY_BEFORE_SCHEDULING_JOBS_AGAIN);
        }
    }

    @Override
    public String name() {
        return "ITEM-EXPIRY-DELETION-JOBS-SCHEDULER";
    }

    @Override
    public void cancel() {
        this.shouldTerminate.set(true);
    }
}

